/*
 * Decompiled with CFR 0.152.
 */
package com.groupbyinc.common.apache.commons.text.similarity;

import com.groupbyinc.common.apache.commons.text.similarity.SimilarityScore;
import java.util.HashSet;

public class JaccardSimilarity
implements SimilarityScore<Double> {
    @Override
    public Double apply(CharSequence left, CharSequence right) {
        if (left == null || right == null) {
            throw new IllegalArgumentException("Input cannot be null");
        }
        return (double)Math.round(this.calculateJaccardSimilarity(left, right) * 100.0) / 100.0;
    }

    private Double calculateJaccardSimilarity(CharSequence left, CharSequence right) {
        HashSet<String> intersectionSet = new HashSet<String>();
        HashSet<String> unionSet = new HashSet<String>();
        boolean unionFilled = false;
        int leftLength = left.length();
        int rightLength = right.length();
        if (leftLength == 0 || rightLength == 0) {
            return 0.0;
        }
        for (int leftIndex = 0; leftIndex < leftLength; ++leftIndex) {
            unionSet.add(String.valueOf(left.charAt(leftIndex)));
            for (int rightIndex = 0; rightIndex < rightLength; ++rightIndex) {
                if (!unionFilled) {
                    unionSet.add(String.valueOf(right.charAt(rightIndex)));
                }
                if (left.charAt(leftIndex) != right.charAt(rightIndex)) continue;
                intersectionSet.add(String.valueOf(left.charAt(leftIndex)));
            }
            unionFilled = true;
        }
        return Double.valueOf(intersectionSet.size()) / Double.valueOf(unionSet.size());
    }
}

