/*
 * Decompiled with CFR 0.152.
 */
package com.groupbyinc.common.jackson.jq.internal.functions;

import com.groupbyinc.common.jackson.databind.JsonNode;
import com.groupbyinc.common.jackson.databind.node.ArrayNode;
import com.groupbyinc.common.jackson.databind.node.JsonNodeType;
import com.groupbyinc.common.jackson.jq.Function;
import com.groupbyinc.common.jackson.jq.JsonQuery;
import com.groupbyinc.common.jackson.jq.Scope;
import com.groupbyinc.common.jackson.jq.exception.JsonQueryException;
import com.groupbyinc.common.jackson.jq.internal.BuiltinFunction;
import com.groupbyinc.common.jackson.jq.internal.misc.JsonNodeComparator;
import com.groupbyinc.common.jackson.jq.internal.misc.Preconditions;
import java.util.ArrayList;
import java.util.List;

@BuiltinFunction(value={"indices/1"})
public class IndicesFunction
implements Function {
    private static final JsonNodeComparator comparator = JsonNodeComparator.getInstance();

    @Override
    public List<JsonNode> apply(Scope scope, List<JsonQuery> args, JsonNode in) throws JsonQueryException {
        Preconditions.checkInputType("indices", in, JsonNodeType.STRING, JsonNodeType.ARRAY);
        ArrayList<JsonNode> out = new ArrayList<JsonNode>();
        for (JsonNode needle : args.get(0).apply(scope, in)) {
            ArrayNode indices = scope.getObjectMapper().createArrayNode();
            for (int index : IndicesFunction.indices(needle, in)) {
                indices.add(index);
            }
            out.add(indices);
        }
        return out;
    }

    public static List<Integer> indices(JsonNode needle, JsonNode haystack) throws JsonQueryException {
        ArrayList<Integer> result = new ArrayList<Integer>();
        if (needle.isTextual() && haystack.isTextual()) {
            String haystackText = haystack.asText();
            String needleText = needle.asText();
            int index = haystackText.indexOf(needleText);
            while (index >= 0) {
                result.add(index);
                index = haystackText.indexOf(needleText, index + 1);
            }
        } else if (needle.isArray() && haystack.isArray()) {
            if (needle.size() != 0) {
                for (int i = 0; i < haystack.size(); ++i) {
                    boolean match = true;
                    for (int j = 0; j < needle.size(); ++j) {
                        if (i + j < haystack.size() && comparator.compare(haystack.get(i + j), needle.get(j)) == 0) continue;
                        match = false;
                        break;
                    }
                    if (!match) continue;
                    result.add(i);
                }
            }
        } else if (haystack.isArray()) {
            for (int i = 0; i < haystack.size(); ++i) {
                if (comparator.compare(haystack.get(i), needle) != 0) continue;
                result.add(i);
            }
        } else {
            throw new JsonQueryException("indices() is not applicable to " + (Object)((Object)haystack.getNodeType()));
        }
        return result;
    }
}

