/*
 * Decompiled with CFR 0.152.
 */
package com.groupbyinc.common.jackson.jq.internal.functions;

import com.groupbyinc.common.jackson.databind.JsonNode;
import com.groupbyinc.common.jackson.databind.node.TextNode;
import com.groupbyinc.common.jackson.jq.Function;
import com.groupbyinc.common.jackson.jq.JsonQuery;
import com.groupbyinc.common.jackson.jq.Scope;
import com.groupbyinc.common.jackson.jq.exception.JsonQueryException;
import com.groupbyinc.common.jackson.jq.exception.JsonQueryTypeException;
import com.groupbyinc.common.jackson.jq.internal.BuiltinFunction;
import java.util.ArrayList;
import java.util.List;

@BuiltinFunction(value={"join/1"})
public class JoinFunction
implements Function {
    @Override
    public List<JsonNode> apply(Scope scope, List<JsonQuery> args, JsonNode in) throws JsonQueryException {
        ArrayList<JsonNode> out = new ArrayList<JsonNode>();
        for (JsonNode sep : args.get(0).apply(scope, in)) {
            JsonNode isep = null;
            StringBuilder builder = new StringBuilder();
            for (JsonNode item : in) {
                if (isep != null) {
                    if (isep.isTextual()) {
                        builder.append(isep.asText());
                    } else if (!isep.isNull()) {
                        throw new JsonQueryTypeException(new TextNode(builder.toString()), isep, "cannot be added");
                    }
                }
                if (item.isTextual()) {
                    builder.append(item.asText());
                } else if (!item.isNull()) {
                    if (item.isNumber() || item.isBoolean()) {
                        builder.append(item.toString());
                    } else {
                        throw new JsonQueryTypeException(new TextNode(builder.toString()), item, "cannot be added");
                    }
                }
                isep = sep;
            }
            out.add(new TextNode(builder.toString()));
        }
        return out;
    }
}

