/*
 * Decompiled with CFR 0.152.
 */
package com.groupbyinc.common.jackson.jq.internal.misc;

import java.nio.charset.StandardCharsets;

public class UnicodeUtils {
    public static int UTF8CharLength(byte ch) {
        if ((ch & 0x80) == 0) {
            return 1;
        }
        if ((ch & 0xE0) == 192) {
            return 2;
        }
        if ((ch & 0xF0) == 224) {
            return 3;
        }
        if ((ch & 0xF8) == 240) {
            return 4;
        }
        if ((ch & 0xFC) == 248) {
            return 5;
        }
        if ((ch & 0xFE) == 252) {
            return 6;
        }
        if ((ch & 0xC0) == 128) {
            throw new IllegalArgumentException(String.format("This is not a first byte of unicode charactor: %x", ch));
        }
        if ((ch & 0xFF) == 254 || (ch & 0xFF) == 255) {
            throw new IllegalArgumentException(String.format("This is a part of a byte order mark (BOM): %x", ch));
        }
        throw new IllegalArgumentException(String.format("This is an unknown UTF-8 byte: %x", ch));
    }

    public static int[] UTF8CharIndex(byte[] bytes) {
        int charLen;
        int[] r = new int[bytes.length + 1];
        int i_codepoint = 0;
        for (int i_utf8 = 0; i_utf8 < bytes.length; i_utf8 += charLen) {
            charLen = UnicodeUtils.UTF8CharLength(bytes[i_utf8]);
            for (int i = 0; i < charLen; ++i) {
                r[i_utf8 + i] = i_codepoint;
            }
            ++i_codepoint;
        }
        r[bytes.length] = i_codepoint;
        return r;
    }

    public static int lengthUtf8(String text) {
        return text.getBytes(StandardCharsets.UTF_8).length;
    }

    public static int lengthUtf32(String in) {
        return in.codePointCount(0, in.length());
    }

    public static String substringUtf32(String in, int begin, int end) {
        int utf16begin = in.offsetByCodePoints(0, begin);
        int utf16end = in.offsetByCodePoints(utf16begin, end - begin);
        return in.substring(utf16begin, utf16end);
    }
}

