/*
 * Decompiled with CFR 0.152.
 */
package com.groupbyinc.common.jackson.jq.internal.operators;

import com.groupbyinc.common.jackson.databind.JsonNode;
import com.groupbyinc.common.jackson.databind.ObjectMapper;
import com.groupbyinc.common.jackson.jq.exception.JsonQueryException;
import com.groupbyinc.common.jackson.jq.internal.misc.JsonNodeUtils;
import com.groupbyinc.common.jackson.jq.internal.operators.BinaryOperator;

public class ModuloOperator
implements BinaryOperator {
    @Override
    public JsonNode apply(ObjectMapper mapper, JsonNode lhs, JsonNode rhs) throws JsonQueryException {
        if (lhs.isIntegralNumber() && rhs.isIntegralNumber()) {
            long divisor = rhs.asLong();
            long dividend = lhs.asLong();
            if (divisor == 0L) {
                throw JsonQueryException.format("number (%s) and number (%s) cannot be divided (remainder) because the divisor is zero", dividend, divisor);
            }
            return JsonNodeUtils.asNumericNode(dividend % divisor);
        }
        throw new JsonQueryException("to calculate module, both sides must be a integer");
    }

    @Override
    public String image() {
        return "%";
    }
}

