/*
 * Decompiled with CFR 0.152.
 */
package com.groupbyinc.common.jackson.jq.internal.tree.binaryop;

import com.groupbyinc.common.jackson.jq.JsonQuery;
import com.groupbyinc.common.jackson.jq.internal.tree.binaryop.AlternativeOperator;
import com.groupbyinc.common.jackson.jq.internal.tree.binaryop.BooleanAndExpression;
import com.groupbyinc.common.jackson.jq.internal.tree.binaryop.BooleanOrExpression;
import com.groupbyinc.common.jackson.jq.internal.tree.binaryop.DivideExpression;
import com.groupbyinc.common.jackson.jq.internal.tree.binaryop.MinusExpression;
import com.groupbyinc.common.jackson.jq.internal.tree.binaryop.ModuloExpression;
import com.groupbyinc.common.jackson.jq.internal.tree.binaryop.MultiplyExpression;
import com.groupbyinc.common.jackson.jq.internal.tree.binaryop.PlusExpression;
import com.groupbyinc.common.jackson.jq.internal.tree.binaryop.assignment.Assignment;
import com.groupbyinc.common.jackson.jq.internal.tree.binaryop.assignment.ComplexAlternativeAssignment;
import com.groupbyinc.common.jackson.jq.internal.tree.binaryop.assignment.ComplexDivideAssignment;
import com.groupbyinc.common.jackson.jq.internal.tree.binaryop.assignment.ComplexMinusAssignment;
import com.groupbyinc.common.jackson.jq.internal.tree.binaryop.assignment.ComplexModuloAssignment;
import com.groupbyinc.common.jackson.jq.internal.tree.binaryop.assignment.ComplexMultiplyAssignment;
import com.groupbyinc.common.jackson.jq.internal.tree.binaryop.assignment.ComplexPlusAssignment;
import com.groupbyinc.common.jackson.jq.internal.tree.binaryop.assignment.UpdateAssignment;
import com.groupbyinc.common.jackson.jq.internal.tree.binaryop.comparison.CompareEqualTest;
import com.groupbyinc.common.jackson.jq.internal.tree.binaryop.comparison.CompareGreaterEqualTest;
import com.groupbyinc.common.jackson.jq.internal.tree.binaryop.comparison.CompareGreaterTest;
import com.groupbyinc.common.jackson.jq.internal.tree.binaryop.comparison.CompareLessEqualTest;
import com.groupbyinc.common.jackson.jq.internal.tree.binaryop.comparison.CompareLessTest;
import com.groupbyinc.common.jackson.jq.internal.tree.binaryop.comparison.CompareNotEqualTest;
import java.lang.reflect.Constructor;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Stack;

public abstract class BinaryOperatorExpression
extends JsonQuery {
    protected JsonQuery lhs;
    protected JsonQuery rhs;
    private String image;

    public BinaryOperatorExpression(JsonQuery lhs, JsonQuery rhs, String image) {
        this.lhs = lhs;
        this.rhs = rhs;
        this.image = image;
    }

    public String toString() {
        return String.format("(%s %s %s)", this.lhs, this.image, this.rhs);
    }

    public static JsonQuery buildTree(List<JsonQuery> exprs, List<Operator> operators) {
        if (exprs.size() != operators.size() + 1) {
            throw new IllegalArgumentException();
        }
        Stack<JsonQuery> stackExprs = new Stack<JsonQuery>();
        Stack<Operator> stackOperators = new Stack<Operator>();
        Iterator<JsonQuery> iterExpr = exprs.iterator();
        Iterator<Operator> iterOperator = operators.iterator();
        stackExprs.push(iterExpr.next());
        while (iterExpr.hasNext()) {
            Operator op1 = iterOperator.next();
            while (!stackOperators.isEmpty()) {
                Operator op2 = (Operator)((Object)stackOperators.peek());
                if (op1.precedence <= op2.precedence && (op1.precedence != op2.precedence || op1.associativity != Operator.Associativity.LEFT)) break;
                Operator op = (Operator)((Object)stackOperators.pop());
                JsonQuery rhs = (JsonQuery)stackExprs.pop();
                JsonQuery lhs = (JsonQuery)stackExprs.pop();
                stackExprs.push(op.buildTree(lhs, rhs));
            }
            stackOperators.push(op1);
            stackExprs.push(iterExpr.next());
        }
        while (!stackOperators.isEmpty()) {
            Operator op = (Operator)((Object)stackOperators.pop());
            JsonQuery rhs = (JsonQuery)stackExprs.pop();
            JsonQuery lhs = (JsonQuery)stackExprs.pop();
            stackExprs.push(op.buildTree(lhs, rhs));
        }
        return (JsonQuery)stackExprs.get(0);
    }

    public static enum Operator {
        ASSIGN("=", 6, Associativity.RIGHT, Assignment.class),
        UDPATE("|=", 6, Associativity.RIGHT, UpdateAssignment.class),
        DEFAULT_EQUAL("//=", 6, Associativity.RIGHT, ComplexAlternativeAssignment.class),
        PLUS_EQUAL("+=", 6, Associativity.RIGHT, ComplexPlusAssignment.class),
        MINUS_EQUAL("-=", 6, Associativity.RIGHT, ComplexMinusAssignment.class),
        TIMES_EQUAL("*=", 6, Associativity.RIGHT, ComplexMultiplyAssignment.class),
        DIVIDE_EQUAL("/=", 6, Associativity.RIGHT, ComplexDivideAssignment.class),
        MODULO_EQUAL("%=", 6, Associativity.RIGHT, ComplexModuloAssignment.class),
        DEFAULT("//", 5, Associativity.LEFT, AlternativeOperator.class),
        OR("or", 4, Associativity.LEFT, BooleanOrExpression.class),
        AND("and", 4, Associativity.LEFT, BooleanAndExpression.class),
        LESS_EQUAL("<=", 3, Associativity.LEFT, CompareLessEqualTest.class),
        LESS("<", 3, Associativity.LEFT, CompareLessTest.class),
        GREATER_EQUAL(">=", 3, Associativity.LEFT, CompareGreaterEqualTest.class),
        GREATER(">", 3, Associativity.LEFT, CompareGreaterTest.class),
        EQUAL("==", 3, Associativity.LEFT, CompareEqualTest.class),
        NOT_EQUAL("!=", 3, Associativity.LEFT, CompareNotEqualTest.class),
        PLUS("+", 2, Associativity.LEFT, PlusExpression.class),
        MINUS("-", 2, Associativity.LEFT, MinusExpression.class),
        MODULO("%", 1, Associativity.LEFT, ModuloExpression.class),
        DIVIDE("/", 1, Associativity.LEFT, DivideExpression.class),
        TIMES("*", 1, Associativity.LEFT, MultiplyExpression.class);

        public final String image;
        public final int precedence;
        public final Associativity associativity;
        public final Class<? extends BinaryOperatorExpression> clazz;
        public final Constructor<? extends BinaryOperatorExpression> constructor;
        private static Map<String, Operator> lookup;

        private Operator(String image, int precedence, Associativity associativity, Class<? extends BinaryOperatorExpression> clazz) {
            this.image = image;
            this.precedence = precedence;
            this.associativity = associativity;
            this.clazz = clazz;
            try {
                this.constructor = clazz.getConstructor(JsonQuery.class, JsonQuery.class);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }

        public static Operator fromImage(String image) {
            Operator op = lookup.get(image);
            if (op == null) {
                throw new IllegalArgumentException();
            }
            return op;
        }

        public JsonQuery buildTree(JsonQuery lhs, JsonQuery rhs) {
            try {
                return this.constructor.newInstance(lhs, rhs);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }

        static {
            lookup = new HashMap<String, Operator>();
            for (Operator op : Operator.values()) {
                lookup.put(op.image, op);
            }
        }

        public static enum Associativity {
            LEFT,
            RIGHT;

        }
    }
}

