/*
 * Decompiled with CFR 0.152.
 */
package com.mycomm.itool.WebAppModule.listener;

import com.mycomm.itool.WebAppModule.listener.ModuleScanner;
import com.mycomm.itool.WebAppModule.listener.WebModuleDestroyCleaner;
import com.mycomm.itool.WebAppModule.listener.WebModuleInitializer;
import com.mycomm.itool.WebAppModule.logs.LogSupporter;
import com.mycomm.itool.WebAppModule.logs.TheLogger;
import java.util.LinkedList;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;
import javax.servlet.ServletContext;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class WebModuleListener
implements ServletContextListener,
LogSupporter {
    private final List<WebModuleInitializer> initializers = new LinkedList<WebModuleInitializer>();
    private final List<WebModuleDestroyCleaner> cleaners = new LinkedList<WebModuleDestroyCleaner>();
    private final List<ModuleScanner> scanners = new LinkedList<ModuleScanner>();
    protected ServletContext servletContext;
    protected ServletContextEvent servletContextEvent;
    private boolean onetimeFlag = true;
    protected TheLogger logger;

    public void contextInitialized(ServletContextEvent sce) {
        this.servletContextEvent = sce;
        this.servletContext = sce.getServletContext();
        this.logger = this.loadLogger();
        this.LoadWebModuleInitializers(this.initializers);
        this.logger.debug("initializers:" + this.initializers);
        if (this.initializers != null && this.initializers.size() > 0) {
            this.logger.debug("initializers length:" + this.initializers.size());
            for (WebModuleInitializer initializer : this.initializers) {
                if (initializer == null) {
                    this.logger.debug("initializer is null!");
                    continue;
                }
                this.logger.debug("invoking initializer:" + initializer);
                try {
                    initializer.init(sce);
                }
                catch (Exception e) {
                    this.logger.error("Error happen when invoking initializer:" + initializer + ",error is:" + e.getMessage());
                }
                this.logger.debug("invoking initializer:" + initializer + " done!");
            }
        }
        this.LoadWebModuleScanner(this.scanners);
        this.logger.debug("scanners:" + this.scanners);
        if (this.onetimeFlag) {
            this.onetimeFlag = false;
            if (this.scanners != null && this.scanners.size() > 0) {
                this.logger.debug("scanners size:" + this.scanners.size());
                Timer triger = new Timer();
                long period = this.getScannerPeriod();
                period = period <= 0L ? 15000L : period;
                triger.schedule((TimerTask)new RemindTask(), 3000L, period);
            }
        }
    }

    public void contextDestroyed(ServletContextEvent sce) {
        this.LoadWebModuleCleaners(this.cleaners);
        this.logger.debug("cleaners:" + this.cleaners);
        if (this.cleaners != null && this.cleaners.size() > 0) {
            this.logger.debug("cleaners length:" + this.cleaners.size());
            for (WebModuleDestroyCleaner cleaner : this.cleaners) {
                if (cleaner == null) {
                    this.logger.debug("cleaner is null!");
                    continue;
                }
                this.logger.debug("invoking cleaner:" + cleaner);
                try {
                    cleaner.clean(sce);
                }
                catch (Exception e) {
                    this.logger.error("Error happen when invoking cleaner:" + cleaner + ",error is:" + e.getMessage());
                }
                this.logger.debug("invoking cleaner:" + cleaner + " done!");
            }
        }
        this.initializers.clear();
        this.cleaners.clear();
        this.scanners.clear();
    }

    public abstract void LoadWebModuleInitializers(List<WebModuleInitializer> var1);

    public abstract void LoadWebModuleCleaners(List<WebModuleDestroyCleaner> var1);

    public abstract void LoadWebModuleScanner(List<ModuleScanner> var1);

    public abstract long getScannerPeriod();

    class RemindTask
    extends TimerTask {
        RemindTask() {
        }

        public void run() {
            if (WebModuleListener.this.scanners == null) {
                return;
            }
            for (ModuleScanner scanner : WebModuleListener.this.scanners) {
                if (scanner == null) continue;
                WebModuleListener.this.logger.info("run scanner:" + scanner);
                try {
                    scanner.onScanning(WebModuleListener.this.servletContextEvent);
                }
                catch (Exception e) {
                    WebModuleListener.this.logger.error("error happen when invoking scanner:" + scanner + ",error is:" + e.getMessage());
                }
                WebModuleListener.this.logger.info("run scanner:" + scanner + " done!");
            }
        }
    }
}

