/*
 * Decompiled with CFR 0.152.
 */
package com.mycomm.itool.WebAppModule.utils;

import com.sun.image.codec.jpeg.JPEGCodec;
import com.sun.image.codec.jpeg.JPEGImageEncoder;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Random;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public final class ValidationCodeManager {
    private static final char[] CHARS = new char[]{'2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'J', 'K', 'L', 'M', 'N', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z'};
    private static Random random = new Random();

    private ValidationCodeManager() {
    }

    private static String getRandomString() {
        StringBuilder buffer = new StringBuilder();
        for (int i = 0; i < 6; ++i) {
            buffer.append(CHARS[random.nextInt(CHARS.length)]);
        }
        return buffer.toString();
    }

    private static Color getRandomColor() {
        return new Color(random.nextInt(255), random.nextInt(255), random.nextInt(255));
    }

    private static Color getReverseColor(Color c) {
        return new Color(255 - c.getRed(), 255 - c.getGreen(), 255 - c.getBlue());
    }

    public static void outputCaptcha(HttpServletRequest request, HttpServletResponse response, String sessionFlag) throws ServletException, IOException {
        response.setContentType("image/jpeg");
        String randomString = ValidationCodeManager.getRandomString();
        request.getSession(true).setAttribute(sessionFlag, (Object)randomString);
        int width = 100;
        int height = 30;
        Color color = ValidationCodeManager.getRandomColor();
        Color reverse = ValidationCodeManager.getReverseColor(color);
        BufferedImage bi = new BufferedImage(width, height, 1);
        Graphics2D g = bi.createGraphics();
        g.setFont(new Font("SansSerif", 1, 16));
        g.setColor(color);
        g.fillRect(0, 0, width, height);
        g.setColor(reverse);
        g.drawString(randomString, 18, 20);
        int n = random.nextInt(100);
        for (int i = 0; i < n; ++i) {
            g.drawRect(random.nextInt(width), random.nextInt(height), 1, 1);
        }
        ServletOutputStream out = response.getOutputStream();
        JPEGImageEncoder encoder = JPEGCodec.createJPEGEncoder((OutputStream)out);
        encoder.encode(bi);
        out.flush();
    }
}

