/*
 * Decompiled with CFR 0.152.
 */
package com.mycomm.itool.WebAppModule.utils;

import com.mycomm.IProtocol.beans.JDataTypes;
import com.mycomm.IProtocol.log.UniversalLogHolder;
import com.mycomm.itool.SystemUtil;
import java.lang.reflect.Field;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Enumeration;
import javax.servlet.ServletRequest;

public class WebInstanceBuilder {
    private static final SimpleDateFormat sdf_yyyy_MM_ddHH_mm_ss = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");

    public static void buildInstance(Object instance, ServletRequest request) {
        if (instance == null || request == null) {
            return;
        }
        Enumeration parameterNames = request.getParameterNames();
        Field[] fields = instance.getClass().getDeclaredFields();
        if (parameterNames == null || fields == null || fields.length <= 0) {
            return;
        }
        for (Field field : fields) {
            String fieldName;
            String fieldValue;
            JDataTypes fType;
            if (field == null || (fType = JDataTypes.getDataType((Field)field)) == null || SystemUtil.isTxtEmpty((String)(fieldValue = request.getParameter(fieldName = field.getName())))) continue;
            field.setAccessible(true);
            try {
                switch (fType) {
                    case JByte: {
                        if (fieldValue.length() != 1) break;
                        byte byteValue = (byte)fieldValue.charAt(0);
                        field.setByte(instance, byteValue);
                        break;
                    }
                    case JShort: {
                        if (fieldValue.length() > 5 || !SystemUtil.isNumberString((String)fieldValue)) break;
                        field.setShort(instance, Short.valueOf(fieldValue));
                        break;
                    }
                    case JFloat: {
                        if (!SystemUtil.isNumeric((String)fieldValue)) break;
                        field.setFloat(instance, Float.valueOf(fieldValue).floatValue());
                        break;
                    }
                    case JDouble: {
                        if (!SystemUtil.isNumeric((String)fieldValue)) break;
                        field.setDouble(instance, Float.valueOf(fieldValue).floatValue());
                        break;
                    }
                    case JInt: {
                        if (!SystemUtil.isNumberString((String)fieldValue)) break;
                        field.setInt(instance, Integer.valueOf(fieldValue));
                        break;
                    }
                    case JLong: {
                        if (!SystemUtil.isNumberString((String)fieldValue)) break;
                        field.setLong(instance, Long.valueOf(fieldValue));
                        break;
                    }
                    case JBoolean: {
                        if (!"1".equals(fieldValue.toLowerCase()) && !"yes".equals(fieldValue.toLowerCase()) && !"true".equals(fieldValue.toLowerCase()) && !"y".equals(fieldValue.toLowerCase()) && !"ok".equals(fieldValue.toLowerCase())) break;
                        field.setBoolean(instance, true);
                        break;
                    }
                    case JDate: {
                        if (SystemUtil.isNumberString((String)fieldValue)) {
                            field.set(instance, new Date(Long.valueOf(fieldValue)));
                            break;
                        }
                        field.set(instance, sdf_yyyy_MM_ddHH_mm_ss.parse(fieldValue));
                        break;
                    }
                    case JChar1: 
                    case JChar8: 
                    case JChar16: 
                    case JChar32: 
                    case JChar64: 
                    case JChar128: 
                    case JChar255: 
                    case JString: {
                        field.set(instance, fieldValue);
                        break;
                    }
                }
            }
            catch (IllegalArgumentException e) {
                UniversalLogHolder.e((String)WebInstanceBuilder.class.getSimpleName(), (String)("IllegalAccessException:" + e.getMessage()));
            }
            catch (IllegalAccessException ex) {
                UniversalLogHolder.e((String)WebInstanceBuilder.class.getSimpleName(), (String)("IllegalAccessException:" + ex.getMessage()));
            }
            catch (ParseException ex) {
                UniversalLogHolder.e((String)WebInstanceBuilder.class.getSimpleName(), (String)("ParseException:" + ex.getMessage()));
            }
        }
    }
}

