/*
 * Decompiled with CFR 0.152.
 */
package com.mycomm.itool.WebAppModule.listener;

import com.mycomm.itool.WebAppModule.listener.WebModuleDestroyCleaner;
import com.mycomm.itool.WebAppModule.listener.WebModuleInitializer;
import com.mycomm.itool.WebAppModule.listener.WebModuleListener;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractWebModuleListener
extends WebModuleListener {
    private final Map<String, String> vars = new HashMap<String, String>();
    private String theDocBase;

    @Override
    public void LoadWebModuleInitializers(List<WebModuleInitializer> initializers) {
        this.addMoreInitializers(initializers);
    }

    @Override
    public void LoadWebModuleCleaners(List<WebModuleDestroyCleaner> cleaners) {
        this.addMoreCleaners(cleaners);
    }

    public abstract void addMoreInitializers(List<WebModuleInitializer> var1);

    public abstract void addMoreCleaners(List<WebModuleDestroyCleaner> var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Map<String, String> getSystemInitialeVars() {
        if (this.vars.size() > 0) {
            return this.vars;
        }
        InputStream fis = null;
        String path = Thread.currentThread().getContextClassLoader().getResource("").getPath() + "conf" + File.separator;
        this.logger.info("init file directory is:" + path);
        File confFolder = new File(path);
        if (!confFolder.isDirectory()) {
            return this.vars;
        }
        if (!confFolder.exists()) {
            return this.vars;
        }
        File[] fs = confFolder.listFiles();
        if (fs == null || fs.length == 0) {
            return this.vars;
        }
        this.logger.debug("there are " + fs.length + " properties files in the config Directory!");
        for (File f : fs) {
            if (!f.getAbsolutePath().endsWith("properties")) continue;
            try {
                Properties properties = new Properties();
                this.logger.info("loading " + f.getName() + ".........");
                fis = new FileInputStream(f);
                properties.load(fis);
                this.mergeVars(properties);
            }
            catch (FileNotFoundException e) {
                this.logger.error(e.getMessage());
            }
            catch (IOException e) {
                this.logger.error(e.getMessage());
            }
            finally {
                try {
                    if (fis != null) {
                        fis.close();
                    }
                }
                catch (IOException ex) {
                    this.logger.error(ex.getMessage());
                }
            }
        }
        this.logger.debug("totally " + this.vars.size() + " config items in all properties config files !");
        return this.vars;
    }

    protected String getTheDocBase() {
        if (this.theDocBase != null) {
            return this.theDocBase;
        }
        this.theDocBase = this.servletContext.getRealPath("");
        if (!this.theDocBase.endsWith(File.separator)) {
            this.theDocBase = this.theDocBase + File.separator;
        }
        this.logger.info("init theDocBase:" + this.theDocBase);
        return this.theDocBase;
    }

    private void mergeVars(Properties ps) {
        if (ps == null) {
            return;
        }
        Set<String> keys = ps.stringPropertyNames();
        for (String mykey : keys) {
            if (mykey == null || "".equals(mykey) || ps.get(mykey) == null) continue;
            this.vars.put(mykey, ps.get(mykey).toString());
        }
    }
}

