/*
 * Decompiled with CFR 0.152.
 */
package com.mycomm.itool.WebAppModule.listener.T;

import com.mycomm.itool.WebAppModule.listener.T.TCleaner;
import com.mycomm.itool.WebAppModule.listener.T.TInitializer;
import com.mycomm.itool.WebAppModule.listener.T.TListener;
import com.mycomm.itool.WebAppModule.listener.T.TScanner;
import com.mycomm.itool.WebAppModule.logs.TheLogger;
import java.util.LinkedList;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class MyTListener<T>
implements TListener<T> {
    private final List<TInitializer> initializers = new LinkedList<TInitializer>();
    private final List<TCleaner> cleaners = new LinkedList<TCleaner>();
    private final List<TScanner> scanners = new LinkedList<TScanner>();
    protected TheLogger logger;
    private boolean onetimeFlag = true;
    private T parameter;

    @Override
    public void TCreated(T t) {
        this.parameter = t;
        this.logger = this.loadLogger();
        this.LoadInitializers(this.initializers);
        this.logger.debug("initializers:" + this.initializers);
        if (this.initializers != null && this.initializers.size() > 0) {
            this.logger.debug("initializers length:" + this.initializers.size());
            for (TInitializer initializer : this.initializers) {
                if (initializer == null) {
                    this.logger.debug("initializer is null!");
                    continue;
                }
                this.logger.debug("invoking initializer:" + initializer);
                try {
                    initializer.onInit(t);
                }
                catch (Exception e) {
                    this.logger.error("Error happen when invoking initializer:" + initializer + ",error is:" + e.getMessage());
                }
                this.logger.debug("invoking initializer:" + initializer + " done!");
            }
        }
        this.LoadScanner(this.scanners);
        this.logger.debug("scanners:" + this.scanners);
        if (this.onetimeFlag) {
            this.onetimeFlag = false;
            if (this.scanners != null && this.scanners.size() > 0) {
                this.logger.debug("scanners size:" + this.scanners.size());
                Timer triger = new Timer();
                long period = this.getScannerPeriod();
                period = period <= 0L ? 15000L : period;
                triger.schedule((TimerTask)new RemindTask(), 3000L, period);
            }
        }
    }

    @Override
    public void TDestroyed(T t) {
        this.LoadCleaners(this.cleaners);
        this.logger.debug("cleaners:" + this.cleaners);
        if (this.cleaners != null && this.cleaners.size() > 0) {
            this.logger.debug("cleaners length:" + this.cleaners.size());
            for (TCleaner cleaner : this.cleaners) {
                if (cleaner == null) {
                    this.logger.debug("cleaner is null!");
                    continue;
                }
                this.logger.debug("invoking cleaner:" + cleaner);
                try {
                    cleaner.onClean(t);
                }
                catch (Exception e) {
                    this.logger.error("Error happen when invoking cleaner:" + cleaner + ",error is:" + e.getMessage());
                }
                this.logger.debug("invoking cleaner:" + cleaner + " done!");
            }
        }
        this.initializers.clear();
        this.cleaners.clear();
        this.scanners.clear();
    }

    public abstract void LoadInitializers(List<TInitializer> var1);

    public abstract void LoadScanner(List<TScanner> var1);

    public abstract void LoadCleaners(List<TCleaner> var1);

    public abstract long getScannerPeriod();

    class RemindTask
    extends TimerTask {
        RemindTask() {
        }

        public void run() {
            if (MyTListener.this.scanners == null) {
                return;
            }
            for (TScanner scanner : MyTListener.this.scanners) {
                if (scanner == null) continue;
                MyTListener.this.logger.info("run scanner:" + scanner);
                try {
                    scanner.onScan(MyTListener.this.parameter);
                }
                catch (Exception e) {
                    MyTListener.this.logger.error("error happen when invoking scanner:" + scanner + ",error is:" + e.getMessage());
                }
                MyTListener.this.logger.info("run scanner:" + scanner + " done!");
            }
        }
    }
}

