/*
 * Decompiled with CFR 0.152.
 */
package com.hb0730.https.support.hutool;

import cn.hutool.core.io.IoUtil;
import cn.hutool.core.net.url.UrlBuilder;
import cn.hutool.http.HttpRequest;
import cn.hutool.http.HttpResponse;
import cn.hutool.http.Method;
import com.hb0730.https.config.HttpConfig;
import com.hb0730.https.constants.Constants;
import com.hb0730.https.exception.HttpException;
import com.hb0730.https.inter.AbstractAsyncHttp;
import com.hb0730.https.support.callback.HttpCallback;
import com.hb0730.https.support.hutool.IHutoolHttp;
import com.hb0730.https.utils.StringUtils;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.Map;
import org.apache.hc.client5.http.ClientProtocolException;

public class HutoolAsyncImpl
extends AbstractAsyncHttp
implements IHutoolHttp {
    public HutoolAsyncImpl() {
        this(HttpConfig.builder().build());
    }

    public HutoolAsyncImpl(HttpConfig httpConfig) {
        super(httpConfig);
    }

    @Override
    public void get(String url, HttpCallback httpCallback) {
        this.get(url, null, httpCallback);
    }

    @Override
    public void get(String url, Map<String, String> params, HttpCallback httpCallback) {
        if (StringUtils.isEmpty(url)) {
            throw new HttpException("url missing");
        }
        UrlBuilder builder = this.urlBuilder(url, params, this.httpConfig.getCharset(), this.httpConfig.isEncode());
        HttpRequest request = this.getHttpRequest(builder, Method.GET, this.httpConfig, this.header);
        this.response(httpCallback, request);
    }

    @Override
    public void post(String url, HttpCallback httpCallback) {
        this.post(url, (String)null, httpCallback);
    }

    @Override
    public void post(String url, String dataJson, HttpCallback httpCallback) {
        if (StringUtils.isEmpty(url)) {
            throw new HttpException("url missing");
        }
        UrlBuilder builder = this.urlBuilder(url, null, this.httpConfig.getCharset(), this.httpConfig.isEncode());
        HttpRequest request = this.getHttpRequest(builder, Method.POST, this.httpConfig, this.header);
        request.body(dataJson, this.getContentType("application/json; charset=utf-8"));
        this.response(httpCallback, request);
    }

    @Override
    public void post(String url, Map<String, String> formdata, HttpCallback httpCallback) {
        if (StringUtils.isEmpty(url)) {
            throw new HttpException("url missing");
        }
        UrlBuilder builder = this.urlBuilder(url, null, this.httpConfig.getCharset(), this.httpConfig.isEncode());
        HttpRequest request = this.getHttpRequest(builder, Method.POST, this.httpConfig, this.header);
        request.formStr(formdata);
        request.contentType(this.getContentType("application/x-www-form-urlencoded; charset=utf-8"));
        this.response(httpCallback, request);
    }

    private void response(HttpCallback httpCallback, HttpRequest request) {
        try (HttpResponse response = request.executeAsync();){
            if (response.isOk()) {
                String body = IoUtil.read((InputStream)response.bodyStream(), (Charset)Constants.DEFAULT_ENCODING);
                httpCallback.success(body);
            } else {
                httpCallback.failure((Exception)new ClientProtocolException("Unexpected response status: " + response.getStatus()));
            }
        }
        catch (IOException e) {
            httpCallback.failure(e);
        }
    }

    private String getContentType(String defaultContentType) {
        if (StringUtils.isBlank(this.httpConfig.getContentType())) {
            return defaultContentType;
        }
        return this.httpConfig.getContentType();
    }
}

