/*
 * Decompiled with CFR 0.152.
 */
package com.hb0730.https;

import com.hb0730.https.HttpHeader;
import com.hb0730.https.config.HttpConfig;
import com.hb0730.https.exception.HttpException;
import com.hb0730.https.inter.AbstractSyncHttp;
import com.hb0730.https.inter.SyncHttp;
import com.hb0730.https.support.httpclient.HttpClientSyncImpl;
import com.hb0730.https.support.hutool.HutoolSyncImpl;
import com.hb0730.https.support.okhttp3.OkHttp3SyncImpl;
import com.hb0730.https.utils.ClassUtils;
import java.io.InputStream;
import java.util.Map;

public class HttpSync
implements SyncHttp {
    private static AbstractSyncHttp proxy;

    private void selectHttpProxy() {
        AbstractSyncHttp defaultProxy = null;
        ClassLoader classLoader = HttpSync.class.getClassLoader();
        if (ClassUtils.isPresent("org.apache.http.impl.client.HttpClients", classLoader)) {
            defaultProxy = this.getHttpProxy(HttpClientSyncImpl.class);
        }
        if (ClassUtils.isPresent("okhttp3.OkHttpClient", classLoader)) {
            defaultProxy = this.getHttpProxy(OkHttp3SyncImpl.class);
        }
        if (ClassUtils.isPresent("cn.hutool.http.HttpRequest", classLoader)) {
            defaultProxy = this.getHttpProxy(HutoolSyncImpl.class);
        }
        if (defaultProxy == null) {
            throw new HttpException("Has no HttpImpl defined in environment!");
        }
        proxy = defaultProxy;
    }

    private <T extends AbstractSyncHttp> AbstractSyncHttp getHttpProxy(Class<T> clazz) {
        try {
            return (AbstractSyncHttp)clazz.newInstance();
        }
        catch (Throwable e) {
            return null;
        }
    }

    private synchronized void checkHttpNotNull(SyncHttp proxy) {
        if (null == proxy) {
            this.selectHttpProxy();
        }
    }

    public HttpSync setHttp(AbstractSyncHttp http) {
        proxy = http;
        return this;
    }

    public HttpSync setHttpConfig(HttpConfig config) {
        this.checkHttpNotNull(proxy);
        if (null == config) {
            config = HttpConfig.builder().timeout(3000L).build();
        }
        proxy.setHttpConfig(config);
        return this;
    }

    public HttpSync setHeader(HttpHeader header) {
        this.checkHttpNotNull(proxy);
        proxy.setHeader(header);
        return this;
    }

    @Override
    public String get(String url) {
        this.checkHttpNotNull(proxy);
        return proxy.get(url);
    }

    @Override
    public String get(String url, Map<String, String> params) {
        this.checkHttpNotNull(proxy);
        return proxy.get(url, params);
    }

    @Override
    public String post(String url) {
        this.checkHttpNotNull(proxy);
        return proxy.post(url);
    }

    @Override
    public String post(String url, String data) {
        this.checkHttpNotNull(proxy);
        return proxy.post(url, data);
    }

    @Override
    public InputStream postStream(String url, String dataJson) {
        this.checkHttpNotNull(proxy);
        return proxy.postStream(url, dataJson);
    }

    @Override
    public String post(String url, Map<String, String> params) {
        this.checkHttpNotNull(proxy);
        return proxy.post(url, params);
    }
}

