/*
 * Decompiled with CFR 0.152.
 */
package com.hb0730.https.support.hutool;

import cn.hutool.core.net.url.UrlBuilder;
import cn.hutool.core.net.url.UrlQuery;
import cn.hutool.http.HttpRequest;
import cn.hutool.http.Method;
import com.hb0730.https.HttpHeader;
import com.hb0730.https.config.HttpConfig;
import java.nio.charset.Charset;
import java.util.Map;

public interface IHutoolHttp {
    default public UrlBuilder urlBuilder(String url, Map<String, String> queryParams, Charset charset, boolean isEnabled) {
        UrlBuilder builder = UrlBuilder.of((String)url, (Charset)charset);
        UrlQuery query = new UrlQuery(queryParams, isEnabled);
        return builder.setQuery(query);
    }

    default public HttpRequest getHttpRequest(UrlBuilder builder, Method method, HttpConfig config, HttpHeader header) {
        HttpRequest request = new HttpRequest(builder);
        request.method(method);
        request.setProxy(config.getProxy());
        request.setConnectionTimeout(Math.toIntExact(config.getTimeout()));
        if (null != header) {
            request.addHeaders(header.getHeaders());
        }
        return request;
    }
}

