/*
 * Decompiled with CFR 0.152.
 */
package com.hb0730.https.support.hutool;

import cn.hutool.core.net.url.UrlBuilder;
import cn.hutool.http.HttpRequest;
import cn.hutool.http.HttpResponse;
import cn.hutool.http.Method;
import com.hb0730.https.HttpHeader;
import com.hb0730.https.config.HttpConfig;
import com.hb0730.https.inter.AbstractSyncHttp;
import com.hb0730.https.support.hutool.IHutoolHttp;
import com.hb0730.https.utils.StringUtils;
import java.io.InputStream;
import java.util.Map;

public class HutoolSyncImpl
extends AbstractSyncHttp
implements IHutoolHttp {
    public HutoolSyncImpl() {
        this(HttpConfig.builder().build());
    }

    public HutoolSyncImpl(HttpConfig httpConfig) {
        super(httpConfig);
    }

    @Override
    public String get(String url) {
        return this.get(url, null);
    }

    @Override
    public String get(String url, Map<String, String> params) {
        if (StringUtils.isEmpty(url)) {
            return "";
        }
        UrlBuilder builder = this.urlBuilder(url, params, this.httpConfig.getCharset(), this.httpConfig.isEncode());
        HttpRequest request = this.getRequest(builder, Method.GET);
        HttpResponse execute = request.execute();
        if (execute.isOk()) {
            return execute.body();
        }
        return "";
    }

    @Override
    public String post(String url) {
        return this.post(url, (String)null);
    }

    @Override
    public String post(String url, String dataJson) {
        return this.post(url, dataJson, null);
    }

    @Override
    public String post(String url, String dataJson, HttpHeader header) {
        if (StringUtils.isEmpty(url)) {
            return "";
        }
        UrlBuilder builder = this.urlBuilder(url, null, this.httpConfig.getCharset(), this.httpConfig.isEncode());
        HttpRequest request = this.getRequest(builder, Method.POST);
        request.addHeaders(header.getHeaders());
        request.body(dataJson, this.getContentType("application/json; charset=utf-8"));
        HttpResponse execute = request.execute();
        if (execute.isOk()) {
            return execute.body();
        }
        return "";
    }

    @Override
    public InputStream postStream(String url, String dataJson) {
        if (StringUtils.isEmpty(url)) {
            return null;
        }
        UrlBuilder builder = this.urlBuilder(url, null, this.httpConfig.getCharset(), this.httpConfig.isEncode());
        HttpRequest request = this.getRequest(builder, Method.POST);
        request.body(dataJson, this.getContentType("application/json; charset=utf-8"));
        HttpResponse execute = request.execute();
        if (execute.isOk()) {
            return execute.bodyStream();
        }
        return null;
    }

    @Override
    public String post(String url, Map<String, String> formdata) {
        return this.post(url, formdata, null);
    }

    @Override
    public String post(String url, Map<String, String> formData, HttpHeader header) {
        if (StringUtils.isEmpty(url)) {
            return "";
        }
        UrlBuilder builder = this.urlBuilder(url, null, this.httpConfig.getCharset(), this.httpConfig.isEncode());
        HttpRequest request = this.getRequest(builder, Method.POST);
        request.formStr(formData);
        request.contentType(this.getContentType("application/x-www-form-urlencoded; charset=utf-8"));
        request.addHeaders(header.getHeaders());
        HttpResponse execute = request.execute();
        if (execute.isOk()) {
            return execute.body();
        }
        return "";
    }

    private HttpRequest getRequest(UrlBuilder url, Method method) {
        return this.getHttpRequest(url, method, this.getHttpConfig() == null ? HttpConfig.builder().build() : this.getHttpConfig(), this.getHeader());
    }

    private String getContentType(String defaultContentType) {
        if (StringUtils.isBlank(this.httpConfig.getContentType())) {
            return defaultContentType;
        }
        return this.httpConfig.getContentType();
    }
}

