/*
 * Decompiled with CFR 0.152.
 */
package com.hb0730.https;

import com.hb0730.https.HttpHeader;
import com.hb0730.https.HttpSync;
import com.hb0730.https.config.HttpConfig;
import com.hb0730.https.exception.HttpException;
import com.hb0730.https.inter.AbstractAsyncHttp;
import com.hb0730.https.inter.AsyncHttp;
import com.hb0730.https.support.callback.HttpCallback;
import com.hb0730.https.support.httpclient.HttpClientAsyncImpl;
import com.hb0730.https.support.hutool.HutoolAsyncImpl;
import com.hb0730.https.support.okhttp3.OkHttp3AsyncImpl;
import com.hb0730.https.utils.ClassUtils;
import java.util.Map;

public class HttpAsync
implements AsyncHttp {
    private AbstractAsyncHttp proxy;

    private void selectHttpProxy() {
        AbstractAsyncHttp defaultProxy = null;
        ClassLoader classLoader = HttpSync.class.getClassLoader();
        if (ClassUtils.isPresent("org.apache.hc.client5.http.impl.async.HttpAsyncClients", classLoader)) {
            defaultProxy = this.getHttpProxy(HttpClientAsyncImpl.class);
        }
        if (ClassUtils.isPresent("okhttp3.OkHttpClient", classLoader)) {
            defaultProxy = this.getHttpProxy(OkHttp3AsyncImpl.class);
        }
        if (ClassUtils.isPresent("cn.hutool.http.HttpRequest", classLoader)) {
            defaultProxy = this.getHttpProxy(HutoolAsyncImpl.class);
        }
        if (defaultProxy == null) {
            throw new HttpException("Has no HttpImpl defined in environment!");
        }
        this.proxy = defaultProxy;
    }

    private <T extends AbstractAsyncHttp> AbstractAsyncHttp getHttpProxy(Class<T> clazz) {
        try {
            return (AbstractAsyncHttp)clazz.newInstance();
        }
        catch (Throwable e) {
            return null;
        }
    }

    private synchronized void checkHttpNotNull(AsyncHttp proxy) {
        if (null == proxy) {
            this.selectHttpProxy();
        }
    }

    public HttpAsync setHttp(AbstractAsyncHttp http) {
        this.proxy = http;
        return this;
    }

    public HttpAsync setHttpConfig(HttpConfig config) {
        this.checkHttpNotNull(this.proxy);
        if (null == config) {
            config = HttpConfig.builder().timeout(3000L).build();
        }
        this.proxy.setHttpConfig(config);
        return this;
    }

    public HttpAsync setHeader(HttpHeader header) {
        this.checkHttpNotNull(this.proxy);
        this.proxy.setHeader(header);
        return this;
    }

    @Override
    public void get(String url, HttpCallback httpCallback) {
        this.checkHttpNotNull(this.proxy);
        this.proxy.get(url, httpCallback);
    }

    @Override
    public void get(String url, Map<String, String> params, HttpCallback httpCallback) {
        this.checkHttpNotNull(this.proxy);
        this.proxy.get(url, params, httpCallback);
    }

    @Override
    public void post(String url, HttpCallback httpCallback) {
        this.checkHttpNotNull(this.proxy);
        this.proxy.post(url, httpCallback);
    }

    @Override
    public void post(String url, String data, HttpCallback httpCallback) {
        this.checkHttpNotNull(this.proxy);
        this.proxy.post(url, data, httpCallback);
    }

    @Override
    public void post(String url, Map<String, String> params, HttpCallback httpCallback) {
        this.checkHttpNotNull(this.proxy);
        this.proxy.post(url, params, httpCallback);
    }
}

