/*
 * Decompiled with CFR 0.152.
 */
package com.hb0730.https.support;

import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.List;
import java.util.Map;

public class SimpleHttpResponse {
    private boolean success;
    private Map<String, List<String>> headers;
    private byte[] body;

    public String getBodyStr() {
        return this.getBodyStr(StandardCharsets.UTF_8);
    }

    public String getBodyStr(Charset charset) {
        return new String(this.body, charset);
    }

    public SimpleHttpResponse body(byte[] body) {
        this.body = body;
        return this;
    }

    public static SimpleHttpResponseBuilder builder() {
        return new SimpleHttpResponseBuilder();
    }

    public boolean isSuccess() {
        return this.success;
    }

    public Map<String, List<String>> getHeaders() {
        return this.headers;
    }

    public byte[] getBody() {
        return this.body;
    }

    public void setSuccess(boolean success) {
        this.success = success;
    }

    public void setHeaders(Map<String, List<String>> headers) {
        this.headers = headers;
    }

    public void setBody(byte[] body) {
        this.body = body;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SimpleHttpResponse)) {
            return false;
        }
        SimpleHttpResponse other = (SimpleHttpResponse)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isSuccess() != other.isSuccess()) {
            return false;
        }
        Map<String, List<String>> this$headers = this.getHeaders();
        Map<String, List<String>> other$headers = other.getHeaders();
        if (this$headers == null ? other$headers != null : !((Object)this$headers).equals(other$headers)) {
            return false;
        }
        return Arrays.equals(this.getBody(), other.getBody());
    }

    protected boolean canEqual(Object other) {
        return other instanceof SimpleHttpResponse;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isSuccess() ? 79 : 97);
        Map<String, List<String>> $headers = this.getHeaders();
        result = result * 59 + ($headers == null ? 43 : ((Object)$headers).hashCode());
        result = result * 59 + Arrays.hashCode(this.getBody());
        return result;
    }

    public String toString() {
        return "SimpleHttpResponse(success=" + this.isSuccess() + ", headers=" + this.getHeaders() + ", body=" + Arrays.toString(this.getBody()) + ")";
    }

    public SimpleHttpResponse(boolean success, Map<String, List<String>> headers, byte[] body) {
        this.success = success;
        this.headers = headers;
        this.body = body;
    }

    public SimpleHttpResponse() {
    }

    public static class SimpleHttpResponseBuilder {
        private boolean success;
        private Map<String, List<String>> headers;
        private byte[] body;

        SimpleHttpResponseBuilder() {
        }

        public SimpleHttpResponseBuilder success(boolean success) {
            this.success = success;
            return this;
        }

        public SimpleHttpResponseBuilder headers(Map<String, List<String>> headers) {
            this.headers = headers;
            return this;
        }

        public SimpleHttpResponseBuilder body(byte[] body) {
            this.body = body;
            return this;
        }

        public SimpleHttpResponse build() {
            return new SimpleHttpResponse(this.success, this.headers, this.body);
        }

        public String toString() {
            return "SimpleHttpResponse.SimpleHttpResponseBuilder(success=" + this.success + ", headers=" + this.headers + ", body=" + Arrays.toString(this.body) + ")";
        }
    }
}

