/*
 * Decompiled with CFR 0.152.
 */
package com.hb0730.https.support.okhttp3;

import com.hb0730.https.config.HttpConfig;
import com.hb0730.https.exception.HttpException;
import com.hb0730.https.inter.AbstractAsyncHttp;
import com.hb0730.https.support.SimpleHttpResponse;
import com.hb0730.https.support.callback.HttpCallback;
import com.hb0730.https.support.okhttp3.IOkhttp3;
import com.hb0730.https.utils.StringUtils;
import java.io.IOException;
import java.util.Map;
import okhttp3.Call;
import okhttp3.Callback;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;
import okhttp3.ResponseBody;

public class OkHttp3AsyncImpl
extends AbstractAsyncHttp
implements IOkhttp3 {
    private final OkHttpClient.Builder clientBuilder;

    public OkHttp3AsyncImpl() {
        this(new HttpConfig());
    }

    public OkHttp3AsyncImpl(HttpConfig config) {
        this(new OkHttpClient().newBuilder(), config);
    }

    public OkHttp3AsyncImpl(OkHttpClient.Builder clientBuilder, HttpConfig config) {
        super(config);
        this.clientBuilder = clientBuilder;
    }

    @Override
    public void get(String url, HttpCallback httpCallback) {
        this.get(url, null, httpCallback);
    }

    @Override
    public void get(String url, Map<String, String> params, HttpCallback httpCallback) {
        if (StringUtils.isBlank(url)) {
            throw new HttpException("url missing");
        }
        Request.Builder builder = this.getRequestBuilder(url, params, this.httpConfig.isEncode(), this.header == null ? null : this.header.getHeaders());
        this.exec(builder, httpCallback);
    }

    @Override
    public void post(String url, HttpCallback httpCallback) {
        this.post(url, "", httpCallback);
    }

    @Override
    public void post(String url, String dataJson, HttpCallback httpCallback) {
        if (StringUtils.isBlank(url)) {
            throw new HttpException("url missing");
        }
        Request.Builder requestBuilder = this.postJsonRequestBuild(url, dataJson, StringUtils.isBlank(this.httpConfig.getContentType()) ? JSON_UTF_8 : MediaType.parse((String)this.httpConfig.getContentType()), this.header == null ? null : this.header.getHeaders());
        this.exec(requestBuilder, httpCallback);
    }

    @Override
    public void post(String url, Map<String, String> formdata, HttpCallback httpCallback) {
        if (StringUtils.isBlank(url)) {
            throw new HttpException("url missing");
        }
        Request.Builder requestBuilder = this.postFormDataRequestBuild(url, formdata, this.httpConfig.isEncode(), StringUtils.isBlank(this.httpConfig.getContentType()) ? FORM_DATA_UTF_8 : MediaType.parse((String)this.httpConfig.getContentType()), null == this.header ? null : this.header.getHeaders());
        this.exec(requestBuilder, httpCallback);
    }

    private void exec(Request.Builder requestBuilder, final HttpCallback httpCallback) {
        Request request = requestBuilder.build();
        OkHttpClient httpClient = this.buildClient(this.clientBuilder, this.httpConfig);
        httpClient.newCall(request).enqueue(new Callback(){

            public void onFailure(Call call, IOException e) {
                if (null == httpCallback) {
                    return;
                }
                httpCallback.failure(e);
            }

            public void onResponse(Call call, Response response) throws IOException {
                if (null == httpCallback) {
                    return;
                }
                try (ResponseBody responseBody = response.body();){
                    SimpleHttpResponse httpResponse = SimpleHttpResponse.builder().success(response.isSuccessful()).headers(response.headers().toMultimap()).body(responseBody == null ? null : responseBody.bytes()).build();
                    httpCallback.response(httpResponse);
                }
            }
        });
    }
}

