/*
 * Decompiled with CFR 0.152.
 */
package com.hb0730.https.support.httpclient;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.convert.Convert;
import cn.hutool.core.io.FileUtil;
import cn.hutool.core.io.IoUtil;
import cn.hutool.core.util.ArrayUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import com.hb0730.https.HttpHeader;
import com.hb0730.https.config.HttpConfig;
import com.hb0730.https.config.Interceptor;
import com.hb0730.https.exception.HttpException;
import com.hb0730.https.support.AbstractSimpleHttp;
import com.hb0730.https.support.SimpleHttpResponse;
import com.hb0730.https.utils.CollectionUtils;
import com.hb0730.https.utils.MapUtils;
import com.hb0730.https.utils.StringUtils;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.http.HttpEntity;
import org.apache.http.HttpHost;
import org.apache.http.HttpRequest;
import org.apache.http.NameValuePair;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.methods.RequestBuilder;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.client.utils.URLEncodedUtils;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.entity.mime.FormBodyPartBuilder;
import org.apache.http.entity.mime.MultipartEntityBuilder;
import org.apache.http.entity.mime.content.ContentBody;
import org.apache.http.entity.mime.content.FileBody;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.message.BasicNameValuePair;

public class HttpClientImpl
extends AbstractSimpleHttp {
    private final CloseableHttpClient httpClient;

    public HttpClientImpl() {
        this(HttpClients.createDefault());
    }

    public HttpClientImpl(CloseableHttpClient httpClient) {
        this(HttpConfig.builder().build(), httpClient);
    }

    public HttpClientImpl(HttpConfig httpConfig, CloseableHttpClient httpClient) {
        super(httpConfig);
        this.httpClient = httpClient;
    }

    @Override
    public SimpleHttpResponse get(String url) {
        return this.get(url, null);
    }

    @Override
    public SimpleHttpResponse get(String url, Map<String, String> params) {
        URI uri;
        URIBuilder builder;
        if (StringUtils.isEmpty(url)) {
            throw new HttpException("url missing");
        }
        try {
            builder = new URIBuilder(url);
            if (!CollectionUtils.isEmpty(params)) {
                ArrayList query = new ArrayList(params.size());
                params.forEach((k, v) -> query.add(new BasicNameValuePair(k, v)));
                if (this.httpConfig.isEncode()) {
                    String queryParams = URLEncodedUtils.format(query, (Charset)this.getCharSet());
                    builder.setCustomQuery(queryParams);
                } else {
                    builder.addParameters(query);
                }
            }
            builder.setCharset(this.httpConfig.getCharset());
            uri = builder.build();
        }
        catch (URISyntaxException e) {
            e.printStackTrace();
            throw new HttpException(e);
        }
        builder = RequestBuilder.get((URI)uri);
        builder.setCharset(this.getCharSet());
        builder.setConfig(this.buildConfig());
        HttpUriRequest request = builder.build();
        this.addHeader((HttpRequest)request);
        return this.exec(request);
    }

    @Override
    public SimpleHttpResponse post(String url) {
        return this.post(url, "");
    }

    @Override
    public SimpleHttpResponse post(String url, String dataJson) {
        return this.post(url, dataJson, null);
    }

    @Override
    public SimpleHttpResponse post(String url, String dataJson, HttpHeader header) {
        if (StringUtils.isEmpty(url)) {
            throw new HttpException("url missing");
        }
        RequestBuilder builder = RequestBuilder.post((String)url);
        if (!StringUtils.isBlank(dataJson)) {
            StringEntity entity = new StringEntity(dataJson, this.getContentType());
            builder.setEntity((HttpEntity)entity);
        }
        builder.setConfig(this.buildConfig());
        builder.setCharset(this.getCharSet());
        HttpUriRequest uriRequest = builder.build();
        this.addHeader((HttpRequest)uriRequest);
        this.addHeader((HttpRequest)uriRequest, header);
        return this.exec(uriRequest);
    }

    @Override
    public SimpleHttpResponse postFormStr(String url, Map<String, String> formdata) {
        return this.postFormStr(url, formdata, null);
    }

    @Override
    public SimpleHttpResponse postFormStr(String url, Map<String, String> formData, HttpHeader header) {
        if (StringUtils.isEmpty(url)) {
            throw new HttpException("url missing");
        }
        RequestBuilder builder = RequestBuilder.post((String)url);
        if (!CollectionUtils.isEmpty(formData)) {
            ArrayList form = new ArrayList(formData.size());
            MapUtils.forEach(formData, (k, v) -> form.add(new BasicNameValuePair(v, k)));
            builder.setEntity((HttpEntity)new UrlEncodedFormEntity(form, this.getCharSet()));
        }
        builder.setCharset(this.getCharSet());
        builder.setConfig(this.buildConfig());
        HttpUriRequest uriRequest = builder.build();
        this.addHeader((HttpRequest)uriRequest);
        this.addHeader((HttpRequest)uriRequest, header);
        return this.exec(uriRequest);
    }

    @Override
    public SimpleHttpResponse postFile(String url, String name, String filename, byte[] fileBytes) {
        File file = FileUtil.writeBytes((byte[])fileBytes, (String)(System.getProperty("java.io.tmpdir") + File.separator + filename));
        return this.postFile(url, name, file);
    }

    @Override
    public SimpleHttpResponse postFile(String url, String name, File file) {
        HashMap<String, Object> body = new HashMap<String, Object>(1);
        body.put(name, file);
        return this.postFormFile(url, body);
    }

    @Override
    public SimpleHttpResponse postFormFile(String url, Map<String, Object> formData) {
        return this.postFormFile(url, formData, null);
    }

    @Override
    public SimpleHttpResponse postFormFile(String url, Map<String, Object> formData, HttpHeader header) {
        if (StringUtils.isEmpty(url)) {
            throw new HttpException("url missing");
        }
        RequestBuilder builder = RequestBuilder.post((String)url);
        if (!CollectionUtils.isEmpty(formData)) {
            MultipartEntityBuilder entityBuilder = MultipartEntityBuilder.create();
            for (Map.Entry<String, Object> entry : formData.entrySet()) {
                String strValue;
                String name = entry.getKey();
                Object value = entry.getValue();
                if (StrUtil.isBlank((CharSequence)name) || ObjectUtil.isNull((Object)value)) continue;
                if (value instanceof File) {
                    entityBuilder.addBinaryBody(name, (File)value);
                    continue;
                }
                if (value instanceof Iterable) {
                    strValue = CollUtil.join((Iterable)((Iterable)value), (CharSequence)",");
                } else if (ArrayUtil.isArray((Object)value)) {
                    if (File.class == ArrayUtil.getComponentType((Object)value)) {
                        File[] files = (File[])value;
                        for (int i = 0; i < files.length; ++i) {
                            entityBuilder.addPart(FormBodyPartBuilder.create().setBody((ContentBody)new FileBody(files[i])).setName(name + i).build());
                        }
                        continue;
                    }
                    strValue = ArrayUtil.join((Object[])((Object[])value), (CharSequence)",");
                } else {
                    strValue = Convert.toStr((Object)value, null);
                }
                entityBuilder.addTextBody(name, strValue);
            }
            builder.setEntity(entityBuilder.build());
        }
        builder.setCharset(this.getCharSet());
        builder.setConfig(this.buildConfig());
        HttpUriRequest uriRequest = builder.build();
        this.addHeader((HttpRequest)uriRequest);
        this.addHeader((HttpRequest)uriRequest, header);
        return this.exec(uriRequest);
    }

    private boolean isSuccess(CloseableHttpResponse response) {
        if (response == null) {
            return false;
        }
        if (response.getStatusLine() == null) {
            return false;
        }
        return response.getStatusLine().getStatusCode() >= 200 && response.getStatusLine().getStatusCode() < 300;
    }

    private void addHeader(HttpRequest request, HttpHeader header) {
        if (null == request || null == header) {
            return;
        }
        Map<String, String> headers = header.getHeaders();
        if (CollectionUtils.isEmpty(headers)) {
            return;
        }
        MapUtils.forEach(headers, (arg_0, arg_1) -> ((HttpRequest)request).addHeader(arg_0, arg_1));
    }

    private void addHeader(HttpRequest request) {
        this.addHeader(request, this.getHeader());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private SimpleHttpResponse exec(HttpUriRequest request) {
        Interceptor interceptor = this.getHttpConfig().getInterceptor();
        if (null != interceptor) {
            interceptor.client(this.httpClient);
            interceptor.request(request);
        }
        try (CloseableHttpResponse response = this.httpClient.execute(request);){
            if (null != interceptor) {
                interceptor.response(response);
            }
            boolean success = this.isSuccess(response);
            HttpEntity entity = response.getEntity();
            Map<String, List<String>> headers = Arrays.stream(response.getAllHeaders()).collect(Collectors.toMap(NameValuePair::getName, value -> {
                ArrayList<String> valueList = new ArrayList<String>();
                valueList.add(value.getValue());
                return valueList;
            }, (v1Value, v2Value) -> v2Value));
            SimpleHttpResponse simpleHttpResponse = SimpleHttpResponse.builder().success(success).body(IoUtil.readBytes((InputStream)entity.getContent(), (boolean)false)).headers(headers).build();
            return simpleHttpResponse;
        }
        catch (IOException e) {
            throw new HttpException("request error:" + e.getMessage());
        }
    }

    private RequestConfig buildConfig() {
        int timeout = this.httpConfig.getTimeout() > Integer.MAX_VALUE ? Integer.MAX_VALUE : Long.valueOf(this.httpConfig.getTimeout()).intValue();
        RequestConfig.Builder builder = RequestConfig.custom().setConnectionRequestTimeout(timeout).setConnectTimeout(timeout).setSocketTimeout(timeout);
        if (null != this.httpConfig.getProxy()) {
            Proxy proxy = this.httpConfig.getProxy();
            InetSocketAddress address = (InetSocketAddress)proxy.address();
            HttpHost host = new HttpHost(address.getHostName(), address.getPort(), proxy.type().name().toLowerCase());
            builder.setProxy(host);
        }
        return builder.build();
    }

    private Charset getCharSet() {
        return this.httpConfig.getCharset() == null ? StandardCharsets.UTF_8 : this.httpConfig.getCharset();
    }

    private ContentType getContentType() {
        String contentType = this.httpConfig.getContentType();
        if (StringUtils.isBlank(contentType)) {
            return ContentType.TEXT_PLAIN;
        }
        return ContentType.parse((String)contentType);
    }
}

