/*
 * Decompiled with CFR 0.152.
 */
package com.hb0730.https.support.hutool;

import cn.hutool.core.io.FileUtil;
import cn.hutool.core.net.url.UrlBuilder;
import cn.hutool.http.HttpException;
import cn.hutool.http.HttpRequest;
import cn.hutool.http.HttpResponse;
import cn.hutool.http.Method;
import com.hb0730.https.HttpHeader;
import com.hb0730.https.config.HttpConfig;
import com.hb0730.https.config.Interceptor;
import com.hb0730.https.support.AbstractSimpleHttp;
import com.hb0730.https.support.SimpleHttpResponse;
import com.hb0730.https.support.hutool.IHutoolHttp;
import com.hb0730.https.utils.StringUtils;
import java.io.File;
import java.util.HashMap;
import java.util.Map;

public class HutoolImpl
extends AbstractSimpleHttp
implements IHutoolHttp {
    public HutoolImpl() {
        this(HttpConfig.builder().build());
    }

    public HutoolImpl(HttpConfig httpConfig) {
        super(httpConfig);
    }

    @Override
    public SimpleHttpResponse get(String url) {
        return this.get(url, null);
    }

    @Override
    public SimpleHttpResponse get(String url, Map<String, String> params) {
        if (StringUtils.isEmpty(url)) {
            throw new HttpException("url missing");
        }
        UrlBuilder builder = this.urlBuilder(url, params, this.httpConfig.getCharset(), this.httpConfig.isEncode());
        HttpRequest request = this.getRequest(builder, Method.GET);
        return this.exec(request);
    }

    @Override
    public SimpleHttpResponse post(String url) {
        return this.post(url, null);
    }

    @Override
    public SimpleHttpResponse post(String url, String dataJson) {
        return this.post(url, dataJson, null);
    }

    @Override
    public SimpleHttpResponse post(String url, String dataJson, HttpHeader header) {
        if (StringUtils.isEmpty(url)) {
            throw new HttpException("url missing");
        }
        UrlBuilder builder = this.urlBuilder(url, null, this.httpConfig.getCharset(), this.httpConfig.isEncode());
        HttpRequest request = this.getRequest(builder, Method.POST);
        if (null != header) {
            request.addHeaders(header.getHeaders());
        }
        request.body(dataJson, this.getContentType("application/json; charset=utf-8"));
        return this.exec(request);
    }

    @Override
    public SimpleHttpResponse postFormStr(String url, Map<String, String> formdata) {
        return this.postFormStr(url, formdata, null);
    }

    @Override
    public SimpleHttpResponse postFormStr(String url, Map<String, String> formData, HttpHeader header) {
        if (StringUtils.isEmpty(url)) {
            throw new HttpException("url missing");
        }
        UrlBuilder builder = this.urlBuilder(url, null, this.httpConfig.getCharset(), this.httpConfig.isEncode());
        HttpRequest request = this.getRequest(builder, Method.POST);
        request.formStr(formData);
        request.contentType(this.getContentType("application/x-www-form-urlencoded; charset=utf-8"));
        if (null != header) {
            request.addHeaders(header.getHeaders());
        }
        return this.exec(request);
    }

    @Override
    public SimpleHttpResponse postFile(String url, String name, String filename, byte[] fileBytes) {
        File file = FileUtil.writeBytes((byte[])fileBytes, (String)(System.getProperty("java.io.tmpdir") + File.separator + filename));
        return this.postFile(url, name, file);
    }

    @Override
    public SimpleHttpResponse postFile(String url, String name, File file) {
        HashMap<String, Object> body = new HashMap<String, Object>(1);
        body.put(name, file);
        return this.postFormFile(url, body);
    }

    @Override
    public SimpleHttpResponse postFormFile(String url, Map<String, Object> formData) {
        return this.postFormFile(url, formData, null);
    }

    @Override
    public SimpleHttpResponse postFormFile(String url, Map<String, Object> formData, HttpHeader header) {
        if (StringUtils.isEmpty(url)) {
            throw new HttpException("url missing");
        }
        UrlBuilder builder = this.urlBuilder(url, null, this.httpConfig.getCharset(), this.httpConfig.isEncode());
        HttpRequest request = this.getRequest(builder, Method.POST);
        request.form(formData);
        if (null != header) {
            request.addHeaders(header.getHeaders());
        }
        request.header("Content-Type", "multipart/form-data");
        return this.exec(request);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private SimpleHttpResponse exec(HttpRequest request) {
        Interceptor interceptor = this.getHttpConfig().getInterceptor();
        if (null != interceptor) {
            interceptor.client(request);
        }
        try (HttpResponse response = request.execute();){
            if (null != interceptor) {
                interceptor.response(response);
            }
            SimpleHttpResponse simpleHttpResponse = SimpleHttpResponse.builder().success(response.isOk()).body(response.bodyBytes()).headers(response.headers()).build();
            return simpleHttpResponse;
        }
        catch (Exception e) {
            throw new com.hb0730.https.exception.HttpException("request error:" + e.getMessage());
        }
    }

    private HttpRequest getRequest(UrlBuilder url, Method method) {
        return this.getHttpRequest(url, method, this.getHttpConfig() == null ? HttpConfig.builder().build() : this.getHttpConfig(), this.getHeader());
    }

    private String getContentType(String defaultContentType) {
        if (StringUtils.isBlank(this.httpConfig.getContentType())) {
            return defaultContentType;
        }
        return this.httpConfig.getContentType();
    }
}

