/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.fullstack.base.api.io;

import com.hedera.fullstack.base.api.threading.ThreadBuilder;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Supplier;

public class BufferedStreamSink
implements AutoCloseable {
    public static final int BUFFER_SIZE = 16384;
    private final InputStream source;
    private final ByteArrayOutputStream sink;
    private InputStream destination;
    private final Thread thread;
    private final AtomicBoolean closed;

    public BufferedStreamSink(InputStream source) {
        this(source, 16384);
    }

    public BufferedStreamSink(InputStream source, int bufferSize) {
        this(source, bufferSize, ThreadBuilder::new);
    }

    public BufferedStreamSink(InputStream source, int bufferSize, Supplier<ThreadBuilder> threadBuilderSupplier) {
        Objects.requireNonNull(source, "source must not be null");
        Objects.requireNonNull(threadBuilderSupplier, "threadBuilderSupplier must not be null");
        if (bufferSize <= 0) {
            throw new IllegalArgumentException("bufferSize must be greater than zero");
        }
        this.source = source;
        this.sink = new ByteArrayOutputStream(bufferSize);
        this.closed = new AtomicBoolean(false);
        this.thread = threadBuilderSupplier.get().executable(this::run).name("stream-sink-io-reader").build();
    }

    public synchronized BufferedStreamSink begin() {
        if (this.thread.isAlive() || this.thread.getState() != Thread.State.NEW) {
            throw new IllegalStateException("thread is already running");
        }
        this.thread.start();
        return this;
    }

    public synchronized InputStream end() throws IOException {
        if (this.isClosed()) {
            return this.destination;
        }
        this.closed.compareAndSet(false, true);
        if (this.thread.isAlive()) {
            try {
                int attempts = 0;
                while (this.thread.isAlive() && attempts < 50) {
                    this.thread.join(100L);
                    if (++attempts > 1) continue;
                    this.thread.interrupt();
                }
                if (this.thread.isAlive()) {
                    throw new IOException("failed to terminate the sink thread and close the sink");
                }
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        }
        this.destination = new ByteArrayInputStream(this.sink.toByteArray());
        this.sink.reset();
        this.sink.close();
        return this.destination;
    }

    @Override
    public synchronized void close() throws IOException {
        this.end();
    }

    public InputStream getSource() {
        return this.source;
    }

    public synchronized InputStream getDataStream() {
        if (!this.isClosed()) {
            throw new IllegalStateException("sink has not been closed");
        }
        return this.destination;
    }

    public boolean isClosed() {
        return this.closed.get();
    }

    private void run() {
        try {
            int read;
            byte[] buffer = new byte[1024];
            while ((read = this.source.read(buffer)) != -1) {
                this.sink.write(buffer, 0, read);
                this.sink.flush();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

