/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.fullstack.base.api.os;

public enum Architecture {
    AMD64("amd64"),
    ARM("arm"),
    ARM64("arm64"),
    I386("i386"),
    PPC64LE("ppc64le"),
    S390X("s390x");

    private final String directoryName;

    private Architecture(String directoryName) {
        this.directoryName = directoryName;
    }

    public String directoryName() {
        return this.directoryName;
    }

    public static Architecture current() {
        String osArch = System.getProperty("os.arch").toLowerCase();
        if (osArch.contains("amd64") || osArch.contains("x86_64")) {
            return AMD64;
        }
        if (osArch.contains("arm64") || osArch.contains("aarch64")) {
            return ARM64;
        }
        if (osArch.contains("arm")) {
            return ARM;
        }
        if (osArch.contains("i386")) {
            return I386;
        }
        if (osArch.contains("ppc64le")) {
            return PPC64LE;
        }
        if (osArch.contains("s390x")) {
            return S390X;
        }
        throw new IllegalStateException("Unsupported architecture: " + osArch);
    }
}

