/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.fullstack.base.api.os;

public enum OperatingSystem {
    WINDOWS("windows"),
    LINUX("linux"),
    DARWIN("darwin");

    private final String directoryName;

    private OperatingSystem(String directoryName) {
        this.directoryName = directoryName;
    }

    public String directoryName() {
        return this.directoryName;
    }

    public static OperatingSystem current() {
        String osName = System.getProperty("os.name").toLowerCase();
        if (osName.contains("win")) {
            return WINDOWS;
        }
        if (osName.contains("nix") || osName.contains("nux") || osName.contains("aix")) {
            return LINUX;
        }
        if (osName.contains("mac")) {
            return DARWIN;
        }
        throw new IllegalStateException("Unsupported operating system: " + osName);
    }
}

