/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.fullstack.base.api.resource;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.CopyOption;
import java.nio.file.FileSystemNotFoundException;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.ProviderNotFoundException;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.PosixFilePermissions;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class ResourceLoader<T> {
    private final Class<T> requester;
    private final List<ClassLoader> resolvers;

    public ResourceLoader(Class<T> requester) {
        Objects.requireNonNull(requester, "requester cannot be null");
        this.requester = requester;
        this.resolvers = new ArrayList<ClassLoader>();
        this.resolvers.add(this.requester.getClassLoader());
        this.resolvers.add(ClassLoader.getSystemClassLoader());
        this.resolvers.add(ClassLoader.getPlatformClassLoader());
    }

    public Path load(String path) throws IOException {
        Objects.requireNonNull(path, "path cannot be null");
        InputStream resourceStream = this.acquireResourceStream(path);
        String fileName = Path.of(path, new String[0]).getFileName().toString();
        Path tempDirectory = this.createTempDirectory();
        Path tempFile = tempDirectory.resolve(fileName);
        Files.copy(resourceStream, tempFile, new CopyOption[0]);
        if (this.isPosixCompliant()) {
            Files.setPosixFilePermissions(tempFile, PosixFilePermissions.fromString("rwxrwxrwx"));
        } else {
            File f = tempFile.toFile();
            f.setExecutable(true, false);
            f.setReadable(true, false);
            f.setWritable(true, false);
        }
        return tempFile;
    }

    private InputStream acquireResourceStream(String path) throws IOException {
        Objects.requireNonNull(path, "path cannot be null");
        for (ClassLoader resolver : this.resolvers) {
            InputStream stream = resolver.getResourceAsStream(path);
            if (stream == null) continue;
            return stream;
        }
        throw new IOException("Unable to acquire resource stream for path: " + path);
    }

    private Path createTempDirectory() throws IOException {
        Path tempDirectory = Files.createTempDirectory(this.requester.getSimpleName(), new FileAttribute[0]);
        tempDirectory.toFile().mkdir();
        tempDirectory.toFile().deleteOnExit();
        return tempDirectory;
    }

    protected boolean isPosixCompliant() {
        try {
            return FileSystems.getDefault().supportedFileAttributeViews().contains("posix");
        }
        catch (SecurityException | FileSystemNotFoundException | ProviderNotFoundException e) {
            return false;
        }
    }
}

