/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.fullstack.base.api.threading;

import java.util.Objects;

public final class ThreadBuilder {
    private Runnable executable;
    private boolean daemon = true;
    private String name;
    private int priority = 5;
    private Thread.UncaughtExceptionHandler exceptionHandler;

    public ThreadBuilder() {
    }

    public ThreadBuilder(Runnable executable) {
        this();
        this.executable(executable);
    }

    public ThreadBuilder executable(Runnable executable) {
        this.executable = Objects.requireNonNull(executable, "executable must not be null");
        return this;
    }

    public ThreadBuilder daemon(boolean daemon) {
        this.daemon = daemon;
        return this;
    }

    public ThreadBuilder name(String name) {
        this.name = Objects.requireNonNull(name, "name must not be null");
        return this;
    }

    public ThreadBuilder priority(int priority) {
        if (priority < 1 || priority > 10) {
            throw new IllegalArgumentException("priority must be between 1 and 10");
        }
        this.priority = priority;
        return this;
    }

    public ThreadBuilder exceptionHandler(Thread.UncaughtExceptionHandler exceptionHandler) {
        this.exceptionHandler = Objects.requireNonNull(exceptionHandler, "exceptionHandler must not be null");
        return this;
    }

    public Thread build() {
        Objects.requireNonNull(this.executable, "executable must not be null");
        Thread thread = new Thread(this.executable);
        thread.setDaemon(this.daemon);
        thread.setPriority(this.priority);
        if (this.name != null) {
            thread.setName(this.name);
        }
        if (this.exceptionHandler != null) {
            thread.setUncaughtExceptionHandler(this.exceptionHandler);
        }
        return thread;
    }
}

