/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.fullstack.base.api.util;

import com.hedera.fullstack.base.api.functional.ThrowingRunnable;
import com.hedera.fullstack.base.api.functional.ThrowingSupplier;

public class ExceptionUtils {
    private ExceptionUtils() {
    }

    public static void suppressExceptions(ThrowingRunnable fn) {
        try {
            fn.run();
        }
        catch (Error err) {
            throw err;
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public static <T> T suppressExceptions(ThrowingSupplier<T> fn) {
        try {
            return fn.get();
        }
        catch (Error err) {
            throw err;
        }
        catch (Throwable throwable) {
            return null;
        }
    }

    public static <T> T suppressExceptions(ThrowingSupplier<T> fn, T defaultValue) {
        try {
            return fn.get();
        }
        catch (Error err) {
            throw err;
        }
        catch (Throwable throwable) {
            return defaultValue;
        }
    }
}

