/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.fullstack.base.api.util;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Objects;

public final class StreamUtils {
    private StreamUtils() {
    }

    public static String streamToString(InputStream inputStream) {
        Objects.requireNonNull(inputStream, "inputStream must not be null");
        InputStreamReader inputStreamReader = new InputStreamReader(inputStream);
        BufferedReader bufferedReader = new BufferedReader(inputStreamReader);
        StringBuilder sb = new StringBuilder();
        try {
            String line;
            while ((line = bufferedReader.readLine()) != null) {
                sb.append(line);
            }
        }
        catch (IOException e) {
            sb.append("... interrupted by: ").append(e.getMessage());
        }
        return sb.toString();
    }
}

