/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.fullstack.base.api.version;

import com.hedera.fullstack.base.api.util.StringUtils;
import com.hedera.fullstack.base.api.version.InvalidSemanticVersionException;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public record SemanticVersion(int major, int minor, int patch, String prerelease, String build) implements Comparable<SemanticVersion>
{
    public static final SemanticVersion ZERO = new SemanticVersion(0, 0, 0, "", "");
    private static final Pattern SEMVER_PATTERN = Pattern.compile("^((\\d+)\\.(\\d+)\\.(\\d+))(?:-([\\dA-Za-z]+(?:\\.[\\dA-Za-z]+)*))?(?:\\+([\\dA-Za-z\\-]+(?:\\.[\\dA-Za-z\\-]+)*))?$");

    public SemanticVersion {
        prerelease = StringUtils.nullToBlank(prerelease);
        build = StringUtils.nullToBlank(build);
    }

    public static SemanticVersion parse(String version) {
        Objects.requireNonNull(version, "version cannot be null");
        Matcher matcher = SEMVER_PATTERN.matcher(version.trim());
        if (!matcher.matches()) {
            throw new InvalidSemanticVersionException(String.format("The supplied version '%s' is not a valid semantic version", version));
        }
        try {
            int major = Integer.parseInt(matcher.group(2));
            int minor = Integer.parseInt(matcher.group(3));
            int patch = Integer.parseInt(matcher.group(4));
            String prerelease = StringUtils.nullToBlank(matcher.group(5));
            String build = StringUtils.nullToBlank(matcher.group(6));
            return new SemanticVersion(major, minor, patch, prerelease, build);
        }
        catch (NumberFormatException e) {
            throw new InvalidSemanticVersionException(String.format("The supplied version '%s' is not a valid semantic version", version), e);
        }
    }

    public SemanticVersion withClearedBuild() {
        return new SemanticVersion(this.major, this.minor, this.patch, this.prerelease, "");
    }

    public SemanticVersion withClearedPrerelease() {
        return new SemanticVersion(this.major, this.minor, this.patch, "", this.build);
    }

    @Override
    public int compareTo(SemanticVersion o) {
        if (o == null) {
            return 1;
        }
        int result = Integer.compare(this.major, o.major);
        if (result != 0) {
            return result;
        }
        result = Integer.compare(this.minor, o.minor);
        if (result != 0) {
            return result;
        }
        result = Integer.compare(this.patch, o.patch);
        if (result != 0) {
            return result;
        }
        result = StringUtils.compare(this.prerelease, o.prerelease);
        if (result != 0) {
            return result;
        }
        return StringUtils.compare(this.build, o.build);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof SemanticVersion)) {
            return false;
        }
        SemanticVersion that = (SemanticVersion)o;
        return this.major == that.major && this.minor == that.minor && this.patch == that.patch && Objects.equals(this.prerelease, that.prerelease) && Objects.equals(this.build, that.build);
    }

    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append(String.format("%d", this.major())).append(".").append(String.format("%d", this.minor())).append(".").append(String.format("%d", this.patch()));
        if (this.prerelease() != null && !this.prerelease().isBlank()) {
            builder.append("-").append(this.prerelease());
        }
        if (this.build() != null && !this.build().isBlank()) {
            builder.append("+").append(this.build());
        }
        return builder.toString();
    }
}

