/*
 * Decompiled with CFR 0.152.
 */
package com.highmobility.autoapi;

import com.highmobility.autoapi.Command;
import com.highmobility.autoapi.CommandParseException;
import com.highmobility.autoapi.CommandResolver;
import com.highmobility.autoapi.GetAvailabilityCommand;
import com.highmobility.autoapi.GetCommand;
import com.highmobility.autoapi.SetCommand;
import com.highmobility.autoapi.property.ByteEnum;
import com.highmobility.autoapi.property.Property;
import com.highmobility.autoapi.value.ActiveState;
import com.highmobility.autoapi.value.LaneKeepAssistState;
import com.highmobility.autoapi.value.OnOffState;
import com.highmobility.autoapi.value.ParkAssist;
import com.highmobility.value.Bytes;
import java.util.ArrayList;
import java.util.List;

public class Adas {
    public static final int IDENTIFIER = 108;
    public static final byte PROPERTY_STATUS = 1;
    public static final byte PROPERTY_ALERTNESS_SYSTEM_STATUS = 2;
    public static final byte PROPERTY_FORWARD_COLLISION_WARNING_SYSTEM = 3;
    public static final byte PROPERTY_BLIND_SPOT_WARNING_STATE = 4;
    public static final byte PROPERTY_BLIND_SPOT_WARNING_SYSTEM_COVERAGE = 5;
    public static final byte PROPERTY_REAR_CROSS_WARNING_SYSTEM = 6;
    public static final byte PROPERTY_AUTOMATED_PARKING_BRAKE = 7;
    public static final byte PROPERTY_LANE_KEEP_ASSIST_SYSTEM = 8;
    public static final byte PROPERTY_LANE_KEEP_ASSISTS_STATES = 9;
    public static final byte PROPERTY_PARK_ASSISTS = 10;
    public static final byte PROPERTY_BLIND_SPOT_WARNING_SYSTEM = 11;
    public static final byte PROPERTY_LAUNCH_CONTROL = 12;

    public static enum BlindSpotWarningSystemCoverage implements ByteEnum
    {
        REGULAR(0),
        TRAILER(1);

        private final byte value;

        public static BlindSpotWarningSystemCoverage fromByte(byte byteValue) throws CommandParseException {
            BlindSpotWarningSystemCoverage[] values = BlindSpotWarningSystemCoverage.values();
            for (int i = 0; i < values.length; ++i) {
                BlindSpotWarningSystemCoverage state = values[i];
                if (state.getByte() != byteValue) continue;
                return state;
            }
            throw new CommandParseException(ByteEnum.enumValueDoesNotExist(BlindSpotWarningSystemCoverage.class.getSimpleName(), byteValue));
        }

        private BlindSpotWarningSystemCoverage(byte value) {
            this.value = value;
        }

        @Override
        public byte getByte() {
            return this.value;
        }
    }

    public static class State
    extends SetCommand {
        Property<OnOffState> status = new Property<OnOffState>(OnOffState.class, 1);
        Property<ActiveState> alertnessSystemStatus = new Property<ActiveState>(ActiveState.class, 2);
        Property<ActiveState> forwardCollisionWarningSystem = new Property<ActiveState>(ActiveState.class, 3);
        Property<ActiveState> blindSpotWarningState = new Property<ActiveState>(ActiveState.class, 4);
        Property<BlindSpotWarningSystemCoverage> blindSpotWarningSystemCoverage = new Property<BlindSpotWarningSystemCoverage>(BlindSpotWarningSystemCoverage.class, 5);
        Property<ActiveState> rearCrossWarningSystem = new Property<ActiveState>(ActiveState.class, 6);
        Property<ActiveState> automatedParkingBrake = new Property<ActiveState>(ActiveState.class, 7);
        Property<OnOffState> laneKeepAssistSystem = new Property<OnOffState>(OnOffState.class, 8);
        List<Property<LaneKeepAssistState>> laneKeepAssistsStates;
        List<Property<ParkAssist>> parkAssists;
        Property<OnOffState> blindSpotWarningSystem = new Property<OnOffState>(OnOffState.class, 11);
        Property<ActiveState> launchControl = new Property<ActiveState>(ActiveState.class, 12);

        public Property<OnOffState> getStatus() {
            return this.status;
        }

        public Property<ActiveState> getAlertnessSystemStatus() {
            return this.alertnessSystemStatus;
        }

        public Property<ActiveState> getForwardCollisionWarningSystem() {
            return this.forwardCollisionWarningSystem;
        }

        public Property<ActiveState> getBlindSpotWarningState() {
            return this.blindSpotWarningState;
        }

        public Property<BlindSpotWarningSystemCoverage> getBlindSpotWarningSystemCoverage() {
            return this.blindSpotWarningSystemCoverage;
        }

        public Property<ActiveState> getRearCrossWarningSystem() {
            return this.rearCrossWarningSystem;
        }

        public Property<ActiveState> getAutomatedParkingBrake() {
            return this.automatedParkingBrake;
        }

        public Property<OnOffState> getLaneKeepAssistSystem() {
            return this.laneKeepAssistSystem;
        }

        public List<Property<LaneKeepAssistState>> getLaneKeepAssistsStates() {
            return this.laneKeepAssistsStates;
        }

        public List<Property<ParkAssist>> getParkAssists() {
            return this.parkAssists;
        }

        public Property<OnOffState> getBlindSpotWarningSystem() {
            return this.blindSpotWarningSystem;
        }

        public Property<ActiveState> getLaunchControl() {
            return this.launchControl;
        }

        State(byte[] bytes) {
            super(bytes);
            ArrayList<Property<LaneKeepAssistState>> laneKeepAssistsStatesBuilder = new ArrayList<Property<LaneKeepAssistState>>();
            ArrayList<Property<ParkAssist>> parkAssistsBuilder = new ArrayList<Property<ParkAssist>>();
            while (this.propertyIterator.hasNext()) {
                this.propertyIterator.parseNextState(p -> {
                    switch (p.getPropertyIdentifier()) {
                        case 1: {
                            return this.status.update(p);
                        }
                        case 2: {
                            return this.alertnessSystemStatus.update(p);
                        }
                        case 3: {
                            return this.forwardCollisionWarningSystem.update(p);
                        }
                        case 4: {
                            return this.blindSpotWarningState.update(p);
                        }
                        case 5: {
                            return this.blindSpotWarningSystemCoverage.update(p);
                        }
                        case 6: {
                            return this.rearCrossWarningSystem.update(p);
                        }
                        case 7: {
                            return this.automatedParkingBrake.update(p);
                        }
                        case 8: {
                            return this.laneKeepAssistSystem.update(p);
                        }
                        case 9: {
                            Property<LaneKeepAssistState> laneKeepAssistsState = new Property<LaneKeepAssistState>(LaneKeepAssistState.class, p);
                            laneKeepAssistsStatesBuilder.add(laneKeepAssistsState);
                            return laneKeepAssistsState;
                        }
                        case 10: {
                            Property<ParkAssist> parkAssist = new Property<ParkAssist>(ParkAssist.class, p);
                            parkAssistsBuilder.add(parkAssist);
                            return parkAssist;
                        }
                        case 11: {
                            return this.blindSpotWarningSystem.update(p);
                        }
                        case 12: {
                            return this.launchControl.update(p);
                        }
                    }
                    return null;
                });
            }
            this.laneKeepAssistsStates = laneKeepAssistsStatesBuilder;
            this.parkAssists = parkAssistsBuilder;
        }

        public static final class Builder
        extends SetCommand.Builder<Builder> {
            public Builder() {
                super(108);
            }

            @Override
            public State build() {
                SetCommand baseSetCommand = super.build();
                Command resolved = CommandResolver.resolve(baseSetCommand.getByteArray());
                return (State)resolved;
            }

            public Builder setStatus(Property<OnOffState> status) {
                Property<OnOffState> property = status.setIdentifier((byte)1);
                this.addProperty(property);
                return this;
            }

            public Builder setAlertnessSystemStatus(Property<ActiveState> alertnessSystemStatus) {
                Property<ActiveState> property = alertnessSystemStatus.setIdentifier((byte)2);
                this.addProperty(property);
                return this;
            }

            public Builder setForwardCollisionWarningSystem(Property<ActiveState> forwardCollisionWarningSystem) {
                Property<ActiveState> property = forwardCollisionWarningSystem.setIdentifier((byte)3);
                this.addProperty(property);
                return this;
            }

            public Builder setBlindSpotWarningState(Property<ActiveState> blindSpotWarningState) {
                Property<ActiveState> property = blindSpotWarningState.setIdentifier((byte)4);
                this.addProperty(property);
                return this;
            }

            public Builder setBlindSpotWarningSystemCoverage(Property<BlindSpotWarningSystemCoverage> blindSpotWarningSystemCoverage) {
                Property<BlindSpotWarningSystemCoverage> property = blindSpotWarningSystemCoverage.setIdentifier((byte)5);
                this.addProperty(property);
                return this;
            }

            public Builder setRearCrossWarningSystem(Property<ActiveState> rearCrossWarningSystem) {
                Property<ActiveState> property = rearCrossWarningSystem.setIdentifier((byte)6);
                this.addProperty(property);
                return this;
            }

            public Builder setAutomatedParkingBrake(Property<ActiveState> automatedParkingBrake) {
                Property<ActiveState> property = automatedParkingBrake.setIdentifier((byte)7);
                this.addProperty(property);
                return this;
            }

            public Builder setLaneKeepAssistSystem(Property<OnOffState> laneKeepAssistSystem) {
                Property<OnOffState> property = laneKeepAssistSystem.setIdentifier((byte)8);
                this.addProperty(property);
                return this;
            }

            public Builder setLaneKeepAssistsStates(Property<LaneKeepAssistState>[] laneKeepAssistsStates) {
                for (int i = 0; i < laneKeepAssistsStates.length; ++i) {
                    this.addLaneKeepAssistsState(laneKeepAssistsStates[i]);
                }
                return this;
            }

            public Builder addLaneKeepAssistsState(Property<LaneKeepAssistState> laneKeepAssistsState) {
                laneKeepAssistsState.setIdentifier((byte)9);
                this.addProperty(laneKeepAssistsState);
                return this;
            }

            public Builder setParkAssists(Property<ParkAssist>[] parkAssists) {
                for (int i = 0; i < parkAssists.length; ++i) {
                    this.addParkAssist(parkAssists[i]);
                }
                return this;
            }

            public Builder addParkAssist(Property<ParkAssist> parkAssist) {
                parkAssist.setIdentifier((byte)10);
                this.addProperty(parkAssist);
                return this;
            }

            public Builder setBlindSpotWarningSystem(Property<OnOffState> blindSpotWarningSystem) {
                Property<OnOffState> property = blindSpotWarningSystem.setIdentifier((byte)11);
                this.addProperty(property);
                return this;
            }

            public Builder setLaunchControl(Property<ActiveState> launchControl) {
                Property<ActiveState> property = launchControl.setIdentifier((byte)12);
                this.addProperty(property);
                return this;
            }
        }
    }

    @Deprecated
    public static class GetProperties
    extends GetCommand<State> {
        public GetProperties(Bytes propertyIdentifiers) {
            super(State.class, (Integer)108, propertyIdentifiers);
        }

        public GetProperties(byte ... propertyIdentifiers) {
            super(State.class, (Integer)108, new Bytes(propertyIdentifiers));
        }

        GetProperties(byte[] bytes, boolean fromRaw) throws CommandParseException {
            super(State.class, bytes);
        }
    }

    public static class GetState
    extends GetCommand<State> {
        public GetState() {
            super(State.class, 108);
        }

        public GetState(Bytes propertyIdentifiers) {
            super(State.class, (Integer)108, propertyIdentifiers);
        }

        public GetState(byte ... propertyIdentifiers) {
            super(State.class, (Integer)108, new Bytes(propertyIdentifiers));
        }

        GetState(byte[] bytes, boolean fromRaw) throws CommandParseException {
            super(State.class, bytes);
        }
    }

    public static class GetStateAvailability
    extends GetAvailabilityCommand {
        public GetStateAvailability() {
            super(108);
        }

        public GetStateAvailability(Bytes propertyIdentifiers) {
            super(108, propertyIdentifiers);
        }

        public GetStateAvailability(byte ... propertyIdentifiers) {
            super(108, new Bytes(propertyIdentifiers));
        }

        GetStateAvailability(byte[] bytes, boolean fromRaw) throws CommandParseException {
            super(bytes);
        }
    }
}

