/*
 * Decompiled with CFR 0.152.
 */
package com.highmobility.autoapi;

import com.highmobility.autoapi.Command;
import com.highmobility.autoapi.CommandParseException;
import com.highmobility.autoapi.CommandResolver;
import com.highmobility.autoapi.GetAvailabilityCommand;
import com.highmobility.autoapi.GetCommand;
import com.highmobility.autoapi.PropertyParseException;
import com.highmobility.autoapi.SetCommand;
import com.highmobility.autoapi.property.ByteEnum;
import com.highmobility.autoapi.property.Property;
import com.highmobility.autoapi.value.ActiveState;
import com.highmobility.autoapi.value.ChargingRestriction;
import com.highmobility.autoapi.value.DepartureTime;
import com.highmobility.autoapi.value.DrivingModePhev;
import com.highmobility.autoapi.value.EnabledState;
import com.highmobility.autoapi.value.LockState;
import com.highmobility.autoapi.value.Position;
import com.highmobility.autoapi.value.ReductionTime;
import com.highmobility.autoapi.value.TemperatureExtreme;
import com.highmobility.autoapi.value.Time;
import com.highmobility.autoapi.value.Timer;
import com.highmobility.autoapi.value.WeekdayTime;
import com.highmobility.autoapi.value.measurement.Duration;
import com.highmobility.autoapi.value.measurement.ElectricCurrent;
import com.highmobility.autoapi.value.measurement.ElectricPotentialDifference;
import com.highmobility.autoapi.value.measurement.Energy;
import com.highmobility.autoapi.value.measurement.Length;
import com.highmobility.autoapi.value.measurement.Power;
import com.highmobility.autoapi.value.measurement.Temperature;
import com.highmobility.value.Bytes;
import java.util.ArrayList;
import java.util.List;

public class Charging {
    public static final int IDENTIFIER = 35;
    public static final byte PROPERTY_ESTIMATED_RANGE = 2;
    public static final byte PROPERTY_BATTERY_LEVEL = 3;
    public static final byte PROPERTY_BATTERY_CURRENT_AC = 4;
    public static final byte PROPERTY_BATTERY_CURRENT_DC = 5;
    public static final byte PROPERTY_CHARGER_VOLTAGE_AC = 6;
    public static final byte PROPERTY_CHARGER_VOLTAGE_DC = 7;
    public static final byte PROPERTY_CHARGE_LIMIT = 8;
    public static final byte PROPERTY_TIME_TO_COMPLETE_CHARGE = 9;
    public static final byte PROPERTY_CHARGING_RATE_KW = 10;
    public static final byte PROPERTY_CHARGE_PORT_STATE = 11;
    public static final byte PROPERTY_CHARGE_MODE = 12;
    public static final byte PROPERTY_MAX_CHARGING_CURRENT = 14;
    public static final byte PROPERTY_PLUG_TYPE = 15;
    public static final byte PROPERTY_CHARGING_WINDOW_CHOSEN = 16;
    public static final byte PROPERTY_DEPARTURE_TIMES = 17;
    public static final byte PROPERTY_REDUCTION_TIMES = 19;
    public static final byte PROPERTY_BATTERY_TEMPERATURE = 20;
    public static final byte PROPERTY_TIMERS = 21;
    public static final byte PROPERTY_PLUGGED_IN = 22;
    public static final byte PROPERTY_STATUS = 23;
    public static final byte PROPERTY_CHARGING_RATE = 24;
    public static final byte PROPERTY_BATTERY_CURRENT = 25;
    public static final byte PROPERTY_CHARGER_VOLTAGE = 26;
    public static final byte PROPERTY_CURRENT_TYPE = 27;
    public static final byte PROPERTY_MAX_RANGE = 28;
    public static final byte PROPERTY_STARTER_BATTERY_STATE = 29;
    public static final byte PROPERTY_SMART_CHARGING_STATUS = 30;
    public static final byte PROPERTY_BATTERY_LEVEL_AT_DEPARTURE = 31;
    public static final byte PROPERTY_PRECONDITIONING_DEPARTURE_STATUS = 32;
    public static final byte PROPERTY_PRECONDITIONING_IMMEDIATE_STATUS = 33;
    public static final byte PROPERTY_PRECONDITIONING_DEPARTURE_ENABLED = 34;
    public static final byte PROPERTY_PRECONDITIONING_ERROR = 35;
    public static final byte PROPERTY_BATTERY_CAPACITY = 36;
    public static final byte PROPERTY_AUXILIARY_POWER = 37;
    public static final byte PROPERTY_CHARGING_COMPLETE_LOCK = 38;
    public static final byte PROPERTY_BATTERY_MAX_AVAILABLE = 39;
    public static final byte PROPERTY_CHARGING_END_REASON = 40;
    public static final byte PROPERTY_CHARGING_PHASES = 41;
    public static final byte PROPERTY_BATTERY_ENERGY = 42;
    public static final byte PROPERTY_BATTERY_ENERGY_CHARGABLE = 43;
    public static final byte PROPERTY_CHARGING_SINGLE_IMMEDIATE = 44;
    public static final byte PROPERTY_CHARGING_TIME_DISPLAY = 45;
    public static final byte PROPERTY_DEPARTURE_TIME_DISPLAY = 46;
    public static final byte PROPERTY_RESTRICTION = 47;
    public static final byte PROPERTY_LIMIT_STATUS = 48;
    public static final byte PROPERTY_CURRENT_LIMIT = 49;
    public static final byte PROPERTY_SMART_CHARGING_OPTION = 50;
    public static final byte PROPERTY_PLUG_LOCK_STATUS = 51;
    public static final byte PROPERTY_FLAP_LOCK_STATUS = 52;
    public static final byte PROPERTY_ACOUSTIC_LIMIT = 53;
    public static final byte PROPERTY_MIN_CHARGING_CURRENT = 54;
    public static final byte PROPERTY_ESTIMATED_RANGE_TARGET = 55;
    public static final byte PROPERTY_FULLY_CHARGED_END_TIMES = 56;
    public static final byte PROPERTY_PRECONDITIONING_SCHEDULED_TIME = 57;
    public static final byte PROPERTY_PRECONDITIONING_REMAINING_TIME = 58;
    public static final byte PROPERTY_BATTERY_VOLTAGE = 59;
    public static final byte PROPERTY_BATTERY_TEMPRETATURE_EXTREMES = 60;
    public static final byte PROPERTY_BATTERY_TEMPERATURE_CONTROL_DEMAND = 61;
    public static final byte PROPERTY_CHARGING_CURRENT = 62;
    public static final byte PROPERTY_BATTERY_STATUS = 63;
    public static final byte PROPERTY_BATTERY_LED = 64;
    public static final byte PROPERTY_BATTERY_COOLING_TEMPERATURE = 65;
    public static final byte PROPERTY_BATTERY_TEMPERATURE_EXTREMES = 66;
    public static final byte PROPERTY_DRIVING_MODE_PHEV = 67;
    public static final byte PROPERTY_BATTERY_CHARGE_TYPE = 68;
    public static final byte PROPERTY_DISTANCE_TO_COMPLETE_CHARGE = 69;

    public static enum BatteryChargeType implements ByteEnum
    {
        NO_CHARGE(0),
        NORMAL(1),
        ACCELERATED(2),
        FAST(3),
        QUICK(4),
        ULTRA_FAST(5),
        NOT_USED(6),
        VEHICLE_TO_HOME(7),
        VEHICLE_TO_GRID(8);

        private final byte value;

        public static BatteryChargeType fromByte(byte byteValue) throws CommandParseException {
            BatteryChargeType[] values = BatteryChargeType.values();
            for (int i = 0; i < values.length; ++i) {
                BatteryChargeType state = values[i];
                if (state.getByte() != byteValue) continue;
                return state;
            }
            throw new CommandParseException(ByteEnum.enumValueDoesNotExist(BatteryChargeType.class.getSimpleName(), byteValue));
        }

        private BatteryChargeType(byte value) {
            this.value = value;
        }

        @Override
        public byte getByte() {
            return this.value;
        }
    }

    public static enum BatteryLed implements ByteEnum
    {
        NO_COLOUR(0),
        WHITE(1),
        YELLOW(2),
        GREEN(3),
        RED(4),
        YELLOW_PULSING(5),
        GREEN_PULSING(6),
        RED_PULSING(7),
        GREEN_RED_PULSING(8),
        GREEN_FLASHING(9),
        INITIALISING(10),
        ERROR(11);

        private final byte value;

        public static BatteryLed fromByte(byte byteValue) throws CommandParseException {
            BatteryLed[] values = BatteryLed.values();
            for (int i = 0; i < values.length; ++i) {
                BatteryLed state = values[i];
                if (state.getByte() != byteValue) continue;
                return state;
            }
            throw new CommandParseException(ByteEnum.enumValueDoesNotExist(BatteryLed.class.getSimpleName(), byteValue));
        }

        private BatteryLed(byte value) {
            this.value = value;
        }

        @Override
        public byte getByte() {
            return this.value;
        }
    }

    public static enum BatteryStatus implements ByteEnum
    {
        INACTIVE(0),
        ACTIVE(1),
        BALANCING(2),
        EXTERNAL_LOAD(3),
        LOAD(4),
        ERROR(5),
        INITIALISING(6),
        CONDITIONING(7);

        private final byte value;

        public static BatteryStatus fromByte(byte byteValue) throws CommandParseException {
            BatteryStatus[] values = BatteryStatus.values();
            for (int i = 0; i < values.length; ++i) {
                BatteryStatus state = values[i];
                if (state.getByte() != byteValue) continue;
                return state;
            }
            throw new CommandParseException(ByteEnum.enumValueDoesNotExist(BatteryStatus.class.getSimpleName(), byteValue));
        }

        private BatteryStatus(byte value) {
            this.value = value;
        }

        @Override
        public byte getByte() {
            return this.value;
        }
    }

    public static enum BatteryTemperatureControlDemand implements ByteEnum
    {
        HIGH_COOLING(0),
        MEDIUM_COOLING(1),
        LOW_COOLING(2),
        NO_TEMPERATURE_REQUIREMENT(3),
        LOW_HEATING(4),
        MEDIUM_HEATING(5),
        HIGH_HEATING(6),
        CIRCULATION_REQUIREMENT(7);

        private final byte value;

        public static BatteryTemperatureControlDemand fromByte(byte byteValue) throws CommandParseException {
            BatteryTemperatureControlDemand[] values = BatteryTemperatureControlDemand.values();
            for (int i = 0; i < values.length; ++i) {
                BatteryTemperatureControlDemand state = values[i];
                if (state.getByte() != byteValue) continue;
                return state;
            }
            throw new CommandParseException(ByteEnum.enumValueDoesNotExist(BatteryTemperatureControlDemand.class.getSimpleName(), byteValue));
        }

        private BatteryTemperatureControlDemand(byte value) {
            this.value = value;
        }

        @Override
        public byte getByte() {
            return this.value;
        }
    }

    public static enum AcousticLimit implements ByteEnum
    {
        NO_ACTION(0),
        AUTOMATIC(1),
        UNLIMITED(2),
        LIMITED(3);

        private final byte value;

        public static AcousticLimit fromByte(byte byteValue) throws CommandParseException {
            AcousticLimit[] values = AcousticLimit.values();
            for (int i = 0; i < values.length; ++i) {
                AcousticLimit state = values[i];
                if (state.getByte() != byteValue) continue;
                return state;
            }
            throw new CommandParseException(ByteEnum.enumValueDoesNotExist(AcousticLimit.class.getSimpleName(), byteValue));
        }

        private AcousticLimit(byte value) {
            this.value = value;
        }

        @Override
        public byte getByte() {
            return this.value;
        }
    }

    public static enum SmartChargingOption implements ByteEnum
    {
        PRICE_OPTIMIZED(0),
        RENEWABLE_ENERGY(1),
        CO2_OPTIMIZED(2);

        private final byte value;

        public static SmartChargingOption fromByte(byte byteValue) throws CommandParseException {
            SmartChargingOption[] values = SmartChargingOption.values();
            for (int i = 0; i < values.length; ++i) {
                SmartChargingOption state = values[i];
                if (state.getByte() != byteValue) continue;
                return state;
            }
            throw new CommandParseException(ByteEnum.enumValueDoesNotExist(SmartChargingOption.class.getSimpleName(), byteValue));
        }

        private SmartChargingOption(byte value) {
            this.value = value;
        }

        @Override
        public byte getByte() {
            return this.value;
        }
    }

    public static enum DepartureTimeDisplay implements ByteEnum
    {
        NO_DISPLAY(0),
        REACHABLE(1),
        NOT_REACHABLE(2);

        private final byte value;

        public static DepartureTimeDisplay fromByte(byte byteValue) throws CommandParseException {
            DepartureTimeDisplay[] values = DepartureTimeDisplay.values();
            for (int i = 0; i < values.length; ++i) {
                DepartureTimeDisplay state = values[i];
                if (state.getByte() != byteValue) continue;
                return state;
            }
            throw new CommandParseException(ByteEnum.enumValueDoesNotExist(DepartureTimeDisplay.class.getSimpleName(), byteValue));
        }

        private DepartureTimeDisplay(byte value) {
            this.value = value;
        }

        @Override
        public byte getByte() {
            return this.value;
        }
    }

    public static enum ChargingTimeDisplay implements ByteEnum
    {
        NO_DISPLAY(0),
        DISPLAY_DURATION(1),
        NO_DISPLAY_DURATION(2);

        private final byte value;

        public static ChargingTimeDisplay fromByte(byte byteValue) throws CommandParseException {
            ChargingTimeDisplay[] values = ChargingTimeDisplay.values();
            for (int i = 0; i < values.length; ++i) {
                ChargingTimeDisplay state = values[i];
                if (state.getByte() != byteValue) continue;
                return state;
            }
            throw new CommandParseException(ByteEnum.enumValueDoesNotExist(ChargingTimeDisplay.class.getSimpleName(), byteValue));
        }

        private ChargingTimeDisplay(byte value) {
            this.value = value;
        }

        @Override
        public byte getByte() {
            return this.value;
        }
    }

    public static enum ChargingPhases implements ByteEnum
    {
        NO_CHARGING(0),
        ONE(1),
        TWO(2),
        THREE(3);

        private final byte value;

        public static ChargingPhases fromByte(byte byteValue) throws CommandParseException {
            ChargingPhases[] values = ChargingPhases.values();
            for (int i = 0; i < values.length; ++i) {
                ChargingPhases state = values[i];
                if (state.getByte() != byteValue) continue;
                return state;
            }
            throw new CommandParseException(ByteEnum.enumValueDoesNotExist(ChargingPhases.class.getSimpleName(), byteValue));
        }

        private ChargingPhases(byte value) {
            this.value = value;
        }

        @Override
        public byte getByte() {
            return this.value;
        }
    }

    public static enum ChargingEndReason implements ByteEnum
    {
        UNKNOWN(0),
        GOAL_REACHED(1),
        REQUESTED_BY_DRIVER(2),
        CONNECTOR_REMOVED(3),
        POWERGRID_FAILED(4),
        HV_SYSTEM_FAILURE(5),
        CHARGING_STATION_FAILURE(6),
        PARKING_LOCK_FAILED(7),
        NO_PARKING_LOCK(8),
        SIGNAL_INVALID(9);

        private final byte value;

        public static ChargingEndReason fromByte(byte byteValue) throws CommandParseException {
            ChargingEndReason[] values = ChargingEndReason.values();
            for (int i = 0; i < values.length; ++i) {
                ChargingEndReason state = values[i];
                if (state.getByte() != byteValue) continue;
                return state;
            }
            throw new CommandParseException(ByteEnum.enumValueDoesNotExist(ChargingEndReason.class.getSimpleName(), byteValue));
        }

        private ChargingEndReason(byte value) {
            this.value = value;
        }

        @Override
        public byte getByte() {
            return this.value;
        }
    }

    public static enum PreconditioningError implements ByteEnum
    {
        NO_CHANGE(0),
        NOT_POSSIBLE_LOW(1),
        NOT_POSSIBLE_FINISHED(2),
        AVAILABLE_AFTER_ENGINE_RESTART(3),
        GENERAL_ERROR(4);

        private final byte value;

        public static PreconditioningError fromByte(byte byteValue) throws CommandParseException {
            PreconditioningError[] values = PreconditioningError.values();
            for (int i = 0; i < values.length; ++i) {
                PreconditioningError state = values[i];
                if (state.getByte() != byteValue) continue;
                return state;
            }
            throw new CommandParseException(ByteEnum.enumValueDoesNotExist(PreconditioningError.class.getSimpleName(), byteValue));
        }

        private PreconditioningError(byte value) {
            this.value = value;
        }

        @Override
        public byte getByte() {
            return this.value;
        }
    }

    public static enum SmartChargingStatus implements ByteEnum
    {
        WALLBOX_IS_ACTIVE(0),
        SCC_IS_ACTIVE(1),
        PEAK_SETTING_ACTIVE(2);

        private final byte value;

        public static SmartChargingStatus fromByte(byte byteValue) throws CommandParseException {
            SmartChargingStatus[] values = SmartChargingStatus.values();
            for (int i = 0; i < values.length; ++i) {
                SmartChargingStatus state = values[i];
                if (state.getByte() != byteValue) continue;
                return state;
            }
            throw new CommandParseException(ByteEnum.enumValueDoesNotExist(SmartChargingStatus.class.getSimpleName(), byteValue));
        }

        private SmartChargingStatus(byte value) {
            this.value = value;
        }

        @Override
        public byte getByte() {
            return this.value;
        }
    }

    public static enum StarterBatteryState implements ByteEnum
    {
        RED(0),
        YELLOW(1),
        GREEN(2),
        ORANGE(3),
        GREEN_YELLOW(4);

        private final byte value;

        public static StarterBatteryState fromByte(byte byteValue) throws CommandParseException {
            StarterBatteryState[] values = StarterBatteryState.values();
            for (int i = 0; i < values.length; ++i) {
                StarterBatteryState state = values[i];
                if (state.getByte() != byteValue) continue;
                return state;
            }
            throw new CommandParseException(ByteEnum.enumValueDoesNotExist(StarterBatteryState.class.getSimpleName(), byteValue));
        }

        private StarterBatteryState(byte value) {
            this.value = value;
        }

        @Override
        public byte getByte() {
            return this.value;
        }
    }

    public static enum CurrentType implements ByteEnum
    {
        ALTERNATING_CURRENT(0),
        DIRECT_CURRENT(1);

        private final byte value;

        public static CurrentType fromByte(byte byteValue) throws CommandParseException {
            CurrentType[] values = CurrentType.values();
            for (int i = 0; i < values.length; ++i) {
                CurrentType state = values[i];
                if (state.getByte() != byteValue) continue;
                return state;
            }
            throw new CommandParseException(ByteEnum.enumValueDoesNotExist(CurrentType.class.getSimpleName(), byteValue));
        }

        private CurrentType(byte value) {
            this.value = value;
        }

        @Override
        public byte getByte() {
            return this.value;
        }
    }

    public static enum Status implements ByteEnum
    {
        NOT_CHARGING(0),
        CHARGING(1),
        CHARGING_COMPLETE(2),
        INITIALISING(3),
        CHARGING_PAUSED(4),
        CHARGING_ERROR(5),
        CABLE_UNPLUGGED(6),
        SLOW_CHARGING(7),
        FAST_CHARGING(8),
        DISCHARGING(9),
        FOREIGN_OBJECT_DETECTED(10),
        CONDITIONING(11),
        FLAP_OPEN(12);

        private final byte value;

        public static Status fromByte(byte byteValue) throws CommandParseException {
            Status[] values = Status.values();
            for (int i = 0; i < values.length; ++i) {
                Status state = values[i];
                if (state.getByte() != byteValue) continue;
                return state;
            }
            throw new CommandParseException(ByteEnum.enumValueDoesNotExist(Status.class.getSimpleName(), byteValue));
        }

        private Status(byte value) {
            this.value = value;
        }

        @Override
        public byte getByte() {
            return this.value;
        }
    }

    public static enum PluggedIn implements ByteEnum
    {
        DISCONNECTED(0),
        PLUGGED_IN(1),
        PLUGGED_IN_BOTH_SIDES(2);

        private final byte value;

        public static PluggedIn fromByte(byte byteValue) throws CommandParseException {
            PluggedIn[] values = PluggedIn.values();
            for (int i = 0; i < values.length; ++i) {
                PluggedIn state = values[i];
                if (state.getByte() != byteValue) continue;
                return state;
            }
            throw new CommandParseException(ByteEnum.enumValueDoesNotExist(PluggedIn.class.getSimpleName(), byteValue));
        }

        private PluggedIn(byte value) {
            this.value = value;
        }

        @Override
        public byte getByte() {
            return this.value;
        }
    }

    public static enum ChargingWindowChosen implements ByteEnum
    {
        NOT_CHOSEN(0),
        CHOSEN(1);

        private final byte value;

        public static ChargingWindowChosen fromByte(byte byteValue) throws CommandParseException {
            ChargingWindowChosen[] values = ChargingWindowChosen.values();
            for (int i = 0; i < values.length; ++i) {
                ChargingWindowChosen state = values[i];
                if (state.getByte() != byteValue) continue;
                return state;
            }
            throw new CommandParseException(ByteEnum.enumValueDoesNotExist(ChargingWindowChosen.class.getSimpleName(), byteValue));
        }

        private ChargingWindowChosen(byte value) {
            this.value = value;
        }

        @Override
        public byte getByte() {
            return this.value;
        }
    }

    public static enum PlugType implements ByteEnum
    {
        TYPE_1(0),
        TYPE_2(1),
        CCS(2),
        CHADEMO(3);

        private final byte value;

        public static PlugType fromByte(byte byteValue) throws CommandParseException {
            PlugType[] values = PlugType.values();
            for (int i = 0; i < values.length; ++i) {
                PlugType state = values[i];
                if (state.getByte() != byteValue) continue;
                return state;
            }
            throw new CommandParseException(ByteEnum.enumValueDoesNotExist(PlugType.class.getSimpleName(), byteValue));
        }

        private PlugType(byte value) {
            this.value = value;
        }

        @Override
        public byte getByte() {
            return this.value;
        }
    }

    public static enum ChargeMode implements ByteEnum
    {
        IMMEDIATE(0),
        TIMER_BASED(1),
        INDUCTIVE(2),
        CONDUCTIVE(3),
        PUSH_BUTTON(4);

        private final byte value;

        public static ChargeMode fromByte(byte byteValue) throws CommandParseException {
            ChargeMode[] values = ChargeMode.values();
            for (int i = 0; i < values.length; ++i) {
                ChargeMode state = values[i];
                if (state.getByte() != byteValue) continue;
                return state;
            }
            throw new CommandParseException(ByteEnum.enumValueDoesNotExist(ChargeMode.class.getSimpleName(), byteValue));
        }

        private ChargeMode(byte value) {
            this.value = value;
        }

        @Override
        public byte getByte() {
            return this.value;
        }
    }

    public static class State
    extends SetCommand {
        Property<Length> estimatedRange = new Property<Length>(Length.class, 2);
        Property<Double> batteryLevel = new Property<Double>(Double.class, 3);
        Property<ElectricCurrent> batteryCurrentAC = new Property<ElectricCurrent>(ElectricCurrent.class, 4);
        Property<ElectricCurrent> batteryCurrentDC = new Property<ElectricCurrent>(ElectricCurrent.class, 5);
        Property<ElectricPotentialDifference> chargerVoltageAC = new Property<ElectricPotentialDifference>(ElectricPotentialDifference.class, 6);
        Property<ElectricPotentialDifference> chargerVoltageDC = new Property<ElectricPotentialDifference>(ElectricPotentialDifference.class, 7);
        Property<Double> chargeLimit = new Property<Double>(Double.class, 8);
        Property<Duration> timeToCompleteCharge = new Property<Duration>(Duration.class, 9);
        Property<Power> chargingRateKW = new Property<Power>(Power.class, 10);
        Property<Position> chargePortState = new Property<Position>(Position.class, 11);
        Property<ChargeMode> chargeMode = new Property<ChargeMode>(ChargeMode.class, 12);
        Property<ElectricCurrent> maxChargingCurrent = new Property<ElectricCurrent>(ElectricCurrent.class, 14);
        Property<PlugType> plugType = new Property<PlugType>(PlugType.class, 15);
        Property<ChargingWindowChosen> chargingWindowChosen = new Property<ChargingWindowChosen>(ChargingWindowChosen.class, 16);
        List<Property<DepartureTime>> departureTimes;
        List<Property<ReductionTime>> reductionTimes;
        Property<Temperature> batteryTemperature = new Property<Temperature>(Temperature.class, 20);
        List<Property<Timer>> timers;
        Property<PluggedIn> pluggedIn = new Property<PluggedIn>(PluggedIn.class, 22);
        Property<Status> status = new Property<Status>(Status.class, 23);
        Property<Power> chargingRate = new Property<Power>(Power.class, 24);
        Property<ElectricCurrent> batteryCurrent = new Property<ElectricCurrent>(ElectricCurrent.class, 25);
        Property<ElectricPotentialDifference> chargerVoltage = new Property<ElectricPotentialDifference>(ElectricPotentialDifference.class, 26);
        Property<CurrentType> currentType = new Property<CurrentType>(CurrentType.class, 27);
        Property<Length> maxRange = new Property<Length>(Length.class, 28);
        Property<StarterBatteryState> starterBatteryState = new Property<StarterBatteryState>(StarterBatteryState.class, 29);
        Property<SmartChargingStatus> smartChargingStatus = new Property<SmartChargingStatus>(SmartChargingStatus.class, 30);
        Property<Double> batteryLevelAtDeparture = new Property<Double>(Double.class, 31);
        Property<ActiveState> preconditioningDepartureStatus = new Property<ActiveState>(ActiveState.class, 32);
        Property<ActiveState> preconditioningImmediateStatus = new Property<ActiveState>(ActiveState.class, 33);
        Property<EnabledState> preconditioningDepartureEnabled = new Property<EnabledState>(EnabledState.class, 34);
        Property<PreconditioningError> preconditioningError = new Property<PreconditioningError>(PreconditioningError.class, 35);
        Property<Energy> batteryCapacity = new Property<Energy>(Energy.class, 36);
        Property<Power> auxiliaryPower = new Property<Power>(Power.class, 37);
        Property<ActiveState> chargingCompleteLock = new Property<ActiveState>(ActiveState.class, 38);
        Property<Energy> batteryMaxAvailable = new Property<Energy>(Energy.class, 39);
        Property<ChargingEndReason> chargingEndReason = new Property<ChargingEndReason>(ChargingEndReason.class, 40);
        Property<ChargingPhases> chargingPhases = new Property<ChargingPhases>(ChargingPhases.class, 41);
        Property<Energy> batteryEnergy = new Property<Energy>(Energy.class, 42);
        Property<Energy> batteryEnergyChargable = new Property<Energy>(Energy.class, 43);
        Property<ActiveState> chargingSingleImmediate = new Property<ActiveState>(ActiveState.class, 44);
        Property<ChargingTimeDisplay> chargingTimeDisplay = new Property<ChargingTimeDisplay>(ChargingTimeDisplay.class, 45);
        Property<DepartureTimeDisplay> departureTimeDisplay = new Property<DepartureTimeDisplay>(DepartureTimeDisplay.class, 46);
        Property<ChargingRestriction> restriction = new Property<ChargingRestriction>(ChargingRestriction.class, 47);
        Property<ActiveState> limitStatus = new Property<ActiveState>(ActiveState.class, 48);
        Property<ElectricCurrent> currentLimit = new Property<ElectricCurrent>(ElectricCurrent.class, 49);
        Property<SmartChargingOption> smartChargingOption = new Property<SmartChargingOption>(SmartChargingOption.class, 50);
        Property<LockState> plugLockStatus = new Property<LockState>(LockState.class, 51);
        Property<LockState> flapLockStatus = new Property<LockState>(LockState.class, 52);
        Property<AcousticLimit> acousticLimit = new Property<AcousticLimit>(AcousticLimit.class, 53);
        Property<ElectricCurrent> minChargingCurrent = new Property<ElectricCurrent>(ElectricCurrent.class, 54);
        Property<Length> estimatedRangeTarget = new Property<Length>(Length.class, 55);
        Property<WeekdayTime> fullyChargedEndTimes = new Property<WeekdayTime>(WeekdayTime.class, 56);
        Property<Time> preconditioningScheduledTime = new Property<Time>(Time.class, 57);
        Property<Duration> preconditioningRemainingTime = new Property<Duration>(Duration.class, 58);
        Property<ElectricPotentialDifference> batteryVoltage = new Property<ElectricPotentialDifference>(ElectricPotentialDifference.class, 59);
        Property<TemperatureExtreme> batteryTempretatureExtremes = new Property<TemperatureExtreme>(TemperatureExtreme.class, 60);
        Property<BatteryTemperatureControlDemand> batteryTemperatureControlDemand = new Property<BatteryTemperatureControlDemand>(BatteryTemperatureControlDemand.class, 61);
        Property<ElectricCurrent> chargingCurrent = new Property<ElectricCurrent>(ElectricCurrent.class, 62);
        Property<BatteryStatus> batteryStatus = new Property<BatteryStatus>(BatteryStatus.class, 63);
        Property<BatteryLed> batteryLed = new Property<BatteryLed>(BatteryLed.class, 64);
        Property<Temperature> batteryCoolingTemperature = new Property<Temperature>(Temperature.class, 65);
        Property<TemperatureExtreme> batteryTemperatureExtremes = new Property<TemperatureExtreme>(TemperatureExtreme.class, 66);
        Property<DrivingModePhev> drivingModePHEV = new Property<DrivingModePhev>(DrivingModePhev.class, 67);
        Property<BatteryChargeType> batteryChargeType = new Property<BatteryChargeType>(BatteryChargeType.class, 68);
        Property<Length> distanceToCompleteCharge = new Property<Length>(Length.class, 69);

        public Property<Length> getEstimatedRange() {
            return this.estimatedRange;
        }

        public Property<Double> getBatteryLevel() {
            return this.batteryLevel;
        }

        @Deprecated
        public Property<ElectricCurrent> getBatteryCurrentAC() {
            return this.batteryCurrentAC;
        }

        @Deprecated
        public Property<ElectricCurrent> getBatteryCurrentDC() {
            return this.batteryCurrentDC;
        }

        @Deprecated
        public Property<ElectricPotentialDifference> getChargerVoltageAC() {
            return this.chargerVoltageAC;
        }

        @Deprecated
        public Property<ElectricPotentialDifference> getChargerVoltageDC() {
            return this.chargerVoltageDC;
        }

        public Property<Double> getChargeLimit() {
            return this.chargeLimit;
        }

        public Property<Duration> getTimeToCompleteCharge() {
            return this.timeToCompleteCharge;
        }

        @Deprecated
        public Property<Power> getChargingRateKW() {
            return this.chargingRateKW;
        }

        public Property<Position> getChargePortState() {
            return this.chargePortState;
        }

        public Property<ChargeMode> getChargeMode() {
            return this.chargeMode;
        }

        public Property<ElectricCurrent> getMaxChargingCurrent() {
            return this.maxChargingCurrent;
        }

        public Property<PlugType> getPlugType() {
            return this.plugType;
        }

        public Property<ChargingWindowChosen> getChargingWindowChosen() {
            return this.chargingWindowChosen;
        }

        public List<Property<DepartureTime>> getDepartureTimes() {
            return this.departureTimes;
        }

        public List<Property<ReductionTime>> getReductionTimes() {
            return this.reductionTimes;
        }

        public Property<Temperature> getBatteryTemperature() {
            return this.batteryTemperature;
        }

        public List<Property<Timer>> getTimers() {
            return this.timers;
        }

        public Property<PluggedIn> getPluggedIn() {
            return this.pluggedIn;
        }

        public Property<Status> getStatus() {
            return this.status;
        }

        public Property<Power> getChargingRate() {
            return this.chargingRate;
        }

        public Property<ElectricCurrent> getBatteryCurrent() {
            return this.batteryCurrent;
        }

        public Property<ElectricPotentialDifference> getChargerVoltage() {
            return this.chargerVoltage;
        }

        public Property<CurrentType> getCurrentType() {
            return this.currentType;
        }

        public Property<Length> getMaxRange() {
            return this.maxRange;
        }

        public Property<StarterBatteryState> getStarterBatteryState() {
            return this.starterBatteryState;
        }

        public Property<SmartChargingStatus> getSmartChargingStatus() {
            return this.smartChargingStatus;
        }

        public Property<Double> getBatteryLevelAtDeparture() {
            return this.batteryLevelAtDeparture;
        }

        public Property<ActiveState> getPreconditioningDepartureStatus() {
            return this.preconditioningDepartureStatus;
        }

        public Property<ActiveState> getPreconditioningImmediateStatus() {
            return this.preconditioningImmediateStatus;
        }

        public Property<EnabledState> getPreconditioningDepartureEnabled() {
            return this.preconditioningDepartureEnabled;
        }

        public Property<PreconditioningError> getPreconditioningError() {
            return this.preconditioningError;
        }

        public Property<Energy> getBatteryCapacity() {
            return this.batteryCapacity;
        }

        public Property<Power> getAuxiliaryPower() {
            return this.auxiliaryPower;
        }

        public Property<ActiveState> getChargingCompleteLock() {
            return this.chargingCompleteLock;
        }

        public Property<Energy> getBatteryMaxAvailable() {
            return this.batteryMaxAvailable;
        }

        public Property<ChargingEndReason> getChargingEndReason() {
            return this.chargingEndReason;
        }

        public Property<ChargingPhases> getChargingPhases() {
            return this.chargingPhases;
        }

        public Property<Energy> getBatteryEnergy() {
            return this.batteryEnergy;
        }

        public Property<Energy> getBatteryEnergyChargable() {
            return this.batteryEnergyChargable;
        }

        public Property<ActiveState> getChargingSingleImmediate() {
            return this.chargingSingleImmediate;
        }

        public Property<ChargingTimeDisplay> getChargingTimeDisplay() {
            return this.chargingTimeDisplay;
        }

        public Property<DepartureTimeDisplay> getDepartureTimeDisplay() {
            return this.departureTimeDisplay;
        }

        public Property<ChargingRestriction> getRestriction() {
            return this.restriction;
        }

        public Property<ActiveState> getLimitStatus() {
            return this.limitStatus;
        }

        public Property<ElectricCurrent> getCurrentLimit() {
            return this.currentLimit;
        }

        public Property<SmartChargingOption> getSmartChargingOption() {
            return this.smartChargingOption;
        }

        public Property<LockState> getPlugLockStatus() {
            return this.plugLockStatus;
        }

        public Property<LockState> getFlapLockStatus() {
            return this.flapLockStatus;
        }

        public Property<AcousticLimit> getAcousticLimit() {
            return this.acousticLimit;
        }

        public Property<ElectricCurrent> getMinChargingCurrent() {
            return this.minChargingCurrent;
        }

        public Property<Length> getEstimatedRangeTarget() {
            return this.estimatedRangeTarget;
        }

        public Property<WeekdayTime> getFullyChargedEndTimes() {
            return this.fullyChargedEndTimes;
        }

        public Property<Time> getPreconditioningScheduledTime() {
            return this.preconditioningScheduledTime;
        }

        public Property<Duration> getPreconditioningRemainingTime() {
            return this.preconditioningRemainingTime;
        }

        public Property<ElectricPotentialDifference> getBatteryVoltage() {
            return this.batteryVoltage;
        }

        @Deprecated
        public Property<TemperatureExtreme> getBatteryTempretatureExtremes() {
            return this.batteryTempretatureExtremes;
        }

        public Property<BatteryTemperatureControlDemand> getBatteryTemperatureControlDemand() {
            return this.batteryTemperatureControlDemand;
        }

        public Property<ElectricCurrent> getChargingCurrent() {
            return this.chargingCurrent;
        }

        public Property<BatteryStatus> getBatteryStatus() {
            return this.batteryStatus;
        }

        public Property<BatteryLed> getBatteryLed() {
            return this.batteryLed;
        }

        public Property<Temperature> getBatteryCoolingTemperature() {
            return this.batteryCoolingTemperature;
        }

        public Property<TemperatureExtreme> getBatteryTemperatureExtremes() {
            return this.batteryTemperatureExtremes;
        }

        public Property<DrivingModePhev> getDrivingModePHEV() {
            return this.drivingModePHEV;
        }

        public Property<BatteryChargeType> getBatteryChargeType() {
            return this.batteryChargeType;
        }

        public Property<Length> getDistanceToCompleteCharge() {
            return this.distanceToCompleteCharge;
        }

        State(byte[] bytes) {
            super(bytes);
            ArrayList<Property<DepartureTime>> departureTimesBuilder = new ArrayList<Property<DepartureTime>>();
            ArrayList<Property<ReductionTime>> reductionTimesBuilder = new ArrayList<Property<ReductionTime>>();
            ArrayList<Property<Timer>> timersBuilder = new ArrayList<Property<Timer>>();
            while (this.propertyIterator.hasNext()) {
                this.propertyIterator.parseNextState(p -> {
                    switch (p.getPropertyIdentifier()) {
                        case 2: {
                            return this.estimatedRange.update(p);
                        }
                        case 3: {
                            return this.batteryLevel.update(p);
                        }
                        case 4: {
                            return this.batteryCurrentAC.update(p);
                        }
                        case 5: {
                            return this.batteryCurrentDC.update(p);
                        }
                        case 6: {
                            return this.chargerVoltageAC.update(p);
                        }
                        case 7: {
                            return this.chargerVoltageDC.update(p);
                        }
                        case 8: {
                            return this.chargeLimit.update(p);
                        }
                        case 9: {
                            return this.timeToCompleteCharge.update(p);
                        }
                        case 10: {
                            return this.chargingRateKW.update(p);
                        }
                        case 11: {
                            return this.chargePortState.update(p);
                        }
                        case 12: {
                            return this.chargeMode.update(p);
                        }
                        case 14: {
                            return this.maxChargingCurrent.update(p);
                        }
                        case 15: {
                            return this.plugType.update(p);
                        }
                        case 16: {
                            return this.chargingWindowChosen.update(p);
                        }
                        case 17: {
                            Property<DepartureTime> departureTime = new Property<DepartureTime>(DepartureTime.class, p);
                            departureTimesBuilder.add(departureTime);
                            return departureTime;
                        }
                        case 19: {
                            Property<ReductionTime> reductionTime = new Property<ReductionTime>(ReductionTime.class, p);
                            reductionTimesBuilder.add(reductionTime);
                            return reductionTime;
                        }
                        case 20: {
                            return this.batteryTemperature.update(p);
                        }
                        case 21: {
                            Property<Timer> timer = new Property<Timer>(Timer.class, p);
                            timersBuilder.add(timer);
                            return timer;
                        }
                        case 22: {
                            return this.pluggedIn.update(p);
                        }
                        case 23: {
                            return this.status.update(p);
                        }
                        case 24: {
                            return this.chargingRate.update(p);
                        }
                        case 25: {
                            return this.batteryCurrent.update(p);
                        }
                        case 26: {
                            return this.chargerVoltage.update(p);
                        }
                        case 27: {
                            return this.currentType.update(p);
                        }
                        case 28: {
                            return this.maxRange.update(p);
                        }
                        case 29: {
                            return this.starterBatteryState.update(p);
                        }
                        case 30: {
                            return this.smartChargingStatus.update(p);
                        }
                        case 31: {
                            return this.batteryLevelAtDeparture.update(p);
                        }
                        case 32: {
                            return this.preconditioningDepartureStatus.update(p);
                        }
                        case 33: {
                            return this.preconditioningImmediateStatus.update(p);
                        }
                        case 34: {
                            return this.preconditioningDepartureEnabled.update(p);
                        }
                        case 35: {
                            return this.preconditioningError.update(p);
                        }
                        case 36: {
                            return this.batteryCapacity.update(p);
                        }
                        case 37: {
                            return this.auxiliaryPower.update(p);
                        }
                        case 38: {
                            return this.chargingCompleteLock.update(p);
                        }
                        case 39: {
                            return this.batteryMaxAvailable.update(p);
                        }
                        case 40: {
                            return this.chargingEndReason.update(p);
                        }
                        case 41: {
                            return this.chargingPhases.update(p);
                        }
                        case 42: {
                            return this.batteryEnergy.update(p);
                        }
                        case 43: {
                            return this.batteryEnergyChargable.update(p);
                        }
                        case 44: {
                            return this.chargingSingleImmediate.update(p);
                        }
                        case 45: {
                            return this.chargingTimeDisplay.update(p);
                        }
                        case 46: {
                            return this.departureTimeDisplay.update(p);
                        }
                        case 47: {
                            return this.restriction.update(p);
                        }
                        case 48: {
                            return this.limitStatus.update(p);
                        }
                        case 49: {
                            return this.currentLimit.update(p);
                        }
                        case 50: {
                            return this.smartChargingOption.update(p);
                        }
                        case 51: {
                            return this.plugLockStatus.update(p);
                        }
                        case 52: {
                            return this.flapLockStatus.update(p);
                        }
                        case 53: {
                            return this.acousticLimit.update(p);
                        }
                        case 54: {
                            return this.minChargingCurrent.update(p);
                        }
                        case 55: {
                            return this.estimatedRangeTarget.update(p);
                        }
                        case 56: {
                            return this.fullyChargedEndTimes.update(p);
                        }
                        case 57: {
                            return this.preconditioningScheduledTime.update(p);
                        }
                        case 58: {
                            return this.preconditioningRemainingTime.update(p);
                        }
                        case 59: {
                            return this.batteryVoltage.update(p);
                        }
                        case 60: {
                            return this.batteryTempretatureExtremes.update(p);
                        }
                        case 61: {
                            return this.batteryTemperatureControlDemand.update(p);
                        }
                        case 62: {
                            return this.chargingCurrent.update(p);
                        }
                        case 63: {
                            return this.batteryStatus.update(p);
                        }
                        case 64: {
                            return this.batteryLed.update(p);
                        }
                        case 65: {
                            return this.batteryCoolingTemperature.update(p);
                        }
                        case 66: {
                            return this.batteryTemperatureExtremes.update(p);
                        }
                        case 67: {
                            return this.drivingModePHEV.update(p);
                        }
                        case 68: {
                            return this.batteryChargeType.update(p);
                        }
                        case 69: {
                            return this.distanceToCompleteCharge.update(p);
                        }
                    }
                    return null;
                });
            }
            this.departureTimes = departureTimesBuilder;
            this.reductionTimes = reductionTimesBuilder;
            this.timers = timersBuilder;
        }

        public static final class Builder
        extends SetCommand.Builder<Builder> {
            public Builder() {
                super(35);
            }

            @Override
            public State build() {
                SetCommand baseSetCommand = super.build();
                Command resolved = CommandResolver.resolve(baseSetCommand.getByteArray());
                return (State)resolved;
            }

            public Builder setEstimatedRange(Property<Length> estimatedRange) {
                Property<Length> property = estimatedRange.setIdentifier((byte)2);
                this.addProperty(property);
                return this;
            }

            public Builder setBatteryLevel(Property<Double> batteryLevel) {
                Property<Double> property = batteryLevel.setIdentifier((byte)3);
                this.addProperty(property);
                return this;
            }

            @Deprecated
            public Builder setBatteryCurrentAC(Property<ElectricCurrent> batteryCurrentAC) {
                Property<ElectricCurrent> property = batteryCurrentAC.setIdentifier((byte)4);
                this.addProperty(property);
                return this;
            }

            @Deprecated
            public Builder setBatteryCurrentDC(Property<ElectricCurrent> batteryCurrentDC) {
                Property<ElectricCurrent> property = batteryCurrentDC.setIdentifier((byte)5);
                this.addProperty(property);
                return this;
            }

            @Deprecated
            public Builder setChargerVoltageAC(Property<ElectricPotentialDifference> chargerVoltageAC) {
                Property<ElectricPotentialDifference> property = chargerVoltageAC.setIdentifier((byte)6);
                this.addProperty(property);
                return this;
            }

            @Deprecated
            public Builder setChargerVoltageDC(Property<ElectricPotentialDifference> chargerVoltageDC) {
                Property<ElectricPotentialDifference> property = chargerVoltageDC.setIdentifier((byte)7);
                this.addProperty(property);
                return this;
            }

            public Builder setChargeLimit(Property<Double> chargeLimit) {
                Property<Double> property = chargeLimit.setIdentifier((byte)8);
                this.addProperty(property);
                return this;
            }

            public Builder setTimeToCompleteCharge(Property<Duration> timeToCompleteCharge) {
                Property<Duration> property = timeToCompleteCharge.setIdentifier((byte)9);
                this.addProperty(property);
                return this;
            }

            @Deprecated
            public Builder setChargingRateKW(Property<Power> chargingRateKW) {
                Property<Power> property = chargingRateKW.setIdentifier((byte)10);
                this.addProperty(property);
                return this;
            }

            public Builder setChargePortState(Property<Position> chargePortState) {
                Property<Position> property = chargePortState.setIdentifier((byte)11);
                this.addProperty(property);
                return this;
            }

            public Builder setChargeMode(Property<ChargeMode> chargeMode) {
                Property<ChargeMode> property = chargeMode.setIdentifier((byte)12);
                this.addProperty(property);
                return this;
            }

            public Builder setMaxChargingCurrent(Property<ElectricCurrent> maxChargingCurrent) {
                Property<ElectricCurrent> property = maxChargingCurrent.setIdentifier((byte)14);
                this.addProperty(property);
                return this;
            }

            public Builder setPlugType(Property<PlugType> plugType) {
                Property<PlugType> property = plugType.setIdentifier((byte)15);
                this.addProperty(property);
                return this;
            }

            public Builder setChargingWindowChosen(Property<ChargingWindowChosen> chargingWindowChosen) {
                Property<ChargingWindowChosen> property = chargingWindowChosen.setIdentifier((byte)16);
                this.addProperty(property);
                return this;
            }

            public Builder setDepartureTimes(Property<DepartureTime>[] departureTimes) {
                for (int i = 0; i < departureTimes.length; ++i) {
                    this.addDepartureTime(departureTimes[i]);
                }
                return this;
            }

            public Builder addDepartureTime(Property<DepartureTime> departureTime) {
                departureTime.setIdentifier((byte)17);
                this.addProperty(departureTime);
                return this;
            }

            public Builder setReductionTimes(Property<ReductionTime>[] reductionTimes) {
                for (int i = 0; i < reductionTimes.length; ++i) {
                    this.addReductionTime(reductionTimes[i]);
                }
                return this;
            }

            public Builder addReductionTime(Property<ReductionTime> reductionTime) {
                reductionTime.setIdentifier((byte)19);
                this.addProperty(reductionTime);
                return this;
            }

            public Builder setBatteryTemperature(Property<Temperature> batteryTemperature) {
                Property<Temperature> property = batteryTemperature.setIdentifier((byte)20);
                this.addProperty(property);
                return this;
            }

            public Builder setTimers(Property<Timer>[] timers) {
                for (int i = 0; i < timers.length; ++i) {
                    this.addTimer(timers[i]);
                }
                return this;
            }

            public Builder addTimer(Property<Timer> timer) {
                timer.setIdentifier((byte)21);
                this.addProperty(timer);
                return this;
            }

            public Builder setPluggedIn(Property<PluggedIn> pluggedIn) {
                Property<PluggedIn> property = pluggedIn.setIdentifier((byte)22);
                this.addProperty(property);
                return this;
            }

            public Builder setStatus(Property<Status> status) {
                Property<Status> property = status.setIdentifier((byte)23);
                this.addProperty(property);
                return this;
            }

            public Builder setChargingRate(Property<Power> chargingRate) {
                Property<Power> property = chargingRate.setIdentifier((byte)24);
                this.addProperty(property);
                return this;
            }

            public Builder setBatteryCurrent(Property<ElectricCurrent> batteryCurrent) {
                Property<ElectricCurrent> property = batteryCurrent.setIdentifier((byte)25);
                this.addProperty(property);
                return this;
            }

            public Builder setChargerVoltage(Property<ElectricPotentialDifference> chargerVoltage) {
                Property<ElectricPotentialDifference> property = chargerVoltage.setIdentifier((byte)26);
                this.addProperty(property);
                return this;
            }

            public Builder setCurrentType(Property<CurrentType> currentType) {
                Property<CurrentType> property = currentType.setIdentifier((byte)27);
                this.addProperty(property);
                return this;
            }

            public Builder setMaxRange(Property<Length> maxRange) {
                Property<Length> property = maxRange.setIdentifier((byte)28);
                this.addProperty(property);
                return this;
            }

            public Builder setStarterBatteryState(Property<StarterBatteryState> starterBatteryState) {
                Property<StarterBatteryState> property = starterBatteryState.setIdentifier((byte)29);
                this.addProperty(property);
                return this;
            }

            public Builder setSmartChargingStatus(Property<SmartChargingStatus> smartChargingStatus) {
                Property<SmartChargingStatus> property = smartChargingStatus.setIdentifier((byte)30);
                this.addProperty(property);
                return this;
            }

            public Builder setBatteryLevelAtDeparture(Property<Double> batteryLevelAtDeparture) {
                Property<Double> property = batteryLevelAtDeparture.setIdentifier((byte)31);
                this.addProperty(property);
                return this;
            }

            public Builder setPreconditioningDepartureStatus(Property<ActiveState> preconditioningDepartureStatus) {
                Property<ActiveState> property = preconditioningDepartureStatus.setIdentifier((byte)32);
                this.addProperty(property);
                return this;
            }

            public Builder setPreconditioningImmediateStatus(Property<ActiveState> preconditioningImmediateStatus) {
                Property<ActiveState> property = preconditioningImmediateStatus.setIdentifier((byte)33);
                this.addProperty(property);
                return this;
            }

            public Builder setPreconditioningDepartureEnabled(Property<EnabledState> preconditioningDepartureEnabled) {
                Property<EnabledState> property = preconditioningDepartureEnabled.setIdentifier((byte)34);
                this.addProperty(property);
                return this;
            }

            public Builder setPreconditioningError(Property<PreconditioningError> preconditioningError) {
                Property<PreconditioningError> property = preconditioningError.setIdentifier((byte)35);
                this.addProperty(property);
                return this;
            }

            public Builder setBatteryCapacity(Property<Energy> batteryCapacity) {
                Property<Energy> property = batteryCapacity.setIdentifier((byte)36);
                this.addProperty(property);
                return this;
            }

            public Builder setAuxiliaryPower(Property<Power> auxiliaryPower) {
                Property<Power> property = auxiliaryPower.setIdentifier((byte)37);
                this.addProperty(property);
                return this;
            }

            public Builder setChargingCompleteLock(Property<ActiveState> chargingCompleteLock) {
                Property<ActiveState> property = chargingCompleteLock.setIdentifier((byte)38);
                this.addProperty(property);
                return this;
            }

            public Builder setBatteryMaxAvailable(Property<Energy> batteryMaxAvailable) {
                Property<Energy> property = batteryMaxAvailable.setIdentifier((byte)39);
                this.addProperty(property);
                return this;
            }

            public Builder setChargingEndReason(Property<ChargingEndReason> chargingEndReason) {
                Property<ChargingEndReason> property = chargingEndReason.setIdentifier((byte)40);
                this.addProperty(property);
                return this;
            }

            public Builder setChargingPhases(Property<ChargingPhases> chargingPhases) {
                Property<ChargingPhases> property = chargingPhases.setIdentifier((byte)41);
                this.addProperty(property);
                return this;
            }

            public Builder setBatteryEnergy(Property<Energy> batteryEnergy) {
                Property<Energy> property = batteryEnergy.setIdentifier((byte)42);
                this.addProperty(property);
                return this;
            }

            public Builder setBatteryEnergyChargable(Property<Energy> batteryEnergyChargable) {
                Property<Energy> property = batteryEnergyChargable.setIdentifier((byte)43);
                this.addProperty(property);
                return this;
            }

            public Builder setChargingSingleImmediate(Property<ActiveState> chargingSingleImmediate) {
                Property<ActiveState> property = chargingSingleImmediate.setIdentifier((byte)44);
                this.addProperty(property);
                return this;
            }

            public Builder setChargingTimeDisplay(Property<ChargingTimeDisplay> chargingTimeDisplay) {
                Property<ChargingTimeDisplay> property = chargingTimeDisplay.setIdentifier((byte)45);
                this.addProperty(property);
                return this;
            }

            public Builder setDepartureTimeDisplay(Property<DepartureTimeDisplay> departureTimeDisplay) {
                Property<DepartureTimeDisplay> property = departureTimeDisplay.setIdentifier((byte)46);
                this.addProperty(property);
                return this;
            }

            public Builder setRestriction(Property<ChargingRestriction> restriction) {
                Property<ChargingRestriction> property = restriction.setIdentifier((byte)47);
                this.addProperty(property);
                return this;
            }

            public Builder setLimitStatus(Property<ActiveState> limitStatus) {
                Property<ActiveState> property = limitStatus.setIdentifier((byte)48);
                this.addProperty(property);
                return this;
            }

            public Builder setCurrentLimit(Property<ElectricCurrent> currentLimit) {
                Property<ElectricCurrent> property = currentLimit.setIdentifier((byte)49);
                this.addProperty(property);
                return this;
            }

            public Builder setSmartChargingOption(Property<SmartChargingOption> smartChargingOption) {
                Property<SmartChargingOption> property = smartChargingOption.setIdentifier((byte)50);
                this.addProperty(property);
                return this;
            }

            public Builder setPlugLockStatus(Property<LockState> plugLockStatus) {
                Property<LockState> property = plugLockStatus.setIdentifier((byte)51);
                this.addProperty(property);
                return this;
            }

            public Builder setFlapLockStatus(Property<LockState> flapLockStatus) {
                Property<LockState> property = flapLockStatus.setIdentifier((byte)52);
                this.addProperty(property);
                return this;
            }

            public Builder setAcousticLimit(Property<AcousticLimit> acousticLimit) {
                Property<AcousticLimit> property = acousticLimit.setIdentifier((byte)53);
                this.addProperty(property);
                return this;
            }

            public Builder setMinChargingCurrent(Property<ElectricCurrent> minChargingCurrent) {
                Property<ElectricCurrent> property = minChargingCurrent.setIdentifier((byte)54);
                this.addProperty(property);
                return this;
            }

            public Builder setEstimatedRangeTarget(Property<Length> estimatedRangeTarget) {
                Property<Length> property = estimatedRangeTarget.setIdentifier((byte)55);
                this.addProperty(property);
                return this;
            }

            public Builder setFullyChargedEndTimes(Property<WeekdayTime> fullyChargedEndTimes) {
                Property<WeekdayTime> property = fullyChargedEndTimes.setIdentifier((byte)56);
                this.addProperty(property);
                return this;
            }

            public Builder setPreconditioningScheduledTime(Property<Time> preconditioningScheduledTime) {
                Property<Time> property = preconditioningScheduledTime.setIdentifier((byte)57);
                this.addProperty(property);
                return this;
            }

            public Builder setPreconditioningRemainingTime(Property<Duration> preconditioningRemainingTime) {
                Property<Duration> property = preconditioningRemainingTime.setIdentifier((byte)58);
                this.addProperty(property);
                return this;
            }

            public Builder setBatteryVoltage(Property<ElectricPotentialDifference> batteryVoltage) {
                Property<ElectricPotentialDifference> property = batteryVoltage.setIdentifier((byte)59);
                this.addProperty(property);
                return this;
            }

            @Deprecated
            public Builder setBatteryTempretatureExtremes(Property<TemperatureExtreme> batteryTempretatureExtremes) {
                Property<TemperatureExtreme> property = batteryTempretatureExtremes.setIdentifier((byte)60);
                this.addProperty(property);
                return this;
            }

            public Builder setBatteryTemperatureControlDemand(Property<BatteryTemperatureControlDemand> batteryTemperatureControlDemand) {
                Property<BatteryTemperatureControlDemand> property = batteryTemperatureControlDemand.setIdentifier((byte)61);
                this.addProperty(property);
                return this;
            }

            public Builder setChargingCurrent(Property<ElectricCurrent> chargingCurrent) {
                Property<ElectricCurrent> property = chargingCurrent.setIdentifier((byte)62);
                this.addProperty(property);
                return this;
            }

            public Builder setBatteryStatus(Property<BatteryStatus> batteryStatus) {
                Property<BatteryStatus> property = batteryStatus.setIdentifier((byte)63);
                this.addProperty(property);
                return this;
            }

            public Builder setBatteryLed(Property<BatteryLed> batteryLed) {
                Property<BatteryLed> property = batteryLed.setIdentifier((byte)64);
                this.addProperty(property);
                return this;
            }

            public Builder setBatteryCoolingTemperature(Property<Temperature> batteryCoolingTemperature) {
                Property<Temperature> property = batteryCoolingTemperature.setIdentifier((byte)65);
                this.addProperty(property);
                return this;
            }

            public Builder setBatteryTemperatureExtremes(Property<TemperatureExtreme> batteryTemperatureExtremes) {
                Property<TemperatureExtreme> property = batteryTemperatureExtremes.setIdentifier((byte)66);
                this.addProperty(property);
                return this;
            }

            public Builder setDrivingModePHEV(Property<DrivingModePhev> drivingModePHEV) {
                Property<DrivingModePhev> property = drivingModePHEV.setIdentifier((byte)67);
                this.addProperty(property);
                return this;
            }

            public Builder setBatteryChargeType(Property<BatteryChargeType> batteryChargeType) {
                Property<BatteryChargeType> property = batteryChargeType.setIdentifier((byte)68);
                this.addProperty(property);
                return this;
            }

            public Builder setDistanceToCompleteCharge(Property<Length> distanceToCompleteCharge) {
                Property<Length> property = distanceToCompleteCharge.setIdentifier((byte)69);
                this.addProperty(property);
                return this;
            }
        }
    }

    public static class SetReductionOfChargingCurrentTimes
    extends SetCommand {
        List<Property<ReductionTime>> reductionTimes;

        public List<Property<ReductionTime>> getReductionTimes() {
            return this.reductionTimes;
        }

        public SetReductionOfChargingCurrentTimes(List<ReductionTime> reductionTimes) {
            super(35);
            ArrayList<Property<ReductionTime>> reductionTimesBuilder = new ArrayList<Property<ReductionTime>>();
            if (reductionTimes != null) {
                for (ReductionTime reductionTime : reductionTimes) {
                    Property<ReductionTime> prop = new Property<ReductionTime>(19, reductionTime);
                    reductionTimesBuilder.add(prop);
                    this.addProperty(prop);
                }
            }
            this.reductionTimes = reductionTimesBuilder;
            this.createBytes();
        }

        SetReductionOfChargingCurrentTimes(byte[] bytes) throws PropertyParseException {
            super(bytes);
            ArrayList<Property<ReductionTime>> reductionTimesBuilder = new ArrayList<Property<ReductionTime>>();
            while (this.propertyIterator.hasNext()) {
                this.propertyIterator.parseNextSetter(p -> {
                    if (p.getPropertyIdentifier() == 19) {
                        Property<ReductionTime> reductionTime = new Property<ReductionTime>(ReductionTime.class, p);
                        reductionTimesBuilder.add(reductionTime);
                        return reductionTime;
                    }
                    return null;
                });
            }
            this.reductionTimes = reductionTimesBuilder;
            if (this.reductionTimes.size() == 0) {
                throw new PropertyParseException(this.mandatoryPropertyErrorMessage(((Object)((Object)this)).getClass()));
            }
        }
    }

    public static class SetChargingTimers
    extends SetCommand {
        List<Property<Timer>> timers;

        public List<Property<Timer>> getTimers() {
            return this.timers;
        }

        public SetChargingTimers(List<Timer> timers) {
            super(35);
            ArrayList<Property<Timer>> timersBuilder = new ArrayList<Property<Timer>>();
            if (timers != null) {
                for (Timer timer : timers) {
                    Property<Timer> prop = new Property<Timer>(21, timer);
                    timersBuilder.add(prop);
                    this.addProperty(prop);
                }
            }
            this.timers = timersBuilder;
            this.createBytes();
        }

        SetChargingTimers(byte[] bytes) throws PropertyParseException {
            super(bytes);
            ArrayList<Property<Timer>> timersBuilder = new ArrayList<Property<Timer>>();
            while (this.propertyIterator.hasNext()) {
                this.propertyIterator.parseNextSetter(p -> {
                    if (p.getPropertyIdentifier() == 21) {
                        Property<Timer> timer = new Property<Timer>(Timer.class, p);
                        timersBuilder.add(timer);
                        return timer;
                    }
                    return null;
                });
            }
            this.timers = timersBuilder;
            if (this.timers.size() == 0) {
                throw new PropertyParseException(this.mandatoryPropertyErrorMessage(((Object)((Object)this)).getClass()));
            }
        }
    }

    public static class SetChargeMode
    extends SetCommand {
        Property<ChargeMode> chargeMode = new Property<ChargeMode>(ChargeMode.class, 12);

        public Property<ChargeMode> getChargeMode() {
            return this.chargeMode;
        }

        public SetChargeMode(ChargeMode chargeMode) {
            super(35);
            if (chargeMode == ChargeMode.INDUCTIVE || chargeMode == ChargeMode.CONDUCTIVE || chargeMode == ChargeMode.PUSH_BUTTON) {
                throw new IllegalArgumentException();
            }
            this.addProperty(this.chargeMode.update(chargeMode));
            this.createBytes();
        }

        SetChargeMode(byte[] bytes) throws PropertyParseException {
            super(bytes);
            while (this.propertyIterator.hasNext()) {
                this.propertyIterator.parseNextSetter(p -> {
                    if (p.getPropertyIdentifier() == 12) {
                        return this.chargeMode.update(p);
                    }
                    return null;
                });
            }
            if (this.chargeMode.getValue() == null) {
                throw new PropertyParseException(this.mandatoryPropertyErrorMessage(((Object)((Object)this)).getClass()));
            }
        }
    }

    public static class OpenCloseChargingPort
    extends SetCommand {
        Property<Position> chargePortState = new Property<Position>(Position.class, 11);

        public Property<Position> getChargePortState() {
            return this.chargePortState;
        }

        public OpenCloseChargingPort(Position chargePortState) {
            super(35);
            this.addProperty(this.chargePortState.update(chargePortState));
            this.createBytes();
        }

        OpenCloseChargingPort(byte[] bytes) throws PropertyParseException {
            super(bytes);
            while (this.propertyIterator.hasNext()) {
                this.propertyIterator.parseNextSetter(p -> {
                    if (p.getPropertyIdentifier() == 11) {
                        return this.chargePortState.update(p);
                    }
                    return null;
                });
            }
            if (this.chargePortState.getValue() == null) {
                throw new PropertyParseException(this.mandatoryPropertyErrorMessage(((Object)((Object)this)).getClass()));
            }
        }
    }

    public static class SetChargeLimit
    extends SetCommand {
        Property<Double> chargeLimit = new Property<Double>(Double.class, 8);

        public Property<Double> getChargeLimit() {
            return this.chargeLimit;
        }

        public SetChargeLimit(Double chargeLimit) {
            super(35);
            this.addProperty(this.chargeLimit.update(chargeLimit));
            this.createBytes();
        }

        SetChargeLimit(byte[] bytes) throws PropertyParseException {
            super(bytes);
            while (this.propertyIterator.hasNext()) {
                this.propertyIterator.parseNextSetter(p -> {
                    if (p.getPropertyIdentifier() == 8) {
                        return this.chargeLimit.update(p);
                    }
                    return null;
                });
            }
            if (this.chargeLimit.getValue() == null) {
                throw new PropertyParseException(this.mandatoryPropertyErrorMessage(((Object)((Object)this)).getClass()));
            }
        }
    }

    public static class StartStopCharging
    extends SetCommand {
        Property<Status> status = new Property<Status>(Status.class, 23);

        public Property<Status> getStatus() {
            return this.status;
        }

        public StartStopCharging(Status status) {
            super(35);
            if (status == Status.CHARGING_COMPLETE || status == Status.INITIALISING || status == Status.CHARGING_PAUSED || status == Status.CHARGING_ERROR || status == Status.CABLE_UNPLUGGED || status == Status.SLOW_CHARGING || status == Status.FAST_CHARGING || status == Status.DISCHARGING || status == Status.FOREIGN_OBJECT_DETECTED || status == Status.CONDITIONING || status == Status.FLAP_OPEN) {
                throw new IllegalArgumentException();
            }
            this.addProperty(this.status.update(status));
            this.createBytes();
        }

        StartStopCharging(byte[] bytes) throws PropertyParseException {
            super(bytes);
            while (this.propertyIterator.hasNext()) {
                this.propertyIterator.parseNextSetter(p -> {
                    if (p.getPropertyIdentifier() == 23) {
                        return this.status.update(p);
                    }
                    return null;
                });
            }
            if (this.status.getValue() == null) {
                throw new PropertyParseException(this.mandatoryPropertyErrorMessage(((Object)((Object)this)).getClass()));
            }
        }
    }

    @Deprecated
    public static class GetProperties
    extends GetCommand<State> {
        public GetProperties(Bytes propertyIdentifiers) {
            super(State.class, (Integer)35, propertyIdentifiers);
        }

        public GetProperties(byte ... propertyIdentifiers) {
            super(State.class, (Integer)35, new Bytes(propertyIdentifiers));
        }

        GetProperties(byte[] bytes, boolean fromRaw) throws CommandParseException {
            super(State.class, bytes);
        }
    }

    public static class GetState
    extends GetCommand<State> {
        public GetState() {
            super(State.class, 35);
        }

        public GetState(Bytes propertyIdentifiers) {
            super(State.class, (Integer)35, propertyIdentifiers);
        }

        public GetState(byte ... propertyIdentifiers) {
            super(State.class, (Integer)35, new Bytes(propertyIdentifiers));
        }

        GetState(byte[] bytes, boolean fromRaw) throws CommandParseException {
            super(State.class, bytes);
        }
    }

    public static class GetStateAvailability
    extends GetAvailabilityCommand {
        public GetStateAvailability() {
            super(35);
        }

        public GetStateAvailability(Bytes propertyIdentifiers) {
            super(35, propertyIdentifiers);
        }

        public GetStateAvailability(byte ... propertyIdentifiers) {
            super(35, new Bytes(propertyIdentifiers));
        }

        GetStateAvailability(byte[] bytes, boolean fromRaw) throws CommandParseException {
            super(bytes);
        }
    }
}

