/*
 * Decompiled with CFR 0.152.
 */
package com.highmobility.autoapi;

import com.highmobility.autoapi.Command;
import com.highmobility.autoapi.CommandResolver;
import com.highmobility.autoapi.SetCommand;
import com.highmobility.autoapi.property.Property;
import com.highmobility.autoapi.value.ActiveState;
import com.highmobility.autoapi.value.ChargingCost;
import com.highmobility.autoapi.value.ChargingLocation;
import com.highmobility.autoapi.value.ChargingPoint;
import com.highmobility.autoapi.value.measurement.Duration;
import com.highmobility.autoapi.value.measurement.Energy;
import com.highmobility.autoapi.value.measurement.Length;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;

public class ChargingSession {
    public static final int IDENTIFIER = 109;
    public static final byte PROPERTY_PUBLIC_CHARGING_POINTS = 1;
    public static final byte PROPERTY_DISPLAYED_STATE_OF_CHARGE = 2;
    public static final byte PROPERTY_DISPLAYED_START_STATE_OF_CHARGE = 3;
    public static final byte PROPERTY_BUSINESS_ERRORS = 4;
    public static final byte PROPERTY_TIME_ZONE = 5;
    public static final byte PROPERTY_START_TIME = 6;
    public static final byte PROPERTY_END_TIME = 7;
    public static final byte PROPERTY_TOTAL_CHARGING_DURATION = 8;
    public static final byte PROPERTY_CALCULATED_ENERGY_CHARGED = 9;
    public static final byte PROPERTY_ENERGY_CHARGED = 10;
    public static final byte PROPERTY_PRECONDITIONING_STATE = 11;
    public static final byte PROPERTY_ODOMETER = 12;
    public static final byte PROPERTY_CHARGING_COST = 13;
    public static final byte PROPERTY_LOCATION = 14;

    public static class State
    extends SetCommand {
        List<Property<ChargingPoint>> publicChargingPoints;
        Property<Double> displayedStateOfCharge = new Property<Double>(Double.class, 2);
        Property<Double> displayedStartStateOfCharge = new Property<Double>(Double.class, 3);
        List<Property<String>> businessErrors;
        Property<String> timeZone = new Property<String>(String.class, 5);
        Property<Calendar> startTime = new Property<Calendar>(Calendar.class, 6);
        Property<Calendar> endTime = new Property<Calendar>(Calendar.class, 7);
        Property<Duration> totalChargingDuration = new Property<Duration>(Duration.class, 8);
        Property<Energy> calculatedEnergyCharged = new Property<Energy>(Energy.class, 9);
        Property<Energy> energyCharged = new Property<Energy>(Energy.class, 10);
        Property<ActiveState> preconditioningState = new Property<ActiveState>(ActiveState.class, 11);
        Property<Length> odometer = new Property<Length>(Length.class, 12);
        Property<ChargingCost> chargingCost = new Property<ChargingCost>(ChargingCost.class, 13);
        Property<ChargingLocation> location = new Property<ChargingLocation>(ChargingLocation.class, 14);

        public List<Property<ChargingPoint>> getPublicChargingPoints() {
            return this.publicChargingPoints;
        }

        public Property<Double> getDisplayedStateOfCharge() {
            return this.displayedStateOfCharge;
        }

        public Property<Double> getDisplayedStartStateOfCharge() {
            return this.displayedStartStateOfCharge;
        }

        public List<Property<String>> getBusinessErrors() {
            return this.businessErrors;
        }

        public Property<String> getTimeZone() {
            return this.timeZone;
        }

        public Property<Calendar> getStartTime() {
            return this.startTime;
        }

        public Property<Calendar> getEndTime() {
            return this.endTime;
        }

        public Property<Duration> getTotalChargingDuration() {
            return this.totalChargingDuration;
        }

        public Property<Energy> getCalculatedEnergyCharged() {
            return this.calculatedEnergyCharged;
        }

        public Property<Energy> getEnergyCharged() {
            return this.energyCharged;
        }

        public Property<ActiveState> getPreconditioningState() {
            return this.preconditioningState;
        }

        public Property<Length> getOdometer() {
            return this.odometer;
        }

        public Property<ChargingCost> getChargingCost() {
            return this.chargingCost;
        }

        public Property<ChargingLocation> getLocation() {
            return this.location;
        }

        State(byte[] bytes) {
            super(bytes);
            ArrayList<Property<ChargingPoint>> publicChargingPointsBuilder = new ArrayList<Property<ChargingPoint>>();
            ArrayList<Property<String>> businessErrorsBuilder = new ArrayList<Property<String>>();
            while (this.propertyIterator.hasNext()) {
                this.propertyIterator.parseNextState(p -> {
                    switch (p.getPropertyIdentifier()) {
                        case 1: {
                            Property<ChargingPoint> publicChargingPoint = new Property<ChargingPoint>(ChargingPoint.class, p);
                            publicChargingPointsBuilder.add(publicChargingPoint);
                            return publicChargingPoint;
                        }
                        case 2: {
                            return this.displayedStateOfCharge.update(p);
                        }
                        case 3: {
                            return this.displayedStartStateOfCharge.update(p);
                        }
                        case 4: {
                            Property<String> businessError = new Property<String>(String.class, p);
                            businessErrorsBuilder.add(businessError);
                            return businessError;
                        }
                        case 5: {
                            return this.timeZone.update(p);
                        }
                        case 6: {
                            return this.startTime.update(p);
                        }
                        case 7: {
                            return this.endTime.update(p);
                        }
                        case 8: {
                            return this.totalChargingDuration.update(p);
                        }
                        case 9: {
                            return this.calculatedEnergyCharged.update(p);
                        }
                        case 10: {
                            return this.energyCharged.update(p);
                        }
                        case 11: {
                            return this.preconditioningState.update(p);
                        }
                        case 12: {
                            return this.odometer.update(p);
                        }
                        case 13: {
                            return this.chargingCost.update(p);
                        }
                        case 14: {
                            return this.location.update(p);
                        }
                    }
                    return null;
                });
            }
            this.publicChargingPoints = publicChargingPointsBuilder;
            this.businessErrors = businessErrorsBuilder;
        }

        public static final class Builder
        extends SetCommand.Builder<Builder> {
            public Builder() {
                super(109);
            }

            @Override
            public State build() {
                SetCommand baseSetCommand = super.build();
                Command resolved = CommandResolver.resolve(baseSetCommand.getByteArray());
                return (State)resolved;
            }

            public Builder setPublicChargingPoints(Property<ChargingPoint>[] publicChargingPoints) {
                for (int i = 0; i < publicChargingPoints.length; ++i) {
                    this.addPublicChargingPoint(publicChargingPoints[i]);
                }
                return this;
            }

            public Builder addPublicChargingPoint(Property<ChargingPoint> publicChargingPoint) {
                publicChargingPoint.setIdentifier((byte)1);
                this.addProperty(publicChargingPoint);
                return this;
            }

            public Builder setDisplayedStateOfCharge(Property<Double> displayedStateOfCharge) {
                Property<Double> property = displayedStateOfCharge.setIdentifier((byte)2);
                this.addProperty(property);
                return this;
            }

            public Builder setDisplayedStartStateOfCharge(Property<Double> displayedStartStateOfCharge) {
                Property<Double> property = displayedStartStateOfCharge.setIdentifier((byte)3);
                this.addProperty(property);
                return this;
            }

            public Builder setBusinessErrors(Property<String>[] businessErrors) {
                for (int i = 0; i < businessErrors.length; ++i) {
                    this.addBusinessError(businessErrors[i]);
                }
                return this;
            }

            public Builder addBusinessError(Property<String> businessError) {
                businessError.setIdentifier((byte)4);
                this.addProperty(businessError);
                return this;
            }

            public Builder setTimeZone(Property<String> timeZone) {
                Property<String> property = timeZone.setIdentifier((byte)5);
                this.addProperty(property);
                return this;
            }

            public Builder setStartTime(Property<Calendar> startTime) {
                Property<Calendar> property = startTime.setIdentifier((byte)6);
                this.addProperty(property);
                return this;
            }

            public Builder setEndTime(Property<Calendar> endTime) {
                Property<Calendar> property = endTime.setIdentifier((byte)7);
                this.addProperty(property);
                return this;
            }

            public Builder setTotalChargingDuration(Property<Duration> totalChargingDuration) {
                Property<Duration> property = totalChargingDuration.setIdentifier((byte)8);
                this.addProperty(property);
                return this;
            }

            public Builder setCalculatedEnergyCharged(Property<Energy> calculatedEnergyCharged) {
                Property<Energy> property = calculatedEnergyCharged.setIdentifier((byte)9);
                this.addProperty(property);
                return this;
            }

            public Builder setEnergyCharged(Property<Energy> energyCharged) {
                Property<Energy> property = energyCharged.setIdentifier((byte)10);
                this.addProperty(property);
                return this;
            }

            public Builder setPreconditioningState(Property<ActiveState> preconditioningState) {
                Property<ActiveState> property = preconditioningState.setIdentifier((byte)11);
                this.addProperty(property);
                return this;
            }

            public Builder setOdometer(Property<Length> odometer) {
                Property<Length> property = odometer.setIdentifier((byte)12);
                this.addProperty(property);
                return this;
            }

            public Builder setChargingCost(Property<ChargingCost> chargingCost) {
                Property<ChargingCost> property = chargingCost.setIdentifier((byte)13);
                this.addProperty(property);
                return this;
            }

            public Builder setLocation(Property<ChargingLocation> location) {
                Property<ChargingLocation> property = location.setIdentifier((byte)14);
                this.addProperty(property);
                return this;
            }
        }
    }
}

