/*
 * Decompiled with CFR 0.152.
 */
package com.highmobility.autoapi;

import com.highmobility.autoapi.Adas;
import com.highmobility.autoapi.AutoApiLogger;
import com.highmobility.autoapi.Browser;
import com.highmobility.autoapi.Capabilities;
import com.highmobility.autoapi.Charging;
import com.highmobility.autoapi.ChargingSession;
import com.highmobility.autoapi.ChassisSettings;
import com.highmobility.autoapi.Climate;
import com.highmobility.autoapi.Command;
import com.highmobility.autoapi.CommandParseException;
import com.highmobility.autoapi.Crash;
import com.highmobility.autoapi.CruiseControl;
import com.highmobility.autoapi.DashboardLights;
import com.highmobility.autoapi.Diagnostics;
import com.highmobility.autoapi.Doors;
import com.highmobility.autoapi.DriverFatigue;
import com.highmobility.autoapi.Engine;
import com.highmobility.autoapi.FailureMessage;
import com.highmobility.autoapi.FirmwareVersion;
import com.highmobility.autoapi.Fueling;
import com.highmobility.autoapi.Graphics;
import com.highmobility.autoapi.HeartRate;
import com.highmobility.autoapi.Historical;
import com.highmobility.autoapi.HomeCharger;
import com.highmobility.autoapi.HonkHornFlashLights;
import com.highmobility.autoapi.Hood;
import com.highmobility.autoapi.Identifier;
import com.highmobility.autoapi.Ignition;
import com.highmobility.autoapi.KeyfobPosition;
import com.highmobility.autoapi.LightConditions;
import com.highmobility.autoapi.Lights;
import com.highmobility.autoapi.Maintenance;
import com.highmobility.autoapi.Messaging;
import com.highmobility.autoapi.Mobile;
import com.highmobility.autoapi.MultiCommand;
import com.highmobility.autoapi.NaviDestination;
import com.highmobility.autoapi.Notifications;
import com.highmobility.autoapi.Offroad;
import com.highmobility.autoapi.ParkingBrake;
import com.highmobility.autoapi.ParkingTicket;
import com.highmobility.autoapi.PowerTakeoff;
import com.highmobility.autoapi.PropertyParseException;
import com.highmobility.autoapi.Race;
import com.highmobility.autoapi.RemoteControl;
import com.highmobility.autoapi.RooftopControl;
import com.highmobility.autoapi.Seats;
import com.highmobility.autoapi.Tachograph;
import com.highmobility.autoapi.TextInput;
import com.highmobility.autoapi.TheftAlarm;
import com.highmobility.autoapi.Trips;
import com.highmobility.autoapi.Trunk;
import com.highmobility.autoapi.Type;
import com.highmobility.autoapi.Universal;
import com.highmobility.autoapi.Usage;
import com.highmobility.autoapi.ValetMode;
import com.highmobility.autoapi.VehicleInformation;
import com.highmobility.autoapi.VehicleLocation;
import com.highmobility.autoapi.VehicleStatus;
import com.highmobility.autoapi.VehicleTime;
import com.highmobility.autoapi.VideoHandover;
import com.highmobility.autoapi.WakeUp;
import com.highmobility.autoapi.WeatherConditions;
import com.highmobility.autoapi.WiFi;
import com.highmobility.autoapi.Windows;
import com.highmobility.autoapi.Windscreen;
import com.highmobility.utils.Base64;
import com.highmobility.utils.ByteUtils;
import com.highmobility.value.Bytes;

public class CommandResolver {
    static Environment _environment = Environment.OWNER;

    public static Command resolve(Bytes bytes) {
        return CommandResolver.resolve(bytes.getByteArray());
    }

    public static Command resolve(byte[] bytes) {
        if (bytes == null || bytes.length < 4) {
            return new Command(bytes);
        }
        Command command = null;
        Integer identifier = Identifier.fromBytes(bytes[1], bytes[2]);
        Integer type = Type.fromByte(bytes[3]);
        try {
            switch (identifier) {
                case 17: {
                    if (type == 1) {
                        if (CommandResolver.getEnvironment() != Environment.OWNER) break;
                        command = new VehicleStatus.State(bytes);
                        break;
                    }
                    if (type != 0) break;
                    command = new VehicleStatus.GetVehicleStatus(bytes, true);
                    break;
                }
                case 71: {
                    if (type == 1) {
                        if (CommandResolver.getEnvironment() == Environment.OWNER) {
                            command = new ParkingTicket.State(bytes);
                            break;
                        }
                        SetterIterator iterator = new SetterIterator(2, ParkingTicket.class.getSimpleName());
                        while (iterator.hasNext()) {
                            command = iterator.parseNext(index -> {
                                switch (index) {
                                    case 0: {
                                        return new ParkingTicket.StartParking(bytes);
                                    }
                                    case 1: {
                                        return new ParkingTicket.EndParking(bytes);
                                    }
                                }
                                return null;
                            });
                        }
                        break;
                    }
                    if (type == 0) {
                        command = new ParkingTicket.GetParkingTicket(bytes, true);
                        break;
                    }
                    if (type != 2) break;
                    command = new ParkingTicket.GetParkingTicketAvailability(bytes, true);
                    break;
                }
                case 109: {
                    if (type != 1 || CommandResolver.getEnvironment() != Environment.OWNER) break;
                    command = new ChargingSession.State(bytes);
                    break;
                }
                case 73: {
                    if (type != 1) break;
                    command = new Browser.LoadUrl(bytes);
                    break;
                }
                case 69: {
                    if (type == 1) {
                        if (CommandResolver.getEnvironment() == Environment.OWNER) {
                            command = new Windows.State(bytes);
                            break;
                        }
                        command = new Windows.ControlWindows(bytes);
                        break;
                    }
                    if (type == 0) {
                        command = new Windows.GetWindows(bytes, true);
                        break;
                    }
                    if (type != 2) break;
                    command = new Windows.GetWindowsAvailability(bytes, true);
                    break;
                }
                case 80: {
                    if (type == 1) {
                        if (CommandResolver.getEnvironment() != Environment.OWNER) break;
                        command = new VehicleTime.State(bytes);
                        break;
                    }
                    if (type == 0) {
                        command = new VehicleTime.GetVehicleTime(bytes, true);
                        break;
                    }
                    if (type != 2) break;
                    command = new VehicleTime.GetVehicleTimeAvailability(bytes, true);
                    break;
                }
                case 65: {
                    if (type == 1) {
                        if (CommandResolver.getEnvironment() != Environment.OWNER) break;
                        command = new DriverFatigue.State(bytes);
                        break;
                    }
                    if (type == 0) {
                        command = new DriverFatigue.GetState(bytes, true);
                        break;
                    }
                    if (type != 2) break;
                    command = new DriverFatigue.GetStateAvailability(bytes, true);
                    break;
                }
                case 39: {
                    if (type == 1) {
                        if (CommandResolver.getEnvironment() == Environment.OWNER) {
                            command = new RemoteControl.State(bytes);
                            break;
                        }
                        SetterIterator iterator = new SetterIterator(3, RemoteControl.class.getSimpleName());
                        while (iterator.hasNext()) {
                            command = iterator.parseNext(index -> {
                                switch (index) {
                                    case 0: {
                                        return new RemoteControl.ControlCommand(bytes);
                                    }
                                    case 1: {
                                        return new RemoteControl.StartControl(bytes);
                                    }
                                    case 2: {
                                        return new RemoteControl.StopControl(bytes);
                                    }
                                }
                                return null;
                            });
                        }
                        break;
                    }
                    if (type == 0) {
                        command = new RemoteControl.GetControlState(bytes, true);
                        break;
                    }
                    if (type != 2) break;
                    command = new RemoteControl.GetControlStateAvailability(bytes, true);
                    break;
                }
                case 64: {
                    if (type == 1) {
                        if (CommandResolver.getEnvironment() == Environment.OWNER) {
                            command = new Fueling.State(bytes);
                            break;
                        }
                        command = new Fueling.ControlGasFlap(bytes);
                        break;
                    }
                    if (type == 0) {
                        command = new Fueling.GetGasFlapState(bytes, true);
                        break;
                    }
                    if (type != 2) break;
                    command = new Fueling.GetGasFlapStateAvailability(bytes, true);
                    break;
                }
                case 49: {
                    if (type == 1) {
                        if (CommandResolver.getEnvironment() == Environment.OWNER) {
                            command = new NaviDestination.State(bytes);
                            break;
                        }
                        command = new NaviDestination.SetNaviDestination(bytes);
                        break;
                    }
                    if (type == 0) {
                        command = new NaviDestination.GetNaviDestination(bytes, true);
                        break;
                    }
                    if (type != 2) break;
                    command = new NaviDestination.GetNaviDestinationAvailability(bytes, true);
                    break;
                }
                case 84: {
                    if (type == 1) {
                        if (CommandResolver.getEnvironment() != Environment.OWNER) break;
                        command = new LightConditions.State(bytes);
                        break;
                    }
                    if (type == 0) {
                        command = new LightConditions.GetLightConditions(bytes, true);
                        break;
                    }
                    if (type != 2) break;
                    command = new LightConditions.GetLightConditionsAvailability(bytes, true);
                    break;
                }
                case 82: {
                    if (type == 1) {
                        if (CommandResolver.getEnvironment() != Environment.OWNER) break;
                        command = new Offroad.State(bytes);
                        break;
                    }
                    if (type == 0) {
                        command = new Offroad.GetState(bytes, true);
                        break;
                    }
                    if (type != 2) break;
                    command = new Offroad.GetStateAvailability(bytes, true);
                    break;
                }
                case 33: {
                    if (type == 1) {
                        if (CommandResolver.getEnvironment() == Environment.OWNER) {
                            command = new Trunk.State(bytes);
                            break;
                        }
                        command = new Trunk.ControlTrunk(bytes);
                        break;
                    }
                    if (type == 0) {
                        command = new Trunk.GetState(bytes, true);
                        break;
                    }
                    if (type != 2) break;
                    command = new Trunk.GetStateAvailability(bytes, true);
                    break;
                }
                case 32: {
                    if (type == 1) {
                        if (CommandResolver.getEnvironment() == Environment.OWNER) {
                            command = new Doors.State(bytes);
                            break;
                        }
                        command = new Doors.LockUnlockDoors(bytes);
                        break;
                    }
                    if (type == 0) {
                        command = new Doors.GetState(bytes, true);
                        break;
                    }
                    if (type != 2) break;
                    command = new Doors.GetStateAvailability(bytes, true);
                    break;
                }
                case 40: {
                    if (type == 1) {
                        if (CommandResolver.getEnvironment() == Environment.OWNER) {
                            command = new ValetMode.State(bytes);
                            break;
                        }
                        command = new ValetMode.ActivateDeactivateValetMode(bytes);
                        break;
                    }
                    if (type == 0) {
                        command = new ValetMode.GetValetMode(bytes, true);
                        break;
                    }
                    if (type != 2) break;
                    command = new ValetMode.GetValetModeAvailability(bytes, true);
                    break;
                }
                case 97: {
                    if (type == 1) {
                        if (CommandResolver.getEnvironment() != Environment.OWNER) break;
                        command = new DashboardLights.State(bytes);
                        break;
                    }
                    if (type == 0) {
                        command = new DashboardLights.GetDashboardLights(bytes, true);
                        break;
                    }
                    if (type != 2) break;
                    command = new DashboardLights.GetDashboardLightsAvailability(bytes, true);
                    break;
                }
                case 19: {
                    if (type != 1) break;
                    if (CommandResolver.getEnvironment() == Environment.OWNER) {
                        command = new MultiCommand.State(bytes);
                        break;
                    }
                    command = new MultiCommand.MultiCommandCommand(bytes);
                    break;
                }
                case 68: {
                    if (type != 1) break;
                    command = new TextInput.TextInputCommand(bytes);
                    break;
                }
                case 54: {
                    if (type == 1) {
                        if (CommandResolver.getEnvironment() == Environment.OWNER) {
                            command = new Lights.State(bytes);
                            break;
                        }
                        command = new Lights.ControlLights(bytes);
                        break;
                    }
                    if (type == 0) {
                        command = new Lights.GetState(bytes, true);
                        break;
                    }
                    if (type != 2) break;
                    command = new Lights.GetStateAvailability(bytes, true);
                    break;
                }
                case 83: {
                    if (type == 1) {
                        if (CommandResolver.getEnvironment() == Environment.OWNER) {
                            command = new ChassisSettings.State(bytes);
                            break;
                        }
                        SetterIterator iterator = new SetterIterator(4, ChassisSettings.class.getSimpleName());
                        while (iterator.hasNext()) {
                            command = iterator.parseNext(index -> {
                                switch (index) {
                                    case 0: {
                                        return new ChassisSettings.SetDrivingMode(bytes);
                                    }
                                    case 1: {
                                        return new ChassisSettings.StartStopSportsChrono(bytes);
                                    }
                                    case 2: {
                                        return new ChassisSettings.SetSpringRates(bytes);
                                    }
                                    case 3: {
                                        return new ChassisSettings.SetChassisPosition(bytes);
                                    }
                                }
                                return null;
                            });
                        }
                        break;
                    }
                    if (type == 0) {
                        command = new ChassisSettings.GetChassisSettings(bytes, true);
                        break;
                    }
                    if (type != 2) break;
                    command = new ChassisSettings.GetChassisSettingsAvailability(bytes, true);
                    break;
                }
                case 56: {
                    if (type != 1) break;
                    if (CommandResolver.getEnvironment() == Environment.OWNER) {
                        command = new Notifications.State(bytes);
                        break;
                    }
                    SetterIterator iterator = new SetterIterator(3, Notifications.class.getSimpleName());
                    while (iterator.hasNext()) {
                        command = iterator.parseNext(index -> {
                            switch (index) {
                                case 0: {
                                    return new Notifications.Notification(bytes);
                                }
                                case 1: {
                                    return new Notifications.Action(bytes);
                                }
                                case 2: {
                                    return new Notifications.ClearNotification(bytes);
                                }
                            }
                            return null;
                        });
                    }
                    break;
                }
                case 103: {
                    if (type == 1) {
                        if (CommandResolver.getEnvironment() != Environment.OWNER) break;
                        command = new Hood.State(bytes);
                        break;
                    }
                    if (type == 0) {
                        command = new Hood.GetState(bytes, true);
                        break;
                    }
                    if (type != 2) break;
                    command = new Hood.GetStateAvailability(bytes, true);
                    break;
                }
                case 35: {
                    if (type == 1) {
                        if (CommandResolver.getEnvironment() == Environment.OWNER) {
                            command = new Charging.State(bytes);
                            break;
                        }
                        SetterIterator iterator = new SetterIterator(6, Charging.class.getSimpleName());
                        while (iterator.hasNext()) {
                            command = iterator.parseNext(index -> {
                                switch (index) {
                                    case 0: {
                                        return new Charging.StartStopCharging(bytes);
                                    }
                                    case 1: {
                                        return new Charging.SetChargeLimit(bytes);
                                    }
                                    case 2: {
                                        return new Charging.OpenCloseChargingPort(bytes);
                                    }
                                    case 3: {
                                        return new Charging.SetChargeMode(bytes);
                                    }
                                    case 4: {
                                        return new Charging.SetChargingTimers(bytes);
                                    }
                                    case 5: {
                                        return new Charging.SetReductionOfChargingCurrentTimes(bytes);
                                    }
                                }
                                return null;
                            });
                        }
                        break;
                    }
                    if (type == 0) {
                        command = new Charging.GetState(bytes, true);
                        break;
                    }
                    if (type != 2) break;
                    command = new Charging.GetStateAvailability(bytes, true);
                    break;
                }
                case 102: {
                    if (type == 1) {
                        if (CommandResolver.getEnvironment() != Environment.OWNER) break;
                        command = new Mobile.State(bytes);
                        break;
                    }
                    if (type == 0) {
                        command = new Mobile.GetState(bytes, true);
                        break;
                    }
                    if (type != 2) break;
                    command = new Mobile.GetStateAvailability(bytes, true);
                    break;
                }
                case 107: {
                    if (type == 1) {
                        if (CommandResolver.getEnvironment() != Environment.OWNER) break;
                        command = new Crash.State(bytes);
                        break;
                    }
                    if (type == 0) {
                        command = new Crash.GetState(bytes, true);
                        break;
                    }
                    if (type != 2) break;
                    command = new Crash.GetStateAvailability(bytes, true);
                    break;
                }
                case 96: {
                    if (type == 1) {
                        if (CommandResolver.getEnvironment() == Environment.OWNER) {
                            command = new HomeCharger.State(bytes);
                            break;
                        }
                        SetterIterator iterator = new SetterIterator(5, HomeCharger.class.getSimpleName());
                        while (iterator.hasNext()) {
                            command = iterator.parseNext(index -> {
                                switch (index) {
                                    case 0: {
                                        return new HomeCharger.SetChargeCurrent(bytes);
                                    }
                                    case 1: {
                                        return new HomeCharger.SetPriceTariffs(bytes);
                                    }
                                    case 2: {
                                        return new HomeCharger.ActivateDeactivateSolarCharging(bytes);
                                    }
                                    case 3: {
                                        return new HomeCharger.EnableDisableWiFiHotspot(bytes);
                                    }
                                    case 4: {
                                        return new HomeCharger.AuthenticateExpire(bytes);
                                    }
                                }
                                return null;
                            });
                        }
                        break;
                    }
                    if (type == 0) {
                        command = new HomeCharger.GetState(bytes, true);
                        break;
                    }
                    if (type != 2) break;
                    command = new HomeCharger.GetStateAvailability(bytes, true);
                    break;
                }
                case 51: {
                    if (type == 1) {
                        if (CommandResolver.getEnvironment() != Environment.OWNER) break;
                        command = new Diagnostics.State(bytes);
                        break;
                    }
                    if (type == 0) {
                        command = new Diagnostics.GetState(bytes, true);
                        break;
                    }
                    if (type != 2) break;
                    command = new Diagnostics.GetStateAvailability(bytes, true);
                    break;
                }
                case 104: {
                    if (type == 1) {
                        if (CommandResolver.getEnvironment() != Environment.OWNER) break;
                        command = new Usage.State(bytes);
                        break;
                    }
                    if (type == 0) {
                        command = new Usage.GetUsage(bytes, true);
                        break;
                    }
                    if (type != 2) break;
                    command = new Usage.GetUsageAvailability(bytes, true);
                    break;
                }
                case 20: {
                    if (type == 1) {
                        if (CommandResolver.getEnvironment() != Environment.OWNER) break;
                        command = new VehicleInformation.State(bytes);
                        break;
                    }
                    if (type != 0) break;
                    command = new VehicleInformation.GetVehicleInformation(bytes, true);
                    break;
                }
                case 101: {
                    if (type == 1) {
                        if (CommandResolver.getEnvironment() == Environment.OWNER) {
                            command = new PowerTakeoff.State(bytes);
                            break;
                        }
                        command = new PowerTakeoff.ActivateDeactivatePowerTakeoff(bytes);
                        break;
                    }
                    if (type == 0) {
                        command = new PowerTakeoff.GetState(bytes, true);
                        break;
                    }
                    if (type != 2) break;
                    command = new PowerTakeoff.GetStateAvailability(bytes, true);
                    break;
                }
                case 34: {
                    if (type != 1) break;
                    command = new WakeUp.WakeUpCommand(bytes);
                    break;
                }
                case 67: {
                    if (type != 1) break;
                    command = new VideoHandover.VideoHandoverCommand(bytes);
                    break;
                }
                case 18: {
                    if (type != 1) break;
                    if (CommandResolver.getEnvironment() == Environment.OWNER) {
                        command = new Historical.State(bytes);
                        break;
                    }
                    SetterIterator iterator = new SetterIterator(3, Historical.class.getSimpleName());
                    while (iterator.hasNext()) {
                        command = iterator.parseNext(index -> {
                            switch (index) {
                                case 0: {
                                    return new Historical.RequestStates(bytes);
                                }
                                case 1: {
                                    return new Historical.GetTrips(bytes);
                                }
                                case 2: {
                                    return new Historical.GetChargingSessions(bytes);
                                }
                            }
                            return null;
                        });
                    }
                    break;
                }
                case 89: {
                    if (type == 1) {
                        if (CommandResolver.getEnvironment() == Environment.OWNER) {
                            command = new WiFi.State(bytes);
                            break;
                        }
                        SetterIterator iterator = new SetterIterator(3, WiFi.class.getSimpleName());
                        while (iterator.hasNext()) {
                            command = iterator.parseNext(index -> {
                                switch (index) {
                                    case 0: {
                                        return new WiFi.ConnectToNetwork(bytes);
                                    }
                                    case 1: {
                                        return new WiFi.ForgetNetwork(bytes);
                                    }
                                    case 2: {
                                        return new WiFi.EnableDisableWiFi(bytes);
                                    }
                                }
                                return null;
                            });
                        }
                        break;
                    }
                    if (type == 0) {
                        command = new WiFi.GetState(bytes, true);
                        break;
                    }
                    if (type != 2) break;
                    command = new WiFi.GetStateAvailability(bytes, true);
                    break;
                }
                case 48: {
                    if (type == 1) {
                        if (CommandResolver.getEnvironment() != Environment.OWNER) break;
                        command = new VehicleLocation.State(bytes);
                        break;
                    }
                    if (type == 0) {
                        command = new VehicleLocation.GetVehicleLocation(bytes, true);
                        break;
                    }
                    if (type != 2) break;
                    command = new VehicleLocation.GetVehicleLocationAvailability(bytes, true);
                    break;
                }
                case 41: {
                    if (type != 1) break;
                    command = new HeartRate.SendHeartRate(bytes);
                    break;
                }
                case 81: {
                    if (type != 1) break;
                    command = new Graphics.DisplayImage(bytes);
                    break;
                }
                case 87: {
                    if (type == 1) {
                        if (CommandResolver.getEnvironment() != Environment.OWNER) break;
                        command = new Race.State(bytes);
                        break;
                    }
                    if (type == 0) {
                        command = new Race.GetState(bytes, true);
                        break;
                    }
                    if (type != 2) break;
                    command = new Race.GetStateAvailability(bytes, true);
                    break;
                }
                case 3: {
                    if (type == 1) {
                        if (CommandResolver.getEnvironment() != Environment.OWNER) break;
                        command = new FirmwareVersion.State(bytes);
                        break;
                    }
                    if (type != 0) break;
                    command = new FirmwareVersion.GetFirmwareVersion(bytes, true);
                    break;
                }
                case 21: {
                    if (type == 1 || type != 0) break;
                    command = new Universal.GetUniversalProperties(bytes, true);
                    break;
                }
                case 70: {
                    if (type == 1) {
                        if (CommandResolver.getEnvironment() == Environment.OWNER) {
                            command = new TheftAlarm.State(bytes);
                            break;
                        }
                        command = new TheftAlarm.SetTheftAlarm(bytes);
                        break;
                    }
                    if (type == 0) {
                        command = new TheftAlarm.GetState(bytes, true);
                        break;
                    }
                    if (type != 2) break;
                    command = new TheftAlarm.GetStateAvailability(bytes, true);
                    break;
                }
                case 86: {
                    if (type == 1) {
                        if (CommandResolver.getEnvironment() != Environment.OWNER) break;
                        command = new Seats.State(bytes);
                        break;
                    }
                    if (type == 0) {
                        command = new Seats.GetState(bytes, true);
                        break;
                    }
                    if (type != 2) break;
                    command = new Seats.GetStateAvailability(bytes, true);
                    break;
                }
                case 100: {
                    if (type == 1) {
                        if (CommandResolver.getEnvironment() != Environment.OWNER) break;
                        command = new Tachograph.State(bytes);
                        break;
                    }
                    if (type == 0) {
                        command = new Tachograph.GetState(bytes, true);
                        break;
                    }
                    if (type != 2) break;
                    command = new Tachograph.GetStateAvailability(bytes, true);
                    break;
                }
                case 88: {
                    if (type == 1) {
                        if (CommandResolver.getEnvironment() == Environment.OWNER) {
                            command = new ParkingBrake.State(bytes);
                            break;
                        }
                        command = new ParkingBrake.SetParkingBrake(bytes);
                        break;
                    }
                    if (type == 0) {
                        command = new ParkingBrake.GetState(bytes, true);
                        break;
                    }
                    if (type != 2) break;
                    command = new ParkingBrake.GetStateAvailability(bytes, true);
                    break;
                }
                case 16: {
                    if (type == 1) {
                        if (CommandResolver.getEnvironment() != Environment.OWNER) break;
                        command = new Capabilities.State(bytes);
                        break;
                    }
                    if (type != 0) break;
                    command = new Capabilities.GetCapabilities(bytes, true);
                    break;
                }
                case 108: {
                    if (type == 1) {
                        if (CommandResolver.getEnvironment() != Environment.OWNER) break;
                        command = new Adas.State(bytes);
                        break;
                    }
                    if (type == 0) {
                        command = new Adas.GetState(bytes, true);
                        break;
                    }
                    if (type != 2) break;
                    command = new Adas.GetStateAvailability(bytes, true);
                    break;
                }
                case 52: {
                    if (type == 1) {
                        if (CommandResolver.getEnvironment() != Environment.OWNER) break;
                        command = new Maintenance.State(bytes);
                        break;
                    }
                    if (type == 0) {
                        command = new Maintenance.GetState(bytes, true);
                        break;
                    }
                    if (type != 2) break;
                    command = new Maintenance.GetStateAvailability(bytes, true);
                    break;
                }
                case 37: {
                    if (type == 1) {
                        if (CommandResolver.getEnvironment() == Environment.OWNER) {
                            command = new RooftopControl.State(bytes);
                            break;
                        }
                        command = new RooftopControl.ControlRooftop(bytes);
                        break;
                    }
                    if (type == 0) {
                        command = new RooftopControl.GetRooftopState(bytes, true);
                        break;
                    }
                    if (type != 2) break;
                    command = new RooftopControl.GetRooftopStateAvailability(bytes, true);
                    break;
                }
                case 2: {
                    if (type != 1 || CommandResolver.getEnvironment() != Environment.OWNER) break;
                    command = new FailureMessage.State(bytes);
                    break;
                }
                case 66: {
                    if (type == 1) {
                        if (CommandResolver.getEnvironment() == Environment.OWNER) {
                            command = new Windscreen.State(bytes);
                            break;
                        }
                        SetterIterator iterator = new SetterIterator(3, Windscreen.class.getSimpleName());
                        while (iterator.hasNext()) {
                            command = iterator.parseNext(index -> {
                                switch (index) {
                                    case 0: {
                                        return new Windscreen.SetWindscreenDamage(bytes);
                                    }
                                    case 1: {
                                        return new Windscreen.SetWindscreenReplacementNeeded(bytes);
                                    }
                                    case 2: {
                                        return new Windscreen.ControlWipers(bytes);
                                    }
                                }
                                return null;
                            });
                        }
                        break;
                    }
                    if (type == 0) {
                        command = new Windscreen.GetState(bytes, true);
                        break;
                    }
                    if (type != 2) break;
                    command = new Windscreen.GetStateAvailability(bytes, true);
                    break;
                }
                case 98: {
                    if (type == 1) {
                        if (CommandResolver.getEnvironment() == Environment.OWNER) {
                            command = new CruiseControl.State(bytes);
                            break;
                        }
                        command = new CruiseControl.ActivateDeactivateCruiseControl(bytes);
                        break;
                    }
                    if (type == 0) {
                        command = new CruiseControl.GetState(bytes, true);
                        break;
                    }
                    if (type != 2) break;
                    command = new CruiseControl.GetStateAvailability(bytes, true);
                    break;
                }
                case 106: {
                    if (type != 1 || CommandResolver.getEnvironment() != Environment.OWNER) break;
                    command = new Trips.State(bytes);
                    break;
                }
                case 72: {
                    if (type == 1) {
                        if (CommandResolver.getEnvironment() != Environment.OWNER) break;
                        command = new KeyfobPosition.State(bytes);
                        break;
                    }
                    if (type == 0) {
                        command = new KeyfobPosition.GetKeyfobPosition(bytes, true);
                        break;
                    }
                    if (type != 2) break;
                    command = new KeyfobPosition.GetKeyfobPositionAvailability(bytes, true);
                    break;
                }
                case 38: {
                    if (type == 1) {
                        if (CommandResolver.getEnvironment() == Environment.OWNER) {
                            command = new HonkHornFlashLights.State(bytes);
                            break;
                        }
                        SetterIterator iterator = new SetterIterator(2, HonkHornFlashLights.class.getSimpleName());
                        while (iterator.hasNext()) {
                            command = iterator.parseNext(index -> {
                                switch (index) {
                                    case 0: {
                                        return new HonkHornFlashLights.HonkFlash(bytes);
                                    }
                                    case 1: {
                                        return new HonkHornFlashLights.ActivateDeactivateEmergencyFlasher(bytes);
                                    }
                                }
                                return null;
                            });
                        }
                        break;
                    }
                    if (type == 0) {
                        command = new HonkHornFlashLights.GetFlashersState(bytes, true);
                        break;
                    }
                    if (type != 2) break;
                    command = new HonkHornFlashLights.GetFlashersStateAvailability(bytes, true);
                    break;
                }
                case 105: {
                    if (type == 1) {
                        if (CommandResolver.getEnvironment() == Environment.OWNER) {
                            command = new Engine.State(bytes);
                            break;
                        }
                        SetterIterator iterator = new SetterIterator(2, Engine.class.getSimpleName());
                        while (iterator.hasNext()) {
                            command = iterator.parseNext(index -> {
                                switch (index) {
                                    case 0: {
                                        return new Engine.TurnEngineOnOff(bytes);
                                    }
                                    case 1: {
                                        return new Engine.EnableDisableStartStop(bytes);
                                    }
                                }
                                return null;
                            });
                        }
                        break;
                    }
                    if (type == 0) {
                        command = new Engine.GetState(bytes, true);
                        break;
                    }
                    if (type != 2) break;
                    command = new Engine.GetStateAvailability(bytes, true);
                    break;
                }
                case 85: {
                    if (type == 1) {
                        if (CommandResolver.getEnvironment() != Environment.OWNER) break;
                        command = new WeatherConditions.State(bytes);
                        break;
                    }
                    if (type == 0) {
                        command = new WeatherConditions.GetWeatherConditions(bytes, true);
                        break;
                    }
                    if (type != 2) break;
                    command = new WeatherConditions.GetWeatherConditionsAvailability(bytes, true);
                    break;
                }
                case 55: {
                    if (type != 1) break;
                    if (CommandResolver.getEnvironment() == Environment.OWNER) {
                        command = new Messaging.State(bytes);
                        break;
                    }
                    command = new Messaging.MessageReceived(bytes);
                    break;
                }
                case 53: {
                    if (type == 1) {
                        if (CommandResolver.getEnvironment() == Environment.OWNER) {
                            command = new Ignition.State(bytes);
                            break;
                        }
                        command = new Ignition.TurnIgnitionOnOff(bytes);
                        break;
                    }
                    if (type == 0) {
                        command = new Ignition.GetState(bytes, true);
                        break;
                    }
                    if (type != 2) break;
                    command = new Ignition.GetStateAvailability(bytes, true);
                    break;
                }
                case 36: {
                    if (type == 1) {
                        if (CommandResolver.getEnvironment() == Environment.OWNER) {
                            command = new Climate.State(bytes);
                            break;
                        }
                        SetterIterator iterator = new SetterIterator(6, Climate.class.getSimpleName());
                        while (iterator.hasNext()) {
                            command = iterator.parseNext(index -> {
                                switch (index) {
                                    case 0: {
                                        return new Climate.ChangeStartingTimes(bytes);
                                    }
                                    case 1: {
                                        return new Climate.StartStopHvac(bytes);
                                    }
                                    case 2: {
                                        return new Climate.StartStopDefogging(bytes);
                                    }
                                    case 3: {
                                        return new Climate.StartStopDefrosting(bytes);
                                    }
                                    case 4: {
                                        return new Climate.StartStopIonising(bytes);
                                    }
                                    case 5: {
                                        return new Climate.SetTemperatureSettings(bytes);
                                    }
                                }
                                return null;
                            });
                        }
                        break;
                    }
                    if (type == 0) {
                        command = new Climate.GetState(bytes, true);
                        break;
                    }
                    if (type != 2) break;
                    command = new Climate.GetStateAvailability(bytes, true);
                }
            }
        }
        catch (Exception e) {
            AutoApiLogger.getLogger().error(String.format("Failed to parse command %s: %s", CommandResolver.commandToString(bytes), e.getMessage()));
        }
        if (command == null) {
            command = new Command(bytes);
        }
        return command;
    }

    public static Command resolveBase64(String base64) {
        return CommandResolver.resolve(Base64.decode((String)base64));
    }

    public static Command resolveHex(String hexBytes) {
        return CommandResolver.resolve(ByteUtils.bytesFromHex((String)hexBytes));
    }

    public static Command resolve(String value) {
        return CommandResolver.resolve(new Bytes(value));
    }

    private static String commandToString(byte[] bytes) {
        return ByteUtils.hexFromBytes((byte[])ByteUtils.trimmedBytes((byte[])bytes, (int)Math.min(bytes.length, 3)));
    }

    static RunTime getRuntime() {
        if (_environment == Environment.VEHICLE) {
            return RunTime.JAVA;
        }
        return RunTime.ANDROID;
    }

    public static void setRuntime(RunTime runtime) {
        _environment = runtime == RunTime.JAVA ? Environment.VEHICLE : Environment.OWNER;
    }

    static Environment getEnvironment() {
        return _environment;
    }

    public static void setEnvironment(Environment environment) {
        _environment = environment;
    }

    public static enum Environment {
        OWNER,
        VEHICLE;

    }

    protected static class SetterIterator {
        private final int currentSize;
        private String capabilityName;
        private int currentIndex = 0;
        public Command theParsedCommand;

        SetterIterator(int count, String capabilityName) {
            this.currentSize = count;
            this.capabilityName = capabilityName;
        }

        public boolean hasNext() {
            return this.currentIndex < this.currentSize && this.theParsedCommand == null;
        }

        public Command parseNext(SetterIteration next) throws CommandParseException {
            try {
                this.theParsedCommand = next.iterate(this.currentSize - this.currentIndex - 1);
            }
            catch (PropertyParseException propertyParseException) {
                // empty catch block
            }
            ++this.currentIndex;
            if (!this.hasNext() && this.theParsedCommand == null) {
                throw new CommandParseException(String.format("None of the Capability.%s setters matched the input bytes", this.capabilityName));
            }
            return this.theParsedCommand;
        }

        public static interface SetterIteration {
            public Command iterate(int var1) throws PropertyParseException, CommandParseException;
        }
    }

    @Deprecated
    public static enum RunTime {
        ANDROID,
        JAVA;

    }
}

