/*
 * Decompiled with CFR 0.152.
 */
package com.highmobility.autoapi;

import com.highmobility.autoapi.Command;
import com.highmobility.autoapi.CommandParseException;
import com.highmobility.autoapi.CommandResolver;
import com.highmobility.autoapi.GetAvailabilityCommand;
import com.highmobility.autoapi.GetCommand;
import com.highmobility.autoapi.SetCommand;
import com.highmobility.autoapi.property.ByteEnum;
import com.highmobility.autoapi.property.Property;
import com.highmobility.autoapi.property.PropertyInteger;
import com.highmobility.autoapi.value.CrashIncident;
import com.highmobility.autoapi.value.EnabledState;
import com.highmobility.value.Bytes;
import java.util.ArrayList;
import java.util.List;

public class Crash {
    public static final int IDENTIFIER = 107;
    public static final byte PROPERTY_INCIDENTS = 1;
    public static final byte PROPERTY_TYPE = 2;
    public static final byte PROPERTY_TIPPED_STATE = 3;
    public static final byte PROPERTY_AUTOMATIC_ECALL = 4;
    public static final byte PROPERTY_SEVERITY = 5;
    public static final byte PROPERTY_IMPACT_ZONE = 6;
    public static final byte PROPERTY_STATUS = 7;

    public static enum Status implements ByteEnum
    {
        NORMAL(0),
        RESTRAINTS_ENGAGED(1),
        AIRBAG_TRIGGERED(2);

        private final byte value;

        public static Status fromByte(byte byteValue) throws CommandParseException {
            Status[] values = Status.values();
            for (int i = 0; i < values.length; ++i) {
                Status state = values[i];
                if (state.getByte() != byteValue) continue;
                return state;
            }
            throw new CommandParseException(ByteEnum.enumValueDoesNotExist(Status.class.getSimpleName(), byteValue));
        }

        private Status(byte value) {
            this.value = value;
        }

        @Override
        public byte getByte() {
            return this.value;
        }
    }

    public static enum ImpactZone implements ByteEnum
    {
        PEDESTRIAN_PROTECTION(0),
        ROLLOVER(1),
        REAR_PASSENGER_SIDE(2),
        REAR_DRIVER_SIDE(3),
        SIDE_PASSENGER_SIDE(4),
        SIDE_DRIVER_SIDE(5),
        FRONT_PASSENGER_SIDE(6),
        FRONT_DRIVER_SIDE(7);

        private final byte value;

        public static ImpactZone fromByte(byte byteValue) throws CommandParseException {
            ImpactZone[] values = ImpactZone.values();
            for (int i = 0; i < values.length; ++i) {
                ImpactZone state = values[i];
                if (state.getByte() != byteValue) continue;
                return state;
            }
            throw new CommandParseException(ByteEnum.enumValueDoesNotExist(ImpactZone.class.getSimpleName(), byteValue));
        }

        private ImpactZone(byte value) {
            this.value = value;
        }

        @Override
        public byte getByte() {
            return this.value;
        }
    }

    public static enum TippedState implements ByteEnum
    {
        TIPPED_OVER(0),
        NOT_TIPPED(1);

        private final byte value;

        public static TippedState fromByte(byte byteValue) throws CommandParseException {
            TippedState[] values = TippedState.values();
            for (int i = 0; i < values.length; ++i) {
                TippedState state = values[i];
                if (state.getByte() != byteValue) continue;
                return state;
            }
            throw new CommandParseException(ByteEnum.enumValueDoesNotExist(TippedState.class.getSimpleName(), byteValue));
        }

        private TippedState(byte value) {
            this.value = value;
        }

        @Override
        public byte getByte() {
            return this.value;
        }
    }

    public static enum Type implements ByteEnum
    {
        PEDESTRIAN(0),
        NON_PEDESTRIAN(1);

        private final byte value;

        public static Type fromByte(byte byteValue) throws CommandParseException {
            Type[] values = Type.values();
            for (int i = 0; i < values.length; ++i) {
                Type state = values[i];
                if (state.getByte() != byteValue) continue;
                return state;
            }
            throw new CommandParseException(ByteEnum.enumValueDoesNotExist(Type.class.getSimpleName(), byteValue));
        }

        private Type(byte value) {
            this.value = value;
        }

        @Override
        public byte getByte() {
            return this.value;
        }
    }

    public static class State
    extends SetCommand {
        List<Property<CrashIncident>> incidents;
        Property<Type> type = new Property<Type>(Type.class, 2);
        Property<TippedState> tippedState = new Property<TippedState>(TippedState.class, 3);
        Property<EnabledState> automaticECall = new Property<EnabledState>(EnabledState.class, 4);
        PropertyInteger severity = new PropertyInteger(5, false);
        List<Property<ImpactZone>> impactZone;
        Property<Status> status = new Property<Status>(Status.class, 7);

        public List<Property<CrashIncident>> getIncidents() {
            return this.incidents;
        }

        public Property<Type> getType() {
            return this.type;
        }

        public Property<TippedState> getTippedState() {
            return this.tippedState;
        }

        public Property<EnabledState> getAutomaticECall() {
            return this.automaticECall;
        }

        public PropertyInteger getSeverity() {
            return this.severity;
        }

        public List<Property<ImpactZone>> getImpactZone() {
            return this.impactZone;
        }

        public Property<Status> getStatus() {
            return this.status;
        }

        State(byte[] bytes) {
            super(bytes);
            ArrayList<Property<CrashIncident>> incidentsBuilder = new ArrayList<Property<CrashIncident>>();
            ArrayList<Property<ImpactZone>> impactZoneBuilder = new ArrayList<Property<ImpactZone>>();
            while (this.propertyIterator.hasNext()) {
                this.propertyIterator.parseNextState(p -> {
                    switch (p.getPropertyIdentifier()) {
                        case 1: {
                            Property<CrashIncident> incident = new Property<CrashIncident>(CrashIncident.class, p);
                            incidentsBuilder.add(incident);
                            return incident;
                        }
                        case 2: {
                            return this.type.update(p);
                        }
                        case 3: {
                            return this.tippedState.update(p);
                        }
                        case 4: {
                            return this.automaticECall.update(p);
                        }
                        case 5: {
                            return this.severity.update(p);
                        }
                        case 6: {
                            Property<ImpactZone> impactZone = new Property<ImpactZone>(ImpactZone.class, p);
                            impactZoneBuilder.add(impactZone);
                            return impactZone;
                        }
                        case 7: {
                            return this.status.update(p);
                        }
                    }
                    return null;
                });
            }
            this.incidents = incidentsBuilder;
            this.impactZone = impactZoneBuilder;
        }

        public static final class Builder
        extends SetCommand.Builder<Builder> {
            public Builder() {
                super(107);
            }

            @Override
            public State build() {
                SetCommand baseSetCommand = super.build();
                Command resolved = CommandResolver.resolve(baseSetCommand.getByteArray());
                return (State)resolved;
            }

            public Builder setIncidents(Property<CrashIncident>[] incidents) {
                for (int i = 0; i < incidents.length; ++i) {
                    this.addIncident(incidents[i]);
                }
                return this;
            }

            public Builder addIncident(Property<CrashIncident> incident) {
                incident.setIdentifier((byte)1);
                this.addProperty(incident);
                return this;
            }

            public Builder setType(Property<Type> type) {
                Property<Type> property = type.setIdentifier((byte)2);
                this.addProperty(property);
                return this;
            }

            public Builder setTippedState(Property<TippedState> tippedState) {
                Property<TippedState> property = tippedState.setIdentifier((byte)3);
                this.addProperty(property);
                return this;
            }

            public Builder setAutomaticECall(Property<EnabledState> automaticECall) {
                Property<EnabledState> property = automaticECall.setIdentifier((byte)4);
                this.addProperty(property);
                return this;
            }

            public Builder setSeverity(Property<Integer> severity) {
                PropertyInteger property = new PropertyInteger(5, false, 1, severity);
                this.addProperty(property);
                return this;
            }

            public Builder setImpactZone(Property<ImpactZone>[] impactZone) {
                for (int i = 0; i < impactZone.length; ++i) {
                    this.addImpactZone(impactZone[i]);
                }
                return this;
            }

            public Builder addImpactZone(Property<ImpactZone> impactZone) {
                impactZone.setIdentifier((byte)6);
                this.addProperty(impactZone);
                return this;
            }

            public Builder setStatus(Property<Status> status) {
                Property<Status> property = status.setIdentifier((byte)7);
                this.addProperty(property);
                return this;
            }
        }
    }

    @Deprecated
    public static class GetProperties
    extends GetCommand<State> {
        public GetProperties(Bytes propertyIdentifiers) {
            super(State.class, (Integer)107, propertyIdentifiers);
        }

        public GetProperties(byte ... propertyIdentifiers) {
            super(State.class, (Integer)107, new Bytes(propertyIdentifiers));
        }

        GetProperties(byte[] bytes, boolean fromRaw) throws CommandParseException {
            super(State.class, bytes);
        }
    }

    public static class GetState
    extends GetCommand<State> {
        public GetState() {
            super(State.class, 107);
        }

        public GetState(Bytes propertyIdentifiers) {
            super(State.class, (Integer)107, propertyIdentifiers);
        }

        public GetState(byte ... propertyIdentifiers) {
            super(State.class, (Integer)107, new Bytes(propertyIdentifiers));
        }

        GetState(byte[] bytes, boolean fromRaw) throws CommandParseException {
            super(State.class, bytes);
        }
    }

    public static class GetStateAvailability
    extends GetAvailabilityCommand {
        public GetStateAvailability() {
            super(107);
        }

        public GetStateAvailability(Bytes propertyIdentifiers) {
            super(107, propertyIdentifiers);
        }

        public GetStateAvailability(byte ... propertyIdentifiers) {
            super(107, new Bytes(propertyIdentifiers));
        }

        GetStateAvailability(byte[] bytes, boolean fromRaw) throws CommandParseException {
            super(bytes);
        }
    }
}

