/*
 * Decompiled with CFR 0.152.
 */
package com.highmobility.autoapi;

import com.highmobility.autoapi.CommandParseException;
import com.highmobility.autoapi.GetAvailabilityCommand;
import com.highmobility.autoapi.GetCommand;
import com.highmobility.autoapi.PropertyParseException;
import com.highmobility.autoapi.SetCommand;
import com.highmobility.autoapi.capability.DisabledIn;
import com.highmobility.autoapi.property.ByteEnum;
import com.highmobility.autoapi.property.Property;
import com.highmobility.autoapi.value.ActiveState;
import com.highmobility.autoapi.value.measurement.Speed;
import com.highmobility.value.Bytes;
import javax.annotation.Nullable;

public class CruiseControl {
    public static final int IDENTIFIER = 98;
    public static final byte PROPERTY_CRUISE_CONTROL = 1;
    public static final byte PROPERTY_LIMITER = 2;
    public static final byte PROPERTY_TARGET_SPEED = 3;
    public static final byte PROPERTY_ADAPTIVE_CRUISE_CONTROL = 4;
    public static final byte PROPERTY_ACC_TARGET_SPEED = 5;
    public static final DisabledIn[] disabledIn = new DisabledIn[]{DisabledIn.WEB};

    public static enum Limiter implements ByteEnum
    {
        NOT_SET(0),
        HIGHER_SPEED_REQUESTED(1),
        LOWER_SPEED_REQUESTED(2),
        SPEED_FIXED(3);

        private final byte value;

        public static Limiter fromByte(byte byteValue) throws CommandParseException {
            Limiter[] values = Limiter.values();
            for (int i = 0; i < values.length; ++i) {
                Limiter state = values[i];
                if (state.getByte() != byteValue) continue;
                return state;
            }
            throw new CommandParseException(ByteEnum.enumValueDoesNotExist(Limiter.class.getSimpleName(), byteValue));
        }

        private Limiter(byte value) {
            this.value = value;
        }

        @Override
        public byte getByte() {
            return this.value;
        }
    }

    public static class State
    extends SetCommand {
        Property<ActiveState> cruiseControl = new Property<ActiveState>(ActiveState.class, 1);
        Property<Limiter> limiter = new Property<Limiter>(Limiter.class, 2);
        Property<Speed> targetSpeed = new Property<Speed>(Speed.class, 3);
        Property<ActiveState> adaptiveCruiseControl = new Property<ActiveState>(ActiveState.class, 4);
        Property<Speed> accTargetSpeed = new Property<Speed>(Speed.class, 5);

        public Property<ActiveState> getCruiseControl() {
            return this.cruiseControl;
        }

        public Property<Limiter> getLimiter() {
            return this.limiter;
        }

        public Property<Speed> getTargetSpeed() {
            return this.targetSpeed;
        }

        public Property<ActiveState> getAdaptiveCruiseControl() {
            return this.adaptiveCruiseControl;
        }

        public Property<Speed> getAccTargetSpeed() {
            return this.accTargetSpeed;
        }

        State(byte[] bytes) {
            super(bytes);
            while (this.propertyIterator.hasNext()) {
                this.propertyIterator.parseNextState(p -> {
                    switch (p.getPropertyIdentifier()) {
                        case 1: {
                            return this.cruiseControl.update(p);
                        }
                        case 2: {
                            return this.limiter.update(p);
                        }
                        case 3: {
                            return this.targetSpeed.update(p);
                        }
                        case 4: {
                            return this.adaptiveCruiseControl.update(p);
                        }
                        case 5: {
                            return this.accTargetSpeed.update(p);
                        }
                    }
                    return null;
                });
            }
        }
    }

    public static class ActivateDeactivateCruiseControl
    extends SetCommand {
        Property<ActiveState> cruiseControl = new Property<ActiveState>(ActiveState.class, 1);
        Property<Speed> targetSpeed = new Property<Speed>(Speed.class, 3);

        public Property<ActiveState> getCruiseControl() {
            return this.cruiseControl;
        }

        public Property<Speed> getTargetSpeed() {
            return this.targetSpeed;
        }

        public ActivateDeactivateCruiseControl(ActiveState cruiseControl, @Nullable Speed targetSpeed) {
            super(98);
            this.addProperty(this.cruiseControl.update(cruiseControl));
            this.addProperty(this.targetSpeed.update(targetSpeed));
            this.createBytes();
        }

        ActivateDeactivateCruiseControl(byte[] bytes) throws PropertyParseException {
            super(bytes);
            while (this.propertyIterator.hasNext()) {
                this.propertyIterator.parseNextSetter(p -> {
                    switch (p.getPropertyIdentifier()) {
                        case 1: {
                            return this.cruiseControl.update(p);
                        }
                        case 3: {
                            return this.targetSpeed.update(p);
                        }
                    }
                    return null;
                });
            }
            if (this.cruiseControl.getValue() == null) {
                throw new PropertyParseException(this.mandatoryPropertyErrorMessage(((Object)((Object)this)).getClass()));
            }
        }
    }

    @Deprecated
    public static class GetProperties
    extends GetCommand<State> {
        public GetProperties(Bytes propertyIdentifiers) {
            super(State.class, (Integer)98, propertyIdentifiers);
        }

        public GetProperties(byte ... propertyIdentifiers) {
            super(State.class, (Integer)98, new Bytes(propertyIdentifiers));
        }

        GetProperties(byte[] bytes, boolean fromRaw) throws CommandParseException {
            super(State.class, bytes);
        }
    }

    public static class GetState
    extends GetCommand<State> {
        public GetState() {
            super(State.class, 98);
        }

        public GetState(Bytes propertyIdentifiers) {
            super(State.class, (Integer)98, propertyIdentifiers);
        }

        public GetState(byte ... propertyIdentifiers) {
            super(State.class, (Integer)98, new Bytes(propertyIdentifiers));
        }

        GetState(byte[] bytes, boolean fromRaw) throws CommandParseException {
            super(State.class, bytes);
        }
    }

    public static class GetStateAvailability
    extends GetAvailabilityCommand {
        public GetStateAvailability() {
            super(98);
        }

        public GetStateAvailability(Bytes propertyIdentifiers) {
            super(98, propertyIdentifiers);
        }

        public GetStateAvailability(byte ... propertyIdentifiers) {
            super(98, new Bytes(propertyIdentifiers));
        }

        GetStateAvailability(byte[] bytes, boolean fromRaw) throws CommandParseException {
            super(bytes);
        }
    }
}

