/*
 * Decompiled with CFR 0.152.
 */
package com.highmobility.autoapi;

import com.highmobility.autoapi.Command;
import com.highmobility.autoapi.CommandParseException;
import com.highmobility.autoapi.CommandResolver;
import com.highmobility.autoapi.GetAvailabilityCommand;
import com.highmobility.autoapi.GetCommand;
import com.highmobility.autoapi.SetCommand;
import com.highmobility.autoapi.property.ByteEnum;
import com.highmobility.autoapi.property.Property;
import com.highmobility.autoapi.value.DashboardLight;
import com.highmobility.value.Bytes;
import java.util.ArrayList;
import java.util.List;

public class DashboardLights {
    public static final int IDENTIFIER = 97;
    public static final byte PROPERTY_DASHBOARD_LIGHTS = 1;
    public static final byte PROPERTY_BULB_FAILURES = 2;

    public static enum BulbFailures implements ByteEnum
    {
        TURN_SIGNAL_LEFT(0),
        TURN_SIGNAL_RIGHT(1),
        LOW_BEAM(2),
        LOW_BEAM_LEFT(3),
        LOW_BEAM_RIGHT(4),
        HIGH_BEAM(5),
        HIGH_BEAM_LEFT(6),
        HIGH_BEAM_RIGHT(7),
        FOG_LIGHT_FRONT(8),
        FOG_LIGHT_REAR(9),
        STOP(10),
        POSITION(11),
        DAY_RUNNING(12),
        TRAILER_TURN(13),
        TRAILER_TURN_LEFT(14),
        TRAILER_TURN_RIGHT(15),
        TRAILER_STOP(16),
        TRAILER_ELECTRICAL_FAILURE(17),
        MULTIPLE(18);

        private final byte value;

        public static BulbFailures fromByte(byte byteValue) throws CommandParseException {
            BulbFailures[] values = BulbFailures.values();
            for (int i = 0; i < values.length; ++i) {
                BulbFailures state = values[i];
                if (state.getByte() != byteValue) continue;
                return state;
            }
            throw new CommandParseException(ByteEnum.enumValueDoesNotExist(BulbFailures.class.getSimpleName(), byteValue));
        }

        private BulbFailures(byte value) {
            this.value = value;
        }

        @Override
        public byte getByte() {
            return this.value;
        }
    }

    public static class State
    extends SetCommand {
        List<Property<DashboardLight>> dashboardLights;
        List<Property<BulbFailures>> bulbFailures;

        public List<Property<DashboardLight>> getDashboardLights() {
            return this.dashboardLights;
        }

        public List<Property<BulbFailures>> getBulbFailures() {
            return this.bulbFailures;
        }

        State(byte[] bytes) {
            super(bytes);
            ArrayList<Property<DashboardLight>> dashboardLightsBuilder = new ArrayList<Property<DashboardLight>>();
            ArrayList<Property<BulbFailures>> bulbFailuresBuilder = new ArrayList<Property<BulbFailures>>();
            while (this.propertyIterator.hasNext()) {
                this.propertyIterator.parseNextState(p -> {
                    switch (p.getPropertyIdentifier()) {
                        case 1: {
                            Property<DashboardLight> dashboardLight = new Property<DashboardLight>(DashboardLight.class, p);
                            dashboardLightsBuilder.add(dashboardLight);
                            return dashboardLight;
                        }
                        case 2: {
                            Property<BulbFailures> bulbFailure = new Property<BulbFailures>(BulbFailures.class, p);
                            bulbFailuresBuilder.add(bulbFailure);
                            return bulbFailure;
                        }
                    }
                    return null;
                });
            }
            this.dashboardLights = dashboardLightsBuilder;
            this.bulbFailures = bulbFailuresBuilder;
        }

        public static final class Builder
        extends SetCommand.Builder<Builder> {
            public Builder() {
                super(97);
            }

            @Override
            public State build() {
                SetCommand baseSetCommand = super.build();
                Command resolved = CommandResolver.resolve(baseSetCommand.getByteArray());
                return (State)resolved;
            }

            public Builder setDashboardLights(Property<DashboardLight>[] dashboardLights) {
                for (int i = 0; i < dashboardLights.length; ++i) {
                    this.addDashboardLight(dashboardLights[i]);
                }
                return this;
            }

            public Builder addDashboardLight(Property<DashboardLight> dashboardLight) {
                dashboardLight.setIdentifier((byte)1);
                this.addProperty(dashboardLight);
                return this;
            }

            public Builder setBulbFailures(Property<BulbFailures>[] bulbFailures) {
                for (int i = 0; i < bulbFailures.length; ++i) {
                    this.addBulbFailure(bulbFailures[i]);
                }
                return this;
            }

            public Builder addBulbFailure(Property<BulbFailures> bulbFailure) {
                bulbFailure.setIdentifier((byte)2);
                this.addProperty(bulbFailure);
                return this;
            }
        }
    }

    @Deprecated
    public static class GetDashboardLightsProperties
    extends GetCommand<State> {
        public GetDashboardLightsProperties(Bytes propertyIdentifiers) {
            super(State.class, (Integer)97, propertyIdentifiers);
        }

        public GetDashboardLightsProperties(byte ... propertyIdentifiers) {
            super(State.class, (Integer)97, new Bytes(propertyIdentifiers));
        }

        GetDashboardLightsProperties(byte[] bytes, boolean fromRaw) throws CommandParseException {
            super(State.class, bytes);
        }
    }

    public static class GetDashboardLights
    extends GetCommand<State> {
        public GetDashboardLights() {
            super(State.class, 97);
        }

        public GetDashboardLights(Bytes propertyIdentifiers) {
            super(State.class, (Integer)97, propertyIdentifiers);
        }

        public GetDashboardLights(byte ... propertyIdentifiers) {
            super(State.class, (Integer)97, new Bytes(propertyIdentifiers));
        }

        GetDashboardLights(byte[] bytes, boolean fromRaw) throws CommandParseException {
            super(State.class, bytes);
        }
    }

    public static class GetDashboardLightsAvailability
    extends GetAvailabilityCommand {
        public GetDashboardLightsAvailability() {
            super(97);
        }

        public GetDashboardLightsAvailability(Bytes propertyIdentifiers) {
            super(97, propertyIdentifiers);
        }

        public GetDashboardLightsAvailability(byte ... propertyIdentifiers) {
            super(97, new Bytes(propertyIdentifiers));
        }

        GetDashboardLightsAvailability(byte[] bytes, boolean fromRaw) throws CommandParseException {
            super(bytes);
        }
    }
}

