/*
 * Decompiled with CFR 0.152.
 */
package com.highmobility.autoapi;

import com.highmobility.autoapi.Command;
import com.highmobility.autoapi.CommandParseException;
import com.highmobility.autoapi.CommandResolver;
import com.highmobility.autoapi.GetAvailabilityCommand;
import com.highmobility.autoapi.GetCommand;
import com.highmobility.autoapi.PropertyParseException;
import com.highmobility.autoapi.SetCommand;
import com.highmobility.autoapi.property.ByteEnum;
import com.highmobility.autoapi.property.Property;
import com.highmobility.autoapi.value.ActiveState;
import com.highmobility.autoapi.value.EnabledState;
import com.highmobility.autoapi.value.OnOffState;
import com.highmobility.autoapi.value.measurement.Duration;
import com.highmobility.value.Bytes;

public class Engine {
    public static final int IDENTIFIER = 105;
    public static final byte PROPERTY_STATUS = 1;
    public static final byte PROPERTY_START_STOP_STATE = 2;
    public static final byte PROPERTY_START_STOP_ENABLED = 3;
    public static final byte PROPERTY_PRECONDITIONING_ENABLED = 4;
    public static final byte PROPERTY_PRECONDITIONING_ACTIVE = 5;
    public static final byte PROPERTY_PRECONDITIONING_REMAINING_TIME = 6;
    public static final byte PROPERTY_PRECONDITIONING_ERROR = 7;
    public static final byte PROPERTY_PRECONDITIONING_STATUS = 8;
    public static final byte PROPERTY_LIMP_MODE = 9;

    public static enum PreconditioningStatus implements ByteEnum
    {
        STANDBY(0),
        HEATING(1),
        COOLING(2),
        VENTILATION(3),
        INACTIVE(4);

        private final byte value;

        public static PreconditioningStatus fromByte(byte byteValue) throws CommandParseException {
            PreconditioningStatus[] values = PreconditioningStatus.values();
            for (int i = 0; i < values.length; ++i) {
                PreconditioningStatus state = values[i];
                if (state.getByte() != byteValue) continue;
                return state;
            }
            throw new CommandParseException(ByteEnum.enumValueDoesNotExist(PreconditioningStatus.class.getSimpleName(), byteValue));
        }

        private PreconditioningStatus(byte value) {
            this.value = value;
        }

        @Override
        public byte getByte() {
            return this.value;
        }
    }

    public static enum PreconditioningError implements ByteEnum
    {
        LOW_FUEL(0),
        LOW_BATTERY(1),
        QUOTA_EXCEEDED(2),
        HEATER_FAILURE(3),
        COMPONENT_FAILURE(4),
        OPEN_OR_UNLOCKED(5),
        OK(6);

        private final byte value;

        public static PreconditioningError fromByte(byte byteValue) throws CommandParseException {
            PreconditioningError[] values = PreconditioningError.values();
            for (int i = 0; i < values.length; ++i) {
                PreconditioningError state = values[i];
                if (state.getByte() != byteValue) continue;
                return state;
            }
            throw new CommandParseException(ByteEnum.enumValueDoesNotExist(PreconditioningError.class.getSimpleName(), byteValue));
        }

        private PreconditioningError(byte value) {
            this.value = value;
        }

        @Override
        public byte getByte() {
            return this.value;
        }
    }

    public static class State
    extends SetCommand {
        Property<OnOffState> status = new Property<OnOffState>(OnOffState.class, 1);
        Property<ActiveState> startStopState = new Property<ActiveState>(ActiveState.class, 2);
        Property<EnabledState> startStopEnabled = new Property<EnabledState>(EnabledState.class, 3);
        Property<EnabledState> preconditioningEnabled = new Property<EnabledState>(EnabledState.class, 4);
        Property<ActiveState> preconditioningActive = new Property<ActiveState>(ActiveState.class, 5);
        Property<Duration> preconditioningRemainingTime = new Property<Duration>(Duration.class, 6);
        Property<PreconditioningError> preconditioningError = new Property<PreconditioningError>(PreconditioningError.class, 7);
        Property<PreconditioningStatus> preconditioningStatus = new Property<PreconditioningStatus>(PreconditioningStatus.class, 8);
        Property<ActiveState> limpMode = new Property<ActiveState>(ActiveState.class, 9);

        public Property<OnOffState> getStatus() {
            return this.status;
        }

        public Property<ActiveState> getStartStopState() {
            return this.startStopState;
        }

        public Property<EnabledState> getStartStopEnabled() {
            return this.startStopEnabled;
        }

        public Property<EnabledState> getPreconditioningEnabled() {
            return this.preconditioningEnabled;
        }

        public Property<ActiveState> getPreconditioningActive() {
            return this.preconditioningActive;
        }

        public Property<Duration> getPreconditioningRemainingTime() {
            return this.preconditioningRemainingTime;
        }

        public Property<PreconditioningError> getPreconditioningError() {
            return this.preconditioningError;
        }

        public Property<PreconditioningStatus> getPreconditioningStatus() {
            return this.preconditioningStatus;
        }

        public Property<ActiveState> getLimpMode() {
            return this.limpMode;
        }

        State(byte[] bytes) {
            super(bytes);
            while (this.propertyIterator.hasNext()) {
                this.propertyIterator.parseNextState(p -> {
                    switch (p.getPropertyIdentifier()) {
                        case 1: {
                            return this.status.update(p);
                        }
                        case 2: {
                            return this.startStopState.update(p);
                        }
                        case 3: {
                            return this.startStopEnabled.update(p);
                        }
                        case 4: {
                            return this.preconditioningEnabled.update(p);
                        }
                        case 5: {
                            return this.preconditioningActive.update(p);
                        }
                        case 6: {
                            return this.preconditioningRemainingTime.update(p);
                        }
                        case 7: {
                            return this.preconditioningError.update(p);
                        }
                        case 8: {
                            return this.preconditioningStatus.update(p);
                        }
                        case 9: {
                            return this.limpMode.update(p);
                        }
                    }
                    return null;
                });
            }
        }

        public static final class Builder
        extends SetCommand.Builder<Builder> {
            public Builder() {
                super(105);
            }

            @Override
            public State build() {
                SetCommand baseSetCommand = super.build();
                Command resolved = CommandResolver.resolve(baseSetCommand.getByteArray());
                return (State)resolved;
            }

            public Builder setStatus(Property<OnOffState> status) {
                Property<OnOffState> property = status.setIdentifier((byte)1);
                this.addProperty(property);
                return this;
            }

            public Builder setStartStopState(Property<ActiveState> startStopState) {
                Property<ActiveState> property = startStopState.setIdentifier((byte)2);
                this.addProperty(property);
                return this;
            }

            public Builder setStartStopEnabled(Property<EnabledState> startStopEnabled) {
                Property<EnabledState> property = startStopEnabled.setIdentifier((byte)3);
                this.addProperty(property);
                return this;
            }

            public Builder setPreconditioningEnabled(Property<EnabledState> preconditioningEnabled) {
                Property<EnabledState> property = preconditioningEnabled.setIdentifier((byte)4);
                this.addProperty(property);
                return this;
            }

            public Builder setPreconditioningActive(Property<ActiveState> preconditioningActive) {
                Property<ActiveState> property = preconditioningActive.setIdentifier((byte)5);
                this.addProperty(property);
                return this;
            }

            public Builder setPreconditioningRemainingTime(Property<Duration> preconditioningRemainingTime) {
                Property<Duration> property = preconditioningRemainingTime.setIdentifier((byte)6);
                this.addProperty(property);
                return this;
            }

            public Builder setPreconditioningError(Property<PreconditioningError> preconditioningError) {
                Property<PreconditioningError> property = preconditioningError.setIdentifier((byte)7);
                this.addProperty(property);
                return this;
            }

            public Builder setPreconditioningStatus(Property<PreconditioningStatus> preconditioningStatus) {
                Property<PreconditioningStatus> property = preconditioningStatus.setIdentifier((byte)8);
                this.addProperty(property);
                return this;
            }

            public Builder setLimpMode(Property<ActiveState> limpMode) {
                Property<ActiveState> property = limpMode.setIdentifier((byte)9);
                this.addProperty(property);
                return this;
            }
        }
    }

    public static class EnableDisableStartStop
    extends SetCommand {
        Property<EnabledState> startStopEnabled = new Property<EnabledState>(EnabledState.class, 3);

        public Property<EnabledState> getStartStopEnabled() {
            return this.startStopEnabled;
        }

        public EnableDisableStartStop(EnabledState startStopEnabled) {
            super(105);
            this.addProperty(this.startStopEnabled.update(startStopEnabled));
            this.createBytes();
        }

        EnableDisableStartStop(byte[] bytes) throws PropertyParseException {
            super(bytes);
            while (this.propertyIterator.hasNext()) {
                this.propertyIterator.parseNextSetter(p -> {
                    if (p.getPropertyIdentifier() == 3) {
                        return this.startStopEnabled.update(p);
                    }
                    return null;
                });
            }
            if (this.startStopEnabled.getValue() == null) {
                throw new PropertyParseException(this.mandatoryPropertyErrorMessage(((Object)((Object)this)).getClass()));
            }
        }
    }

    public static class TurnEngineOnOff
    extends SetCommand {
        Property<OnOffState> status = new Property<OnOffState>(OnOffState.class, 1);

        public Property<OnOffState> getStatus() {
            return this.status;
        }

        public TurnEngineOnOff(OnOffState status) {
            super(105);
            this.addProperty(this.status.update(status));
            this.createBytes();
        }

        TurnEngineOnOff(byte[] bytes) throws PropertyParseException {
            super(bytes);
            while (this.propertyIterator.hasNext()) {
                this.propertyIterator.parseNextSetter(p -> {
                    if (p.getPropertyIdentifier() == 1) {
                        return this.status.update(p);
                    }
                    return null;
                });
            }
            if (this.status.getValue() == null) {
                throw new PropertyParseException(this.mandatoryPropertyErrorMessage(((Object)((Object)this)).getClass()));
            }
        }
    }

    @Deprecated
    public static class GetProperties
    extends GetCommand<State> {
        public GetProperties(Bytes propertyIdentifiers) {
            super(State.class, (Integer)105, propertyIdentifiers);
        }

        public GetProperties(byte ... propertyIdentifiers) {
            super(State.class, (Integer)105, new Bytes(propertyIdentifiers));
        }

        GetProperties(byte[] bytes, boolean fromRaw) throws CommandParseException {
            super(State.class, bytes);
        }
    }

    public static class GetState
    extends GetCommand<State> {
        public GetState() {
            super(State.class, 105);
        }

        public GetState(Bytes propertyIdentifiers) {
            super(State.class, (Integer)105, propertyIdentifiers);
        }

        public GetState(byte ... propertyIdentifiers) {
            super(State.class, (Integer)105, new Bytes(propertyIdentifiers));
        }

        GetState(byte[] bytes, boolean fromRaw) throws CommandParseException {
            super(State.class, bytes);
        }
    }

    public static class GetStateAvailability
    extends GetAvailabilityCommand {
        public GetStateAvailability() {
            super(105);
        }

        public GetStateAvailability(Bytes propertyIdentifiers) {
            super(105, propertyIdentifiers);
        }

        public GetStateAvailability(byte ... propertyIdentifiers) {
            super(105, new Bytes(propertyIdentifiers));
        }

        GetStateAvailability(byte[] bytes, boolean fromRaw) throws CommandParseException {
            super(bytes);
        }
    }
}

