/*
 * Decompiled with CFR 0.152.
 */
package com.highmobility.autoapi;

import com.highmobility.autoapi.Command;
import com.highmobility.autoapi.CommandParseException;
import com.highmobility.autoapi.CommandResolver;
import com.highmobility.autoapi.SetCommand;
import com.highmobility.autoapi.property.ByteEnum;
import com.highmobility.autoapi.property.Property;
import com.highmobility.autoapi.property.PropertyInteger;
import com.highmobility.value.Bytes;

public class FailureMessage {
    public static final int IDENTIFIER = 2;
    public static final byte PROPERTY_FAILED_MESSAGE_ID = 1;
    public static final byte PROPERTY_FAILED_MESSAGE_TYPE = 2;
    public static final byte PROPERTY_FAILURE_REASON = 3;
    public static final byte PROPERTY_FAILURE_DESCRIPTION = 4;
    public static final byte PROPERTY_FAILED_PROPERTY_IDS = 5;

    public static enum FailureReason implements ByteEnum
    {
        UNSUPPORTED_CAPABILITY(0),
        UNAUTHORISED(1),
        INCORRECT_STATE(2),
        EXECUTION_TIMEOUT(3),
        VEHICLE_ASLEEP(4),
        INVALID_COMMAND(5),
        PENDING(6),
        RATE_LIMIT(7),
        OEM_ERROR(8),
        PRIVACY_MODE_ACTIVE(9);

        private final byte value;

        public static FailureReason fromByte(byte byteValue) throws CommandParseException {
            FailureReason[] values = FailureReason.values();
            for (int i = 0; i < values.length; ++i) {
                FailureReason state = values[i];
                if (state.getByte() != byteValue) continue;
                return state;
            }
            throw new CommandParseException(ByteEnum.enumValueDoesNotExist(FailureReason.class.getSimpleName(), byteValue));
        }

        private FailureReason(byte value) {
            this.value = value;
        }

        @Override
        public byte getByte() {
            return this.value;
        }
    }

    public static class State
    extends SetCommand {
        PropertyInteger failedMessageID = new PropertyInteger(1, false);
        PropertyInteger failedMessageType = new PropertyInteger(2, false);
        Property<FailureReason> failureReason = new Property<FailureReason>(FailureReason.class, 3);
        Property<String> failureDescription = new Property<String>(String.class, 4);
        Property<Bytes> failedPropertyIDs = new Property<Bytes>(Bytes.class, 5);

        public PropertyInteger getFailedMessageID() {
            return this.failedMessageID;
        }

        public PropertyInteger getFailedMessageType() {
            return this.failedMessageType;
        }

        public Property<FailureReason> getFailureReason() {
            return this.failureReason;
        }

        public Property<String> getFailureDescription() {
            return this.failureDescription;
        }

        public Property<Bytes> getFailedPropertyIDs() {
            return this.failedPropertyIDs;
        }

        public boolean getPropertyFailed(Integer capabilityIdentifier, byte propertyIdentifier) {
            if (this.getFailedMessageID().getValue() != null && this.getFailedPropertyIDs().getValue() != null && capabilityIdentifier.equals(this.getFailedMessageID().getValue())) {
                Bytes failedIds = this.getFailedPropertyIDs().getValue();
                for (Byte failedId : failedIds) {
                    if (failedId != propertyIdentifier) continue;
                    return true;
                }
            }
            return false;
        }

        public boolean getCommandFailed(Integer identifier, Integer type) {
            return identifier == this.getFailedMessageID().getValue() && type == this.getFailedMessageType().getValue();
        }

        State(byte[] bytes) {
            super(bytes);
            while (this.propertyIterator.hasNext()) {
                this.propertyIterator.parseNextState(p -> {
                    switch (p.getPropertyIdentifier()) {
                        case 1: {
                            return this.failedMessageID.update(p);
                        }
                        case 2: {
                            return this.failedMessageType.update(p);
                        }
                        case 3: {
                            return this.failureReason.update(p);
                        }
                        case 4: {
                            return this.failureDescription.update(p);
                        }
                        case 5: {
                            return this.failedPropertyIDs.update(p);
                        }
                    }
                    return null;
                });
            }
        }

        public static final class Builder
        extends SetCommand.Builder<Builder> {
            public Builder() {
                super(2);
            }

            @Override
            public State build() {
                SetCommand baseSetCommand = super.build();
                Command resolved = CommandResolver.resolve(baseSetCommand.getByteArray());
                return (State)resolved;
            }

            public Builder setFailedMessageID(Property<Integer> failedMessageID) {
                PropertyInteger property = new PropertyInteger(1, false, 2, failedMessageID);
                this.addProperty(property);
                return this;
            }

            public Builder setFailedMessageType(Property<Integer> failedMessageType) {
                PropertyInteger property = new PropertyInteger(2, false, 1, failedMessageType);
                this.addProperty(property);
                return this;
            }

            public Builder setFailureReason(Property<FailureReason> failureReason) {
                Property<FailureReason> property = failureReason.setIdentifier((byte)3);
                this.addProperty(property);
                return this;
            }

            public Builder setFailureDescription(Property<String> failureDescription) {
                Property<String> property = failureDescription.setIdentifier((byte)4);
                this.addProperty(property);
                return this;
            }

            public Builder setFailedPropertyIDs(Property<Bytes> failedPropertyIDs) {
                Property<Bytes> property = failedPropertyIDs.setIdentifier((byte)5);
                this.addProperty(property);
                return this;
            }
        }
    }
}

