/*
 * Decompiled with CFR 0.152.
 */
package com.highmobility.autoapi;

import com.highmobility.autoapi.Command;
import com.highmobility.autoapi.CommandResolver;
import com.highmobility.autoapi.PropertyParseException;
import com.highmobility.autoapi.SetCommand;
import com.highmobility.autoapi.capability.DisabledIn;
import com.highmobility.autoapi.property.Property;
import com.highmobility.autoapi.property.PropertyInteger;
import com.highmobility.value.Bytes;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import javax.annotation.Nullable;

public class Historical {
    public static final int IDENTIFIER = 18;
    public static final byte PROPERTY_STATES = 1;
    public static final byte PROPERTY_CAPABILITY_ID = 2;
    public static final byte PROPERTY_START_DATE = 3;
    public static final byte PROPERTY_END_DATE = 4;
    public static final DisabledIn[] disabledIn = new DisabledIn[]{DisabledIn.BLE};

    public static class State
    extends SetCommand {
        List<Property<Command>> states;

        public List<Property<Command>> getStates() {
            return this.states;
        }

        State(byte[] bytes) {
            super(bytes);
            ArrayList<Property<Command>> statesBuilder = new ArrayList<Property<Command>>();
            while (this.propertyIterator.hasNext()) {
                this.propertyIterator.parseNextState(p -> {
                    switch (p.getPropertyIdentifier()) {
                        case 1: {
                            Property<Command> state = new Property<Command>(Command.class, p);
                            statesBuilder.add(state);
                            return state;
                        }
                    }
                    return null;
                });
            }
            this.states = statesBuilder;
        }

        public static final class Builder
        extends SetCommand.Builder<Builder> {
            public Builder() {
                super(18);
            }

            @Override
            public State build() {
                SetCommand baseSetCommand = super.build();
                Command resolved = CommandResolver.resolve(baseSetCommand.getByteArray());
                return (State)resolved;
            }

            public Builder setStates(Property<Command>[] states) {
                for (int i = 0; i < states.length; ++i) {
                    this.addState(states[i]);
                }
                return this;
            }

            public Builder addState(Property<Command> state) {
                state.setIdentifier((byte)1);
                this.addProperty(state);
                return this;
            }
        }
    }

    public static class GetChargingSessions
    extends SetCommand {
        PropertyInteger capabilityID = new PropertyInteger(2, false);
        Property<Calendar> startDate = new Property<Calendar>(Calendar.class, 3);
        Property<Calendar> endDate = new Property<Calendar>(Calendar.class, 4);

        public Property<Calendar> getStartDate() {
            return this.startDate;
        }

        public Property<Calendar> getEndDate() {
            return this.endDate;
        }

        public GetChargingSessions(@Nullable Calendar startDate, @Nullable Calendar endDate) {
            super(18);
            this.addProperty(this.capabilityID.addValueComponent(new Bytes("006d")));
            this.addProperty(this.startDate.update(startDate));
            this.addProperty(this.endDate.update(endDate));
            this.createBytes();
        }

        GetChargingSessions(byte[] bytes) throws PropertyParseException {
            super(bytes);
            while (this.propertyIterator.hasNext()) {
                this.propertyIterator.parseNextSetter(p -> {
                    switch (p.getPropertyIdentifier()) {
                        case 2: {
                            this.capabilityID.update(p);
                        }
                        case 3: {
                            return this.startDate.update(p);
                        }
                        case 4: {
                            return this.endDate.update(p);
                        }
                    }
                    return null;
                });
            }
            if (this.capabilityID.getValue() == null || !this.capabilityID.getValueComponent().getValueBytes().equals((Object)"006d")) {
                throw new PropertyParseException(this.mandatoryPropertyErrorMessage(((Object)((Object)this)).getClass()));
            }
        }
    }

    public static class GetTrips
    extends SetCommand {
        PropertyInteger capabilityID = new PropertyInteger(2, false);
        Property<Calendar> startDate = new Property<Calendar>(Calendar.class, 3);
        Property<Calendar> endDate = new Property<Calendar>(Calendar.class, 4);

        public Property<Calendar> getStartDate() {
            return this.startDate;
        }

        public Property<Calendar> getEndDate() {
            return this.endDate;
        }

        public GetTrips(@Nullable Calendar startDate, @Nullable Calendar endDate) {
            super(18);
            this.addProperty(this.capabilityID.addValueComponent(new Bytes("006a")));
            this.addProperty(this.startDate.update(startDate));
            this.addProperty(this.endDate.update(endDate));
            this.createBytes();
        }

        GetTrips(byte[] bytes) throws PropertyParseException {
            super(bytes);
            while (this.propertyIterator.hasNext()) {
                this.propertyIterator.parseNextSetter(p -> {
                    switch (p.getPropertyIdentifier()) {
                        case 2: {
                            this.capabilityID.update(p);
                        }
                        case 3: {
                            return this.startDate.update(p);
                        }
                        case 4: {
                            return this.endDate.update(p);
                        }
                    }
                    return null;
                });
            }
            if (this.capabilityID.getValue() == null || !this.capabilityID.getValueComponent().getValueBytes().equals((Object)"006a")) {
                throw new PropertyParseException(this.mandatoryPropertyErrorMessage(((Object)((Object)this)).getClass()));
            }
        }
    }

    public static class RequestStates
    extends SetCommand {
        PropertyInteger capabilityID = new PropertyInteger(2, false);
        Property<Calendar> startDate = new Property<Calendar>(Calendar.class, 3);
        Property<Calendar> endDate = new Property<Calendar>(Calendar.class, 4);

        public PropertyInteger getCapabilityID() {
            return this.capabilityID;
        }

        public Property<Calendar> getStartDate() {
            return this.startDate;
        }

        public Property<Calendar> getEndDate() {
            return this.endDate;
        }

        public RequestStates(Integer capabilityID, @Nullable Calendar startDate, @Nullable Calendar endDate) {
            super(18);
            this.addProperty(this.capabilityID.update(false, 2, capabilityID));
            this.addProperty(this.startDate.update(startDate));
            this.addProperty(this.endDate.update(endDate));
            this.createBytes();
        }

        RequestStates(byte[] bytes) throws PropertyParseException {
            super(bytes);
            while (this.propertyIterator.hasNext()) {
                this.propertyIterator.parseNextSetter(p -> {
                    switch (p.getPropertyIdentifier()) {
                        case 2: {
                            return this.capabilityID.update(p);
                        }
                        case 3: {
                            return this.startDate.update(p);
                        }
                        case 4: {
                            return this.endDate.update(p);
                        }
                    }
                    return null;
                });
            }
            if (this.capabilityID.getValue() == null) {
                throw new PropertyParseException(this.mandatoryPropertyErrorMessage(((Object)((Object)this)).getClass()));
            }
        }
    }
}

