/*
 * Decompiled with CFR 0.152.
 */
package com.highmobility.autoapi;

import com.highmobility.autoapi.Command;
import com.highmobility.autoapi.CommandParseException;
import com.highmobility.autoapi.CommandResolver;
import com.highmobility.autoapi.GetAvailabilityCommand;
import com.highmobility.autoapi.GetCommand;
import com.highmobility.autoapi.PropertyParseException;
import com.highmobility.autoapi.SetCommand;
import com.highmobility.autoapi.property.Property;
import com.highmobility.autoapi.value.IgnitionState;
import com.highmobility.value.Bytes;

public class Ignition {
    public static final int IDENTIFIER = 53;
    public static final byte PROPERTY_STATUS = 1;
    public static final byte PROPERTY_ACCESSORIES_STATUS = 2;
    public static final byte PROPERTY_STATE = 3;

    public static class State
    extends SetCommand {
        Property<IgnitionState> status = new Property<IgnitionState>(IgnitionState.class, 1);
        Property<IgnitionState> accessoriesStatus = new Property<IgnitionState>(IgnitionState.class, 2);
        Property<IgnitionState> state = new Property<IgnitionState>(IgnitionState.class, 3);

        @Deprecated
        public Property<IgnitionState> getStatus() {
            return this.status;
        }

        @Deprecated
        public Property<IgnitionState> getAccessoriesStatus() {
            return this.accessoriesStatus;
        }

        public Property<IgnitionState> getState() {
            return this.state;
        }

        State(byte[] bytes) {
            super(bytes);
            while (this.propertyIterator.hasNext()) {
                this.propertyIterator.parseNextState(p -> {
                    switch (p.getPropertyIdentifier()) {
                        case 1: {
                            return this.status.update(p);
                        }
                        case 2: {
                            return this.accessoriesStatus.update(p);
                        }
                        case 3: {
                            return this.state.update(p);
                        }
                    }
                    return null;
                });
            }
        }

        public static final class Builder
        extends SetCommand.Builder<Builder> {
            public Builder() {
                super(53);
            }

            @Override
            public State build() {
                SetCommand baseSetCommand = super.build();
                Command resolved = CommandResolver.resolve(baseSetCommand.getByteArray());
                return (State)resolved;
            }

            @Deprecated
            public Builder setStatus(Property<IgnitionState> status) {
                Property<IgnitionState> property = status.setIdentifier((byte)1);
                this.addProperty(property);
                return this;
            }

            @Deprecated
            public Builder setAccessoriesStatus(Property<IgnitionState> accessoriesStatus) {
                Property<IgnitionState> property = accessoriesStatus.setIdentifier((byte)2);
                this.addProperty(property);
                return this;
            }

            public Builder setState(Property<IgnitionState> state) {
                Property<IgnitionState> property = state.setIdentifier((byte)3);
                this.addProperty(property);
                return this;
            }
        }
    }

    public static class TurnIgnitionOnOff
    extends SetCommand {
        Property<IgnitionState> state = new Property<IgnitionState>(IgnitionState.class, 3);

        public Property<IgnitionState> getState() {
            return this.state;
        }

        public TurnIgnitionOnOff(IgnitionState state) {
            super(53);
            this.addProperty(this.state.update(state));
            this.createBytes();
        }

        TurnIgnitionOnOff(byte[] bytes) throws PropertyParseException {
            super(bytes);
            while (this.propertyIterator.hasNext()) {
                this.propertyIterator.parseNextSetter(p -> {
                    if (p.getPropertyIdentifier() == 3) {
                        return this.state.update(p);
                    }
                    return null;
                });
            }
            if (this.state.getValue() == null) {
                throw new PropertyParseException(this.mandatoryPropertyErrorMessage(((Object)((Object)this)).getClass()));
            }
        }
    }

    @Deprecated
    public static class GetProperties
    extends GetCommand<State> {
        public GetProperties(Bytes propertyIdentifiers) {
            super(State.class, (Integer)53, propertyIdentifiers);
        }

        public GetProperties(byte ... propertyIdentifiers) {
            super(State.class, (Integer)53, new Bytes(propertyIdentifiers));
        }

        GetProperties(byte[] bytes, boolean fromRaw) throws CommandParseException {
            super(State.class, bytes);
        }
    }

    public static class GetState
    extends GetCommand<State> {
        public GetState() {
            super(State.class, 53);
        }

        public GetState(Bytes propertyIdentifiers) {
            super(State.class, (Integer)53, propertyIdentifiers);
        }

        public GetState(byte ... propertyIdentifiers) {
            super(State.class, (Integer)53, new Bytes(propertyIdentifiers));
        }

        GetState(byte[] bytes, boolean fromRaw) throws CommandParseException {
            super(State.class, bytes);
        }
    }

    public static class GetStateAvailability
    extends GetAvailabilityCommand {
        public GetStateAvailability() {
            super(53);
        }

        public GetStateAvailability(Bytes propertyIdentifiers) {
            super(53, propertyIdentifiers);
        }

        public GetStateAvailability(byte ... propertyIdentifiers) {
            super(53, new Bytes(propertyIdentifiers));
        }

        GetStateAvailability(byte[] bytes, boolean fromRaw) throws CommandParseException {
            super(bytes);
        }
    }
}

