/*
 * Decompiled with CFR 0.152.
 */
package com.highmobility.autoapi;

import com.highmobility.autoapi.CommandParseException;
import com.highmobility.autoapi.GetAvailabilityCommand;
import com.highmobility.autoapi.GetCommand;
import com.highmobility.autoapi.SetCommand;
import com.highmobility.autoapi.capability.DisabledIn;
import com.highmobility.autoapi.property.ByteEnum;
import com.highmobility.autoapi.property.Property;

public class KeyfobPosition {
    public static final int IDENTIFIER = 72;
    public static final byte PROPERTY_LOCATION = 1;
    public static final DisabledIn[] disabledIn = new DisabledIn[]{DisabledIn.WEB};

    public static enum Location implements ByteEnum
    {
        OUT_OF_RANGE(0),
        OUTSIDE_DRIVER_SIDE(1),
        OUTSIDE_IN_FRONT_OF_CAR(2),
        OUTSIDE_PASSENGER_SIDE(3),
        OUTSIDE_BEHIND_CAR(4),
        INSIDE_CAR(5),
        NOT_INSIDE(6);

        private final byte value;

        public static Location fromByte(byte byteValue) throws CommandParseException {
            Location[] values = Location.values();
            for (int i = 0; i < values.length; ++i) {
                Location state = values[i];
                if (state.getByte() != byteValue) continue;
                return state;
            }
            throw new CommandParseException(ByteEnum.enumValueDoesNotExist(Location.class.getSimpleName(), byteValue));
        }

        private Location(byte value) {
            this.value = value;
        }

        @Override
        public byte getByte() {
            return this.value;
        }
    }

    public static class State
    extends SetCommand {
        Property<Location> location = new Property<Location>(Location.class, 1);

        public Property<Location> getLocation() {
            return this.location;
        }

        State(byte[] bytes) {
            super(bytes);
            while (this.propertyIterator.hasNext()) {
                this.propertyIterator.parseNextState(p -> {
                    switch (p.getPropertyIdentifier()) {
                        case 1: {
                            return this.location.update(p);
                        }
                    }
                    return null;
                });
            }
        }
    }

    public static class GetKeyfobPosition
    extends GetCommand<State> {
        public GetKeyfobPosition() {
            super(State.class, 72);
        }

        GetKeyfobPosition(byte[] bytes, boolean fromRaw) throws CommandParseException {
            super(State.class, bytes);
        }
    }

    public static class GetKeyfobPositionAvailability
    extends GetAvailabilityCommand {
        public GetKeyfobPositionAvailability() {
            super(72);
        }

        GetKeyfobPositionAvailability(byte[] bytes, boolean fromRaw) throws CommandParseException {
            super(bytes);
        }
    }
}

