/*
 * Decompiled with CFR 0.152.
 */
package com.highmobility.autoapi;

import com.highmobility.autoapi.Command;
import com.highmobility.autoapi.CommandParseException;
import com.highmobility.autoapi.CommandResolver;
import com.highmobility.autoapi.GetAvailabilityCommand;
import com.highmobility.autoapi.GetCommand;
import com.highmobility.autoapi.PropertyParseException;
import com.highmobility.autoapi.SetCommand;
import com.highmobility.autoapi.property.ByteEnum;
import com.highmobility.autoapi.property.Property;
import com.highmobility.autoapi.value.ActiveState;
import com.highmobility.autoapi.value.Light;
import com.highmobility.autoapi.value.Location;
import com.highmobility.autoapi.value.LocationLongitudinal;
import com.highmobility.autoapi.value.ReadingLamp;
import com.highmobility.autoapi.value.RgbColour;
import com.highmobility.value.Bytes;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;

public class Lights {
    public static final int IDENTIFIER = 54;
    public static final byte PROPERTY_FRONT_EXTERIOR_LIGHT = 1;
    public static final byte PROPERTY_REAR_EXTERIOR_LIGHT = 2;
    public static final byte PROPERTY_AMBIENT_LIGHT_COLOUR = 4;
    public static final byte PROPERTY_REVERSE_LIGHT = 5;
    public static final byte PROPERTY_EMERGENCY_BRAKE_LIGHT = 6;
    public static final byte PROPERTY_FOG_LIGHTS = 7;
    public static final byte PROPERTY_READING_LAMPS = 8;
    public static final byte PROPERTY_INTERIOR_LIGHTS = 9;
    public static final byte PROPERTY_SWITCH_POSITION = 10;
    public static final byte PROPERTY_PARKING_LIGHT_STATUS = 11;

    public static enum ParkingLightStatus implements ByteEnum
    {
        OFF(0),
        LEFT(1),
        RIGHT(2),
        BOTH(3);

        private final byte value;

        public static ParkingLightStatus fromByte(byte byteValue) throws CommandParseException {
            ParkingLightStatus[] values = ParkingLightStatus.values();
            for (int i = 0; i < values.length; ++i) {
                ParkingLightStatus state = values[i];
                if (state.getByte() != byteValue) continue;
                return state;
            }
            throw new CommandParseException(ByteEnum.enumValueDoesNotExist(ParkingLightStatus.class.getSimpleName(), byteValue));
        }

        private ParkingLightStatus(byte value) {
            this.value = value;
        }

        @Override
        public byte getByte() {
            return this.value;
        }
    }

    public static enum SwitchPosition implements ByteEnum
    {
        AUTOMATIC(0),
        DIPPED_HEADLIGHTS(1),
        PARKING_LIGHT_RIGHT(2),
        PARKING_LIGHT_LEFT(3),
        SIDELIGHTS(4);

        private final byte value;

        public static SwitchPosition fromByte(byte byteValue) throws CommandParseException {
            SwitchPosition[] values = SwitchPosition.values();
            for (int i = 0; i < values.length; ++i) {
                SwitchPosition state = values[i];
                if (state.getByte() != byteValue) continue;
                return state;
            }
            throw new CommandParseException(ByteEnum.enumValueDoesNotExist(SwitchPosition.class.getSimpleName(), byteValue));
        }

        private SwitchPosition(byte value) {
            this.value = value;
        }

        @Override
        public byte getByte() {
            return this.value;
        }
    }

    public static enum FrontExteriorLight implements ByteEnum
    {
        INACTIVE(0),
        ACTIVE(1),
        ACTIVE_WITH_FULL_BEAM(2),
        DRL(3),
        AUTOMATIC(4);

        private final byte value;

        public static FrontExteriorLight fromByte(byte byteValue) throws CommandParseException {
            FrontExteriorLight[] values = FrontExteriorLight.values();
            for (int i = 0; i < values.length; ++i) {
                FrontExteriorLight state = values[i];
                if (state.getByte() != byteValue) continue;
                return state;
            }
            throw new CommandParseException(ByteEnum.enumValueDoesNotExist(FrontExteriorLight.class.getSimpleName(), byteValue));
        }

        private FrontExteriorLight(byte value) {
            this.value = value;
        }

        @Override
        public byte getByte() {
            return this.value;
        }
    }

    public static class State
    extends SetCommand {
        Property<FrontExteriorLight> frontExteriorLight = new Property<FrontExteriorLight>(FrontExteriorLight.class, 1);
        Property<ActiveState> rearExteriorLight = new Property<ActiveState>(ActiveState.class, 2);
        Property<RgbColour> ambientLightColour = new Property<RgbColour>(RgbColour.class, 4);
        Property<ActiveState> reverseLight = new Property<ActiveState>(ActiveState.class, 5);
        Property<ActiveState> emergencyBrakeLight = new Property<ActiveState>(ActiveState.class, 6);
        List<Property<Light>> fogLights;
        List<Property<ReadingLamp>> readingLamps;
        List<Property<Light>> interiorLights;
        Property<SwitchPosition> switchPosition = new Property<SwitchPosition>(SwitchPosition.class, 10);
        Property<ParkingLightStatus> parkingLightStatus = new Property<ParkingLightStatus>(ParkingLightStatus.class, 11);

        public Property<FrontExteriorLight> getFrontExteriorLight() {
            return this.frontExteriorLight;
        }

        public Property<ActiveState> getRearExteriorLight() {
            return this.rearExteriorLight;
        }

        public Property<RgbColour> getAmbientLightColour() {
            return this.ambientLightColour;
        }

        public Property<ActiveState> getReverseLight() {
            return this.reverseLight;
        }

        public Property<ActiveState> getEmergencyBrakeLight() {
            return this.emergencyBrakeLight;
        }

        public List<Property<Light>> getFogLights() {
            return this.fogLights;
        }

        public List<Property<ReadingLamp>> getReadingLamps() {
            return this.readingLamps;
        }

        public List<Property<Light>> getInteriorLights() {
            return this.interiorLights;
        }

        public Property<SwitchPosition> getSwitchPosition() {
            return this.switchPosition;
        }

        public Property<ParkingLightStatus> getParkingLightStatus() {
            return this.parkingLightStatus;
        }

        @Nullable
        public Property<Light> getInteriorLight(LocationLongitudinal location) {
            for (Property<Light> interiorLight : this.interiorLights) {
                if (interiorLight.getValue() == null || interiorLight.getValue().getLocation() != location) continue;
                return interiorLight;
            }
            return null;
        }

        @Nullable
        public Property<ReadingLamp> getReadingLamp(Location location) {
            for (Property<ReadingLamp> readingLamp : this.readingLamps) {
                if (readingLamp.getValue() == null || readingLamp.getValue().getLocation() != location) continue;
                return readingLamp;
            }
            return null;
        }

        @Nullable
        public Property<Light> getFogLight(LocationLongitudinal location) {
            for (Property<Light> fogLight : this.fogLights) {
                if (fogLight.getValue() == null || fogLight.getValue().getLocation() != location) continue;
                return fogLight;
            }
            return null;
        }

        State(byte[] bytes) {
            super(bytes);
            ArrayList<Property<Light>> fogLightsBuilder = new ArrayList<Property<Light>>();
            ArrayList<Property<ReadingLamp>> readingLampsBuilder = new ArrayList<Property<ReadingLamp>>();
            ArrayList<Property<Light>> interiorLightsBuilder = new ArrayList<Property<Light>>();
            while (this.propertyIterator.hasNext()) {
                this.propertyIterator.parseNextState(p -> {
                    switch (p.getPropertyIdentifier()) {
                        case 1: {
                            return this.frontExteriorLight.update(p);
                        }
                        case 2: {
                            return this.rearExteriorLight.update(p);
                        }
                        case 4: {
                            return this.ambientLightColour.update(p);
                        }
                        case 5: {
                            return this.reverseLight.update(p);
                        }
                        case 6: {
                            return this.emergencyBrakeLight.update(p);
                        }
                        case 7: {
                            Property<Light> fogLight = new Property<Light>(Light.class, p);
                            fogLightsBuilder.add(fogLight);
                            return fogLight;
                        }
                        case 8: {
                            Property<ReadingLamp> readingLamp = new Property<ReadingLamp>(ReadingLamp.class, p);
                            readingLampsBuilder.add(readingLamp);
                            return readingLamp;
                        }
                        case 9: {
                            Property<Light> interiorLight = new Property<Light>(Light.class, p);
                            interiorLightsBuilder.add(interiorLight);
                            return interiorLight;
                        }
                        case 10: {
                            return this.switchPosition.update(p);
                        }
                        case 11: {
                            return this.parkingLightStatus.update(p);
                        }
                    }
                    return null;
                });
            }
            this.fogLights = fogLightsBuilder;
            this.readingLamps = readingLampsBuilder;
            this.interiorLights = interiorLightsBuilder;
        }

        public static final class Builder
        extends SetCommand.Builder<Builder> {
            public Builder() {
                super(54);
            }

            @Override
            public State build() {
                SetCommand baseSetCommand = super.build();
                Command resolved = CommandResolver.resolve(baseSetCommand.getByteArray());
                return (State)resolved;
            }

            public Builder setFrontExteriorLight(Property<FrontExteriorLight> frontExteriorLight) {
                Property<FrontExteriorLight> property = frontExteriorLight.setIdentifier((byte)1);
                this.addProperty(property);
                return this;
            }

            public Builder setRearExteriorLight(Property<ActiveState> rearExteriorLight) {
                Property<ActiveState> property = rearExteriorLight.setIdentifier((byte)2);
                this.addProperty(property);
                return this;
            }

            public Builder setAmbientLightColour(Property<RgbColour> ambientLightColour) {
                Property<RgbColour> property = ambientLightColour.setIdentifier((byte)4);
                this.addProperty(property);
                return this;
            }

            public Builder setReverseLight(Property<ActiveState> reverseLight) {
                Property<ActiveState> property = reverseLight.setIdentifier((byte)5);
                this.addProperty(property);
                return this;
            }

            public Builder setEmergencyBrakeLight(Property<ActiveState> emergencyBrakeLight) {
                Property<ActiveState> property = emergencyBrakeLight.setIdentifier((byte)6);
                this.addProperty(property);
                return this;
            }

            public Builder setFogLights(Property<Light>[] fogLights) {
                for (int i = 0; i < fogLights.length; ++i) {
                    this.addFogLight(fogLights[i]);
                }
                return this;
            }

            public Builder addFogLight(Property<Light> fogLight) {
                fogLight.setIdentifier((byte)7);
                this.addProperty(fogLight);
                return this;
            }

            public Builder setReadingLamps(Property<ReadingLamp>[] readingLamps) {
                for (int i = 0; i < readingLamps.length; ++i) {
                    this.addReadingLamp(readingLamps[i]);
                }
                return this;
            }

            public Builder addReadingLamp(Property<ReadingLamp> readingLamp) {
                readingLamp.setIdentifier((byte)8);
                this.addProperty(readingLamp);
                return this;
            }

            public Builder setInteriorLights(Property<Light>[] interiorLights) {
                for (int i = 0; i < interiorLights.length; ++i) {
                    this.addInteriorLight(interiorLights[i]);
                }
                return this;
            }

            public Builder addInteriorLight(Property<Light> interiorLight) {
                interiorLight.setIdentifier((byte)9);
                this.addProperty(interiorLight);
                return this;
            }

            public Builder setSwitchPosition(Property<SwitchPosition> switchPosition) {
                Property<SwitchPosition> property = switchPosition.setIdentifier((byte)10);
                this.addProperty(property);
                return this;
            }

            public Builder setParkingLightStatus(Property<ParkingLightStatus> parkingLightStatus) {
                Property<ParkingLightStatus> property = parkingLightStatus.setIdentifier((byte)11);
                this.addProperty(property);
                return this;
            }
        }
    }

    public static class ControlLights
    extends SetCommand {
        Property<FrontExteriorLight> frontExteriorLight = new Property<FrontExteriorLight>(FrontExteriorLight.class, 1);
        Property<ActiveState> rearExteriorLight = new Property<ActiveState>(ActiveState.class, 2);
        Property<RgbColour> ambientLightColour = new Property<RgbColour>(RgbColour.class, 4);
        List<Property<Light>> fogLights;
        List<Property<ReadingLamp>> readingLamps;
        List<Property<Light>> interiorLights;

        public Property<FrontExteriorLight> getFrontExteriorLight() {
            return this.frontExteriorLight;
        }

        public Property<ActiveState> getRearExteriorLight() {
            return this.rearExteriorLight;
        }

        public Property<RgbColour> getAmbientLightColour() {
            return this.ambientLightColour;
        }

        public List<Property<Light>> getFogLights() {
            return this.fogLights;
        }

        public List<Property<ReadingLamp>> getReadingLamps() {
            return this.readingLamps;
        }

        public List<Property<Light>> getInteriorLights() {
            return this.interiorLights;
        }

        public ControlLights(@Nullable FrontExteriorLight frontExteriorLight, @Nullable ActiveState rearExteriorLight, @Nullable RgbColour ambientLightColour, @Nullable List<Light> fogLights, @Nullable List<ReadingLamp> readingLamps, @Nullable List<Light> interiorLights) {
            super(54);
            this.addProperty(this.frontExteriorLight.update(frontExteriorLight));
            this.addProperty(this.rearExteriorLight.update(rearExteriorLight));
            this.addProperty(this.ambientLightColour.update(ambientLightColour));
            ArrayList<Property<Light>> fogLightsBuilder = new ArrayList<Property<Light>>();
            if (fogLights != null) {
                for (Light light : fogLights) {
                    Property<Light> prop = new Property<Light>(7, light);
                    fogLightsBuilder.add(prop);
                    this.addProperty(prop);
                }
            }
            this.fogLights = fogLightsBuilder;
            ArrayList<Property<ReadingLamp>> readingLampsBuilder = new ArrayList<Property<ReadingLamp>>();
            if (readingLamps != null) {
                for (ReadingLamp readingLamp : readingLamps) {
                    Property<ReadingLamp> prop = new Property<ReadingLamp>(8, readingLamp);
                    readingLampsBuilder.add(prop);
                    this.addProperty(prop);
                }
            }
            this.readingLamps = readingLampsBuilder;
            ArrayList<Property<Light>> arrayList = new ArrayList<Property<Light>>();
            if (interiorLights != null) {
                for (Light interiorLight : interiorLights) {
                    Property<Light> prop = new Property<Light>(9, interiorLight);
                    arrayList.add(prop);
                    this.addProperty(prop);
                }
            }
            this.interiorLights = arrayList;
            if (this.frontExteriorLight.getValue() == null && this.rearExteriorLight.getValue() == null && this.ambientLightColour.getValue() == null && this.fogLights.size() == 0 && this.readingLamps.size() == 0 && this.interiorLights.size() == 0) {
                throw new IllegalArgumentException();
            }
            this.createBytes();
        }

        ControlLights(byte[] bytes) throws PropertyParseException {
            super(bytes);
            ArrayList<Property<Light>> fogLightsBuilder = new ArrayList<Property<Light>>();
            ArrayList<Property<ReadingLamp>> readingLampsBuilder = new ArrayList<Property<ReadingLamp>>();
            ArrayList<Property<Light>> interiorLightsBuilder = new ArrayList<Property<Light>>();
            while (this.propertyIterator.hasNext()) {
                this.propertyIterator.parseNextSetter(p -> {
                    switch (p.getPropertyIdentifier()) {
                        case 1: {
                            return this.frontExteriorLight.update(p);
                        }
                        case 2: {
                            return this.rearExteriorLight.update(p);
                        }
                        case 4: {
                            return this.ambientLightColour.update(p);
                        }
                        case 7: {
                            Property<Light> fogLight = new Property<Light>(Light.class, p);
                            fogLightsBuilder.add(fogLight);
                            return fogLight;
                        }
                        case 8: {
                            Property<ReadingLamp> readingLamp = new Property<ReadingLamp>(ReadingLamp.class, p);
                            readingLampsBuilder.add(readingLamp);
                            return readingLamp;
                        }
                        case 9: {
                            Property<Light> interiorLight = new Property<Light>(Light.class, p);
                            interiorLightsBuilder.add(interiorLight);
                            return interiorLight;
                        }
                    }
                    return null;
                });
            }
            this.fogLights = fogLightsBuilder;
            this.readingLamps = readingLampsBuilder;
            this.interiorLights = interiorLightsBuilder;
            if (this.frontExteriorLight.getValue() == null && this.rearExteriorLight.getValue() == null && this.ambientLightColour.getValue() == null && this.fogLights.size() == 0 && this.readingLamps.size() == 0 && this.interiorLights.size() == 0) {
                throw new PropertyParseException(this.optionalPropertyErrorMessage(((Object)((Object)this)).getClass()));
            }
        }
    }

    @Deprecated
    public static class GetProperties
    extends GetCommand<State> {
        public GetProperties(Bytes propertyIdentifiers) {
            super(State.class, (Integer)54, propertyIdentifiers);
        }

        public GetProperties(byte ... propertyIdentifiers) {
            super(State.class, (Integer)54, new Bytes(propertyIdentifiers));
        }

        GetProperties(byte[] bytes, boolean fromRaw) throws CommandParseException {
            super(State.class, bytes);
        }
    }

    public static class GetState
    extends GetCommand<State> {
        public GetState() {
            super(State.class, 54);
        }

        public GetState(Bytes propertyIdentifiers) {
            super(State.class, (Integer)54, propertyIdentifiers);
        }

        public GetState(byte ... propertyIdentifiers) {
            super(State.class, (Integer)54, new Bytes(propertyIdentifiers));
        }

        GetState(byte[] bytes, boolean fromRaw) throws CommandParseException {
            super(State.class, bytes);
        }
    }

    public static class GetStateAvailability
    extends GetAvailabilityCommand {
        public GetStateAvailability() {
            super(54);
        }

        public GetStateAvailability(Bytes propertyIdentifiers) {
            super(54, propertyIdentifiers);
        }

        public GetStateAvailability(byte ... propertyIdentifiers) {
            super(54, new Bytes(propertyIdentifiers));
        }

        GetStateAvailability(byte[] bytes, boolean fromRaw) throws CommandParseException {
            super(bytes);
        }
    }
}

