/*
 * Decompiled with CFR 0.152.
 */
package com.highmobility.autoapi;

import com.highmobility.autoapi.Command;
import com.highmobility.autoapi.CommandResolver;
import com.highmobility.autoapi.PropertyParseException;
import com.highmobility.autoapi.SetCommand;
import com.highmobility.autoapi.property.Property;
import javax.annotation.Nullable;

public class Messaging {
    public static final int IDENTIFIER = 55;
    public static final byte PROPERTY_TEXT = 1;
    public static final byte PROPERTY_HANDLE = 2;

    public static class State
    extends SetCommand {
        Property<String> text = new Property<String>(String.class, 1);
        Property<String> handle = new Property<String>(String.class, 2);

        public Property<String> getText() {
            return this.text;
        }

        public Property<String> getHandle() {
            return this.handle;
        }

        State(byte[] bytes) {
            super(bytes);
            while (this.propertyIterator.hasNext()) {
                this.propertyIterator.parseNextState(p -> {
                    switch (p.getPropertyIdentifier()) {
                        case 1: {
                            return this.text.update(p);
                        }
                        case 2: {
                            return this.handle.update(p);
                        }
                    }
                    return null;
                });
            }
        }

        public static final class Builder
        extends SetCommand.Builder<Builder> {
            public Builder() {
                super(55);
            }

            @Override
            public State build() {
                SetCommand baseSetCommand = super.build();
                Command resolved = CommandResolver.resolve(baseSetCommand.getByteArray());
                return (State)resolved;
            }

            public Builder setText(Property<String> text) {
                Property<String> property = text.setIdentifier((byte)1);
                this.addProperty(property);
                return this;
            }

            public Builder setHandle(Property<String> handle) {
                Property<String> property = handle.setIdentifier((byte)2);
                this.addProperty(property);
                return this;
            }
        }
    }

    public static class MessageReceived
    extends SetCommand {
        Property<String> text = new Property<String>(String.class, 1);
        Property<String> handle = new Property<String>(String.class, 2);

        public Property<String> getText() {
            return this.text;
        }

        public Property<String> getHandle() {
            return this.handle;
        }

        public MessageReceived(String text, @Nullable String handle) {
            super(55);
            this.addProperty(this.text.update(text));
            this.addProperty(this.handle.update(handle));
            this.createBytes();
        }

        MessageReceived(byte[] bytes) throws PropertyParseException {
            super(bytes);
            while (this.propertyIterator.hasNext()) {
                this.propertyIterator.parseNextSetter(p -> {
                    switch (p.getPropertyIdentifier()) {
                        case 1: {
                            return this.text.update(p);
                        }
                        case 2: {
                            return this.handle.update(p);
                        }
                    }
                    return null;
                });
            }
            if (this.text.getValue() == null) {
                throw new PropertyParseException(this.mandatoryPropertyErrorMessage(((Object)((Object)this)).getClass()));
            }
        }
    }
}

