/*
 * Decompiled with CFR 0.152.
 */
package com.highmobility.autoapi;

import com.highmobility.autoapi.Command;
import com.highmobility.autoapi.CommandParseException;
import com.highmobility.autoapi.CommandResolver;
import com.highmobility.autoapi.GetAvailabilityCommand;
import com.highmobility.autoapi.GetCommand;
import com.highmobility.autoapi.PropertyParseException;
import com.highmobility.autoapi.SetCommand;
import com.highmobility.autoapi.property.Property;
import com.highmobility.autoapi.property.PropertyInteger;
import com.highmobility.autoapi.value.Coordinates;
import com.highmobility.autoapi.value.measurement.Duration;
import com.highmobility.autoapi.value.measurement.Length;
import com.highmobility.value.Bytes;
import javax.annotation.Nullable;

public class NaviDestination {
    public static final int IDENTIFIER = 49;
    public static final byte PROPERTY_COORDINATES = 1;
    public static final byte PROPERTY_DESTINATION_NAME = 2;
    public static final byte PROPERTY_DATA_SLOTS_FREE = 3;
    public static final byte PROPERTY_DATA_SLOTS_MAX = 4;
    public static final byte PROPERTY_ARRIVAL_DURATION = 5;
    public static final byte PROPERTY_DISTANCE_TO_DESTINATION = 6;

    public static class State
    extends SetCommand {
        Property<Coordinates> coordinates = new Property<Coordinates>(Coordinates.class, 1);
        Property<String> destinationName = new Property<String>(String.class, 2);
        PropertyInteger dataSlotsFree = new PropertyInteger(3, false);
        PropertyInteger dataSlotsMax = new PropertyInteger(4, false);
        Property<Duration> arrivalDuration = new Property<Duration>(Duration.class, 5);
        Property<Length> distanceToDestination = new Property<Length>(Length.class, 6);

        public Property<Coordinates> getCoordinates() {
            return this.coordinates;
        }

        public Property<String> getDestinationName() {
            return this.destinationName;
        }

        public PropertyInteger getDataSlotsFree() {
            return this.dataSlotsFree;
        }

        public PropertyInteger getDataSlotsMax() {
            return this.dataSlotsMax;
        }

        public Property<Duration> getArrivalDuration() {
            return this.arrivalDuration;
        }

        public Property<Length> getDistanceToDestination() {
            return this.distanceToDestination;
        }

        State(byte[] bytes) {
            super(bytes);
            while (this.propertyIterator.hasNext()) {
                this.propertyIterator.parseNextState(p -> {
                    switch (p.getPropertyIdentifier()) {
                        case 1: {
                            return this.coordinates.update(p);
                        }
                        case 2: {
                            return this.destinationName.update(p);
                        }
                        case 3: {
                            return this.dataSlotsFree.update(p);
                        }
                        case 4: {
                            return this.dataSlotsMax.update(p);
                        }
                        case 5: {
                            return this.arrivalDuration.update(p);
                        }
                        case 6: {
                            return this.distanceToDestination.update(p);
                        }
                    }
                    return null;
                });
            }
        }

        public static final class Builder
        extends SetCommand.Builder<Builder> {
            public Builder() {
                super(49);
            }

            @Override
            public State build() {
                SetCommand baseSetCommand = super.build();
                Command resolved = CommandResolver.resolve(baseSetCommand.getByteArray());
                return (State)resolved;
            }

            public Builder setCoordinates(Property<Coordinates> coordinates) {
                Property<Coordinates> property = coordinates.setIdentifier((byte)1);
                this.addProperty(property);
                return this;
            }

            public Builder setDestinationName(Property<String> destinationName) {
                Property<String> property = destinationName.setIdentifier((byte)2);
                this.addProperty(property);
                return this;
            }

            public Builder setDataSlotsFree(Property<Integer> dataSlotsFree) {
                PropertyInteger property = new PropertyInteger(3, false, 1, dataSlotsFree);
                this.addProperty(property);
                return this;
            }

            public Builder setDataSlotsMax(Property<Integer> dataSlotsMax) {
                PropertyInteger property = new PropertyInteger(4, false, 1, dataSlotsMax);
                this.addProperty(property);
                return this;
            }

            public Builder setArrivalDuration(Property<Duration> arrivalDuration) {
                Property<Duration> property = arrivalDuration.setIdentifier((byte)5);
                this.addProperty(property);
                return this;
            }

            public Builder setDistanceToDestination(Property<Length> distanceToDestination) {
                Property<Length> property = distanceToDestination.setIdentifier((byte)6);
                this.addProperty(property);
                return this;
            }
        }
    }

    public static class SetNaviDestination
    extends SetCommand {
        Property<Coordinates> coordinates = new Property<Coordinates>(Coordinates.class, 1);
        Property<String> destinationName = new Property<String>(String.class, 2);

        public Property<Coordinates> getCoordinates() {
            return this.coordinates;
        }

        public Property<String> getDestinationName() {
            return this.destinationName;
        }

        public SetNaviDestination(Coordinates coordinates, @Nullable String destinationName) {
            super(49);
            this.addProperty(this.coordinates.update(coordinates));
            this.addProperty(this.destinationName.update(destinationName));
            this.createBytes();
        }

        SetNaviDestination(byte[] bytes) throws PropertyParseException {
            super(bytes);
            while (this.propertyIterator.hasNext()) {
                this.propertyIterator.parseNextSetter(p -> {
                    switch (p.getPropertyIdentifier()) {
                        case 1: {
                            return this.coordinates.update(p);
                        }
                        case 2: {
                            return this.destinationName.update(p);
                        }
                    }
                    return null;
                });
            }
            if (this.coordinates.getValue() == null) {
                throw new PropertyParseException(this.mandatoryPropertyErrorMessage(((Object)((Object)this)).getClass()));
            }
        }
    }

    @Deprecated
    public static class GetNaviDestinationProperties
    extends GetCommand<State> {
        public GetNaviDestinationProperties(Bytes propertyIdentifiers) {
            super(State.class, (Integer)49, propertyIdentifiers);
        }

        public GetNaviDestinationProperties(byte ... propertyIdentifiers) {
            super(State.class, (Integer)49, new Bytes(propertyIdentifiers));
        }

        GetNaviDestinationProperties(byte[] bytes, boolean fromRaw) throws CommandParseException {
            super(State.class, bytes);
        }
    }

    public static class GetNaviDestination
    extends GetCommand<State> {
        public GetNaviDestination() {
            super(State.class, 49);
        }

        public GetNaviDestination(Bytes propertyIdentifiers) {
            super(State.class, (Integer)49, propertyIdentifiers);
        }

        public GetNaviDestination(byte ... propertyIdentifiers) {
            super(State.class, (Integer)49, new Bytes(propertyIdentifiers));
        }

        GetNaviDestination(byte[] bytes, boolean fromRaw) throws CommandParseException {
            super(State.class, bytes);
        }
    }

    public static class GetNaviDestinationAvailability
    extends GetAvailabilityCommand {
        public GetNaviDestinationAvailability() {
            super(49);
        }

        public GetNaviDestinationAvailability(Bytes propertyIdentifiers) {
            super(49, propertyIdentifiers);
        }

        public GetNaviDestinationAvailability(byte ... propertyIdentifiers) {
            super(49, new Bytes(propertyIdentifiers));
        }

        GetNaviDestinationAvailability(byte[] bytes, boolean fromRaw) throws CommandParseException {
            super(bytes);
        }
    }
}

