/*
 * Decompiled with CFR 0.152.
 */
package com.highmobility.autoapi;

import com.highmobility.autoapi.Command;
import com.highmobility.autoapi.CommandParseException;
import com.highmobility.autoapi.CommandResolver;
import com.highmobility.autoapi.PropertyParseException;
import com.highmobility.autoapi.SetCommand;
import com.highmobility.autoapi.property.ByteEnum;
import com.highmobility.autoapi.property.Property;
import com.highmobility.autoapi.property.PropertyInteger;
import com.highmobility.autoapi.value.ActionItem;
import com.highmobility.value.Bytes;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;

public class Notifications {
    public static final int IDENTIFIER = 56;
    public static final byte PROPERTY_TEXT = 1;
    public static final byte PROPERTY_ACTION_ITEMS = 2;
    public static final byte PROPERTY_ACTIVATED_ACTION = 3;
    public static final byte PROPERTY_CLEAR = 4;

    public static enum Clear implements ByteEnum
    {
        CLEAR(0);

        private final byte value;

        public static Clear fromByte(byte byteValue) throws CommandParseException {
            Clear[] values = Clear.values();
            for (int i = 0; i < values.length; ++i) {
                Clear state = values[i];
                if (state.getByte() != byteValue) continue;
                return state;
            }
            throw new CommandParseException(ByteEnum.enumValueDoesNotExist(Clear.class.getSimpleName(), byteValue));
        }

        private Clear(byte value) {
            this.value = value;
        }

        @Override
        public byte getByte() {
            return this.value;
        }
    }

    public static class State
    extends SetCommand {
        Property<String> text = new Property<String>(String.class, 1);
        List<Property<ActionItem>> actionItems;
        PropertyInteger activatedAction = new PropertyInteger(3, false);
        Property<Clear> clear = new Property<Clear>(Clear.class, 4);

        public Property<String> getText() {
            return this.text;
        }

        public List<Property<ActionItem>> getActionItems() {
            return this.actionItems;
        }

        public PropertyInteger getActivatedAction() {
            return this.activatedAction;
        }

        public Property<Clear> getClear() {
            return this.clear;
        }

        State(byte[] bytes) {
            super(bytes);
            ArrayList<Property<ActionItem>> actionItemsBuilder = new ArrayList<Property<ActionItem>>();
            while (this.propertyIterator.hasNext()) {
                this.propertyIterator.parseNextState(p -> {
                    switch (p.getPropertyIdentifier()) {
                        case 1: {
                            return this.text.update(p);
                        }
                        case 2: {
                            Property<ActionItem> actionItem = new Property<ActionItem>(ActionItem.class, p);
                            actionItemsBuilder.add(actionItem);
                            return actionItem;
                        }
                        case 3: {
                            return this.activatedAction.update(p);
                        }
                        case 4: {
                            return this.clear.update(p);
                        }
                    }
                    return null;
                });
            }
            this.actionItems = actionItemsBuilder;
        }

        public static final class Builder
        extends SetCommand.Builder<Builder> {
            public Builder() {
                super(56);
            }

            @Override
            public State build() {
                SetCommand baseSetCommand = super.build();
                Command resolved = CommandResolver.resolve(baseSetCommand.getByteArray());
                return (State)resolved;
            }

            public Builder setText(Property<String> text) {
                Property<String> property = text.setIdentifier((byte)1);
                this.addProperty(property);
                return this;
            }

            public Builder setActionItems(Property<ActionItem>[] actionItems) {
                for (int i = 0; i < actionItems.length; ++i) {
                    this.addActionItem(actionItems[i]);
                }
                return this;
            }

            public Builder addActionItem(Property<ActionItem> actionItem) {
                actionItem.setIdentifier((byte)2);
                this.addProperty(actionItem);
                return this;
            }

            public Builder setActivatedAction(Property<Integer> activatedAction) {
                PropertyInteger property = new PropertyInteger(3, false, 1, activatedAction);
                this.addProperty(property);
                return this;
            }

            public Builder setClear(Property<Clear> clear) {
                Property<Clear> property = clear.setIdentifier((byte)4);
                this.addProperty(property);
                return this;
            }
        }
    }

    public static class ClearNotification
    extends SetCommand {
        Property<Clear> clear = new Property<Clear>(Clear.class, 4);

        public ClearNotification() {
            super(56);
            this.addProperty(this.clear.addValueComponent(new Bytes("00")));
            this.createBytes();
        }

        ClearNotification(byte[] bytes) throws PropertyParseException {
            super(bytes);
            while (this.propertyIterator.hasNext()) {
                this.propertyIterator.parseNextSetter(p -> {
                    if (p.getPropertyIdentifier() == 4) {
                        return this.clear.update(p);
                    }
                    return null;
                });
            }
            if (this.clear.getValue() == null || !this.clear.getValueComponent().getValueBytes().equals((Object)"00")) {
                throw new PropertyParseException(this.mandatoryPropertyErrorMessage(((Object)((Object)this)).getClass()));
            }
        }
    }

    public static class Action
    extends SetCommand {
        PropertyInteger activatedAction = new PropertyInteger(3, false);

        public PropertyInteger getActivatedAction() {
            return this.activatedAction;
        }

        public Action(Integer activatedAction) {
            super(56);
            this.addProperty(this.activatedAction.update(false, 1, activatedAction));
            this.createBytes();
        }

        Action(byte[] bytes) throws PropertyParseException {
            super(bytes);
            while (this.propertyIterator.hasNext()) {
                this.propertyIterator.parseNextSetter(p -> {
                    if (p.getPropertyIdentifier() == 3) {
                        return this.activatedAction.update(p);
                    }
                    return null;
                });
            }
            if (this.activatedAction.getValue() == null) {
                throw new PropertyParseException(this.mandatoryPropertyErrorMessage(((Object)((Object)this)).getClass()));
            }
        }
    }

    public static class Notification
    extends SetCommand {
        Property<String> text = new Property<String>(String.class, 1);
        List<Property<ActionItem>> actionItems;

        public Property<String> getText() {
            return this.text;
        }

        public List<Property<ActionItem>> getActionItems() {
            return this.actionItems;
        }

        public Notification(String text, @Nullable List<ActionItem> actionItems) {
            super(56);
            this.addProperty(this.text.update(text));
            ArrayList<Property<ActionItem>> actionItemsBuilder = new ArrayList<Property<ActionItem>>();
            if (actionItems != null) {
                for (ActionItem actionItem : actionItems) {
                    Property<ActionItem> prop = new Property<ActionItem>(2, actionItem);
                    actionItemsBuilder.add(prop);
                    this.addProperty(prop);
                }
            }
            this.actionItems = actionItemsBuilder;
            this.createBytes();
        }

        Notification(byte[] bytes) throws PropertyParseException {
            super(bytes);
            ArrayList<Property<ActionItem>> actionItemsBuilder = new ArrayList<Property<ActionItem>>();
            while (this.propertyIterator.hasNext()) {
                this.propertyIterator.parseNextSetter(p -> {
                    switch (p.getPropertyIdentifier()) {
                        case 1: {
                            return this.text.update(p);
                        }
                        case 2: {
                            Property<ActionItem> actionItem = new Property<ActionItem>(ActionItem.class, p);
                            actionItemsBuilder.add(actionItem);
                            return actionItem;
                        }
                    }
                    return null;
                });
            }
            this.actionItems = actionItemsBuilder;
            if (this.text.getValue() == null) {
                throw new PropertyParseException(this.mandatoryPropertyErrorMessage(((Object)((Object)this)).getClass()));
            }
        }
    }
}

