/*
 * Decompiled with CFR 0.152.
 */
package com.highmobility.autoapi;

import com.highmobility.autoapi.Command;
import com.highmobility.autoapi.CommandParseException;
import com.highmobility.autoapi.CommandResolver;
import com.highmobility.autoapi.GetAvailabilityCommand;
import com.highmobility.autoapi.GetCommand;
import com.highmobility.autoapi.PropertyParseException;
import com.highmobility.autoapi.SetCommand;
import com.highmobility.autoapi.property.ByteEnum;
import com.highmobility.autoapi.property.Property;
import com.highmobility.autoapi.value.ActiveState;
import com.highmobility.value.Bytes;

public class PowerTakeoff {
    public static final int IDENTIFIER = 101;
    public static final byte PROPERTY_STATUS = 1;
    public static final byte PROPERTY_ENGAGED = 2;

    public static enum Engaged implements ByteEnum
    {
        NOT_ENGAGED(0),
        ENGAGED(1);

        private final byte value;

        public static Engaged fromByte(byte byteValue) throws CommandParseException {
            Engaged[] values = Engaged.values();
            for (int i = 0; i < values.length; ++i) {
                Engaged state = values[i];
                if (state.getByte() != byteValue) continue;
                return state;
            }
            throw new CommandParseException(ByteEnum.enumValueDoesNotExist(Engaged.class.getSimpleName(), byteValue));
        }

        private Engaged(byte value) {
            this.value = value;
        }

        @Override
        public byte getByte() {
            return this.value;
        }
    }

    public static class State
    extends SetCommand {
        Property<ActiveState> status = new Property<ActiveState>(ActiveState.class, 1);
        Property<Engaged> engaged = new Property<Engaged>(Engaged.class, 2);

        public Property<ActiveState> getStatus() {
            return this.status;
        }

        public Property<Engaged> getEngaged() {
            return this.engaged;
        }

        State(byte[] bytes) {
            super(bytes);
            while (this.propertyIterator.hasNext()) {
                this.propertyIterator.parseNextState(p -> {
                    switch (p.getPropertyIdentifier()) {
                        case 1: {
                            return this.status.update(p);
                        }
                        case 2: {
                            return this.engaged.update(p);
                        }
                    }
                    return null;
                });
            }
        }

        public static final class Builder
        extends SetCommand.Builder<Builder> {
            public Builder() {
                super(101);
            }

            @Override
            public State build() {
                SetCommand baseSetCommand = super.build();
                Command resolved = CommandResolver.resolve(baseSetCommand.getByteArray());
                return (State)resolved;
            }

            public Builder setStatus(Property<ActiveState> status) {
                Property<ActiveState> property = status.setIdentifier((byte)1);
                this.addProperty(property);
                return this;
            }

            public Builder setEngaged(Property<Engaged> engaged) {
                Property<Engaged> property = engaged.setIdentifier((byte)2);
                this.addProperty(property);
                return this;
            }
        }
    }

    public static class ActivateDeactivatePowerTakeoff
    extends SetCommand {
        Property<ActiveState> status = new Property<ActiveState>(ActiveState.class, 1);

        public Property<ActiveState> getStatus() {
            return this.status;
        }

        public ActivateDeactivatePowerTakeoff(ActiveState status) {
            super(101);
            this.addProperty(this.status.update(status));
            this.createBytes();
        }

        ActivateDeactivatePowerTakeoff(byte[] bytes) throws PropertyParseException {
            super(bytes);
            while (this.propertyIterator.hasNext()) {
                this.propertyIterator.parseNextSetter(p -> {
                    if (p.getPropertyIdentifier() == 1) {
                        return this.status.update(p);
                    }
                    return null;
                });
            }
            if (this.status.getValue() == null) {
                throw new PropertyParseException(this.mandatoryPropertyErrorMessage(((Object)((Object)this)).getClass()));
            }
        }
    }

    @Deprecated
    public static class GetProperties
    extends GetCommand<State> {
        public GetProperties(Bytes propertyIdentifiers) {
            super(State.class, (Integer)101, propertyIdentifiers);
        }

        public GetProperties(byte ... propertyIdentifiers) {
            super(State.class, (Integer)101, new Bytes(propertyIdentifiers));
        }

        GetProperties(byte[] bytes, boolean fromRaw) throws CommandParseException {
            super(State.class, bytes);
        }
    }

    public static class GetState
    extends GetCommand<State> {
        public GetState() {
            super(State.class, 101);
        }

        public GetState(Bytes propertyIdentifiers) {
            super(State.class, (Integer)101, propertyIdentifiers);
        }

        public GetState(byte ... propertyIdentifiers) {
            super(State.class, (Integer)101, new Bytes(propertyIdentifiers));
        }

        GetState(byte[] bytes, boolean fromRaw) throws CommandParseException {
            super(State.class, bytes);
        }
    }

    public static class GetStateAvailability
    extends GetAvailabilityCommand {
        public GetStateAvailability() {
            super(101);
        }

        public GetStateAvailability(Bytes propertyIdentifiers) {
            super(101, propertyIdentifiers);
        }

        public GetStateAvailability(byte ... propertyIdentifiers) {
            super(101, new Bytes(propertyIdentifiers));
        }

        GetStateAvailability(byte[] bytes, boolean fromRaw) throws CommandParseException {
            super(bytes);
        }
    }
}

