/*
 * Decompiled with CFR 0.152.
 */
package com.highmobility.autoapi;

import com.highmobility.autoapi.exception.ParseException;
import com.highmobility.autoapi.property.Property;
import java.util.Enumeration;

class PropertyEnumeration
implements Enumeration {
    private int cursor;
    private final byte[] bytes;

    public PropertyEnumeration(byte[] bytes) {
        this(bytes, 4);
    }

    public PropertyEnumeration(byte[] bytes, int cursor) {
        this.bytes = bytes;
        this.cursor = cursor;
    }

    @Override
    public boolean hasMoreElements() {
        return this.cursor + 3 <= this.bytes.length;
    }

    public EnumeratedProperty nextElement() {
        byte propertyIdentifier = this.bytes[this.cursor];
        int propertyStart = this.cursor + 3;
        int propertySize = 0;
        try {
            propertySize = Property.getUnsignedInt(this.bytes, this.cursor + 1, 2);
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        this.cursor += 3 + propertySize;
        return new EnumeratedProperty(propertyIdentifier, propertySize, propertyStart);
    }

    static class EnumeratedProperty {
        byte identifier;
        int size;
        int valueStart;

        public EnumeratedProperty(byte identifier, int size, int valueStart) {
            this.identifier = identifier;
            this.size = size;
            this.valueStart = valueStart;
        }

        public boolean isValid(int totalCommandLength) {
            return this.valueStart + this.size <= totalCommandLength;
        }
    }
}

