/*
 * Decompiled with CFR 0.152.
 */
package com.highmobility.autoapi;

import com.highmobility.autoapi.Command;
import com.highmobility.autoapi.CommandParseException;
import com.highmobility.autoapi.CommandResolver;
import com.highmobility.autoapi.GetAvailabilityCommand;
import com.highmobility.autoapi.GetCommand;
import com.highmobility.autoapi.SetCommand;
import com.highmobility.autoapi.property.ByteEnum;
import com.highmobility.autoapi.property.Property;
import com.highmobility.autoapi.property.PropertyInteger;
import com.highmobility.autoapi.value.Acceleration;
import com.highmobility.autoapi.value.AcceleratorDuration;
import com.highmobility.autoapi.value.ActiveState;
import com.highmobility.autoapi.value.Axle;
import com.highmobility.autoapi.value.BrakeTorqueVectoring;
import com.highmobility.autoapi.value.measurement.Angle;
import com.highmobility.autoapi.value.measurement.AngularVelocity;
import com.highmobility.autoapi.value.measurement.Pressure;
import com.highmobility.value.Bytes;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;

public class Race {
    public static final int IDENTIFIER = 87;
    public static final byte PROPERTY_ACCELERATIONS = 1;
    public static final byte PROPERTY_UNDERSTEERING = 2;
    public static final byte PROPERTY_OVERSTEERING = 3;
    public static final byte PROPERTY_GAS_PEDAL_POSITION = 4;
    public static final byte PROPERTY_STEERING_ANGLE = 5;
    public static final byte PROPERTY_BRAKE_PRESSURE = 6;
    public static final byte PROPERTY_YAW_RATE = 7;
    public static final byte PROPERTY_REAR_SUSPENSION_STEERING = 8;
    public static final byte PROPERTY_ELECTRONIC_STABILITY_PROGRAM = 9;
    public static final byte PROPERTY_BRAKE_TORQUE_VECTORINGS = 10;
    public static final byte PROPERTY_GEAR_MODE = 11;
    public static final byte PROPERTY_SELECTED_GEAR = 12;
    public static final byte PROPERTY_BRAKE_PEDAL_POSITION = 13;
    public static final byte PROPERTY_BRAKE_PEDAL_SWITCH = 14;
    public static final byte PROPERTY_CLUTCH_PEDAL_SWITCH = 15;
    public static final byte PROPERTY_ACCELERATOR_PEDAL_IDLE_SWITCH = 16;
    public static final byte PROPERTY_ACCELERATOR_PEDAL_KICKDOWN_SWITCH = 17;
    public static final byte PROPERTY_VEHICLE_MOVING = 18;
    public static final byte PROPERTY_DRIVETRAIN_STATE = 19;
    public static final byte PROPERTY_ACCELERATOR_DURATIONS = 20;

    public static enum DrivetrainState implements ByteEnum
    {
        INACTIVE(0),
        RACE_START_PREPARATION(1),
        RACE_START(2),
        START(3),
        COMFORT_START(4),
        START_IDLE_RUN_CONTROL(5),
        READY_FOR_OVERPRESSING(6),
        LOW_SPEED_MODE(7),
        E_LAUNCH(8);

        private final byte value;

        public static DrivetrainState fromByte(byte byteValue) throws CommandParseException {
            DrivetrainState[] values = DrivetrainState.values();
            for (int i = 0; i < values.length; ++i) {
                DrivetrainState state = values[i];
                if (state.getByte() != byteValue) continue;
                return state;
            }
            throw new CommandParseException(ByteEnum.enumValueDoesNotExist(DrivetrainState.class.getSimpleName(), byteValue));
        }

        private DrivetrainState(byte value) {
            this.value = value;
        }

        @Override
        public byte getByte() {
            return this.value;
        }
    }

    public static enum VehicleMoving implements ByteEnum
    {
        NOT_MOVING(0),
        MOVING(1);

        private final byte value;

        public static VehicleMoving fromByte(byte byteValue) throws CommandParseException {
            VehicleMoving[] values = VehicleMoving.values();
            for (int i = 0; i < values.length; ++i) {
                VehicleMoving state = values[i];
                if (state.getByte() != byteValue) continue;
                return state;
            }
            throw new CommandParseException(ByteEnum.enumValueDoesNotExist(VehicleMoving.class.getSimpleName(), byteValue));
        }

        private VehicleMoving(byte value) {
            this.value = value;
        }

        @Override
        public byte getByte() {
            return this.value;
        }
    }

    public static enum GearMode implements ByteEnum
    {
        MANUAL(0),
        PARK(1),
        REVERSE(2),
        NEUTRAL(3),
        DRIVE(4),
        LOW_GEAR(5),
        SPORT(6);

        private final byte value;

        public static GearMode fromByte(byte byteValue) throws CommandParseException {
            GearMode[] values = GearMode.values();
            for (int i = 0; i < values.length; ++i) {
                GearMode state = values[i];
                if (state.getByte() != byteValue) continue;
                return state;
            }
            throw new CommandParseException(ByteEnum.enumValueDoesNotExist(GearMode.class.getSimpleName(), byteValue));
        }

        private GearMode(byte value) {
            this.value = value;
        }

        @Override
        public byte getByte() {
            return this.value;
        }
    }

    public static class State
    extends SetCommand {
        List<Property<Acceleration>> accelerations;
        Property<Double> understeering = new Property<Double>(Double.class, 2);
        Property<Double> oversteering = new Property<Double>(Double.class, 3);
        Property<Double> gasPedalPosition = new Property<Double>(Double.class, 4);
        Property<Angle> steeringAngle = new Property<Angle>(Angle.class, 5);
        Property<Pressure> brakePressure = new Property<Pressure>(Pressure.class, 6);
        Property<AngularVelocity> yawRate = new Property<AngularVelocity>(AngularVelocity.class, 7);
        Property<Angle> rearSuspensionSteering = new Property<Angle>(Angle.class, 8);
        Property<ActiveState> electronicStabilityProgram = new Property<ActiveState>(ActiveState.class, 9);
        List<Property<BrakeTorqueVectoring>> brakeTorqueVectorings;
        Property<GearMode> gearMode = new Property<GearMode>(GearMode.class, 11);
        PropertyInteger selectedGear = new PropertyInteger(12, true);
        Property<Double> brakePedalPosition = new Property<Double>(Double.class, 13);
        Property<ActiveState> brakePedalSwitch = new Property<ActiveState>(ActiveState.class, 14);
        Property<ActiveState> clutchPedalSwitch = new Property<ActiveState>(ActiveState.class, 15);
        Property<ActiveState> acceleratorPedalIdleSwitch = new Property<ActiveState>(ActiveState.class, 16);
        Property<ActiveState> acceleratorPedalKickdownSwitch = new Property<ActiveState>(ActiveState.class, 17);
        Property<VehicleMoving> vehicleMoving = new Property<VehicleMoving>(VehicleMoving.class, 18);
        Property<DrivetrainState> drivetrainState = new Property<DrivetrainState>(DrivetrainState.class, 19);
        List<Property<AcceleratorDuration>> acceleratorDurations;

        public List<Property<Acceleration>> getAccelerations() {
            return this.accelerations;
        }

        public Property<Double> getUndersteering() {
            return this.understeering;
        }

        public Property<Double> getOversteering() {
            return this.oversteering;
        }

        public Property<Double> getGasPedalPosition() {
            return this.gasPedalPosition;
        }

        public Property<Angle> getSteeringAngle() {
            return this.steeringAngle;
        }

        public Property<Pressure> getBrakePressure() {
            return this.brakePressure;
        }

        public Property<AngularVelocity> getYawRate() {
            return this.yawRate;
        }

        public Property<Angle> getRearSuspensionSteering() {
            return this.rearSuspensionSteering;
        }

        public Property<ActiveState> getElectronicStabilityProgram() {
            return this.electronicStabilityProgram;
        }

        public List<Property<BrakeTorqueVectoring>> getBrakeTorqueVectorings() {
            return this.brakeTorqueVectorings;
        }

        public Property<GearMode> getGearMode() {
            return this.gearMode;
        }

        public PropertyInteger getSelectedGear() {
            return this.selectedGear;
        }

        public Property<Double> getBrakePedalPosition() {
            return this.brakePedalPosition;
        }

        public Property<ActiveState> getBrakePedalSwitch() {
            return this.brakePedalSwitch;
        }

        public Property<ActiveState> getClutchPedalSwitch() {
            return this.clutchPedalSwitch;
        }

        public Property<ActiveState> getAcceleratorPedalIdleSwitch() {
            return this.acceleratorPedalIdleSwitch;
        }

        public Property<ActiveState> getAcceleratorPedalKickdownSwitch() {
            return this.acceleratorPedalKickdownSwitch;
        }

        public Property<VehicleMoving> getVehicleMoving() {
            return this.vehicleMoving;
        }

        public Property<DrivetrainState> getDrivetrainState() {
            return this.drivetrainState;
        }

        public List<Property<AcceleratorDuration>> getAcceleratorDurations() {
            return this.acceleratorDurations;
        }

        @Nullable
        public Property<Acceleration> getAcceleration(Acceleration.Direction direction) {
            for (int i = 0; i < this.accelerations.size(); ++i) {
                Property<Acceleration> property = this.accelerations.get(i);
                if (property.getValue() == null || property.getValue().getDirection() != direction) continue;
                return property;
            }
            return null;
        }

        @Nullable
        public Property<BrakeTorqueVectoring> getBrakeTorqueVectoring(Axle axle) {
            for (int i = 0; i < this.brakeTorqueVectorings.size(); ++i) {
                Property<BrakeTorqueVectoring> property = this.brakeTorqueVectorings.get(i);
                if (property.getValue() == null || property.getValue().getAxle() != axle) continue;
                return property;
            }
            return null;
        }

        State(byte[] bytes) {
            super(bytes);
            ArrayList<Property<Acceleration>> accelerationsBuilder = new ArrayList<Property<Acceleration>>();
            ArrayList<Property<BrakeTorqueVectoring>> brakeTorqueVectoringsBuilder = new ArrayList<Property<BrakeTorqueVectoring>>();
            ArrayList<Property<AcceleratorDuration>> acceleratorDurationsBuilder = new ArrayList<Property<AcceleratorDuration>>();
            while (this.propertyIterator.hasNext()) {
                this.propertyIterator.parseNextState(p -> {
                    switch (p.getPropertyIdentifier()) {
                        case 1: {
                            Property<Acceleration> acceleration = new Property<Acceleration>(Acceleration.class, p);
                            accelerationsBuilder.add(acceleration);
                            return acceleration;
                        }
                        case 2: {
                            return this.understeering.update(p);
                        }
                        case 3: {
                            return this.oversteering.update(p);
                        }
                        case 4: {
                            return this.gasPedalPosition.update(p);
                        }
                        case 5: {
                            return this.steeringAngle.update(p);
                        }
                        case 6: {
                            return this.brakePressure.update(p);
                        }
                        case 7: {
                            return this.yawRate.update(p);
                        }
                        case 8: {
                            return this.rearSuspensionSteering.update(p);
                        }
                        case 9: {
                            return this.electronicStabilityProgram.update(p);
                        }
                        case 10: {
                            Property<BrakeTorqueVectoring> brakeTorqueVectoring = new Property<BrakeTorqueVectoring>(BrakeTorqueVectoring.class, p);
                            brakeTorqueVectoringsBuilder.add(brakeTorqueVectoring);
                            return brakeTorqueVectoring;
                        }
                        case 11: {
                            return this.gearMode.update(p);
                        }
                        case 12: {
                            return this.selectedGear.update(p);
                        }
                        case 13: {
                            return this.brakePedalPosition.update(p);
                        }
                        case 14: {
                            return this.brakePedalSwitch.update(p);
                        }
                        case 15: {
                            return this.clutchPedalSwitch.update(p);
                        }
                        case 16: {
                            return this.acceleratorPedalIdleSwitch.update(p);
                        }
                        case 17: {
                            return this.acceleratorPedalKickdownSwitch.update(p);
                        }
                        case 18: {
                            return this.vehicleMoving.update(p);
                        }
                        case 19: {
                            return this.drivetrainState.update(p);
                        }
                        case 20: {
                            Property<AcceleratorDuration> acceleratorDuration = new Property<AcceleratorDuration>(AcceleratorDuration.class, p);
                            acceleratorDurationsBuilder.add(acceleratorDuration);
                            return acceleratorDuration;
                        }
                    }
                    return null;
                });
            }
            this.accelerations = accelerationsBuilder;
            this.brakeTorqueVectorings = brakeTorqueVectoringsBuilder;
            this.acceleratorDurations = acceleratorDurationsBuilder;
        }

        public static final class Builder
        extends SetCommand.Builder<Builder> {
            public Builder() {
                super(87);
            }

            @Override
            public State build() {
                SetCommand baseSetCommand = super.build();
                Command resolved = CommandResolver.resolve(baseSetCommand.getByteArray());
                return (State)resolved;
            }

            public Builder setAccelerations(Property<Acceleration>[] accelerations) {
                for (int i = 0; i < accelerations.length; ++i) {
                    this.addAcceleration(accelerations[i]);
                }
                return this;
            }

            public Builder addAcceleration(Property<Acceleration> acceleration) {
                acceleration.setIdentifier((byte)1);
                this.addProperty(acceleration);
                return this;
            }

            public Builder setUndersteering(Property<Double> understeering) {
                Property<Double> property = understeering.setIdentifier((byte)2);
                this.addProperty(property);
                return this;
            }

            public Builder setOversteering(Property<Double> oversteering) {
                Property<Double> property = oversteering.setIdentifier((byte)3);
                this.addProperty(property);
                return this;
            }

            public Builder setGasPedalPosition(Property<Double> gasPedalPosition) {
                Property<Double> property = gasPedalPosition.setIdentifier((byte)4);
                this.addProperty(property);
                return this;
            }

            public Builder setSteeringAngle(Property<Angle> steeringAngle) {
                Property<Angle> property = steeringAngle.setIdentifier((byte)5);
                this.addProperty(property);
                return this;
            }

            public Builder setBrakePressure(Property<Pressure> brakePressure) {
                Property<Pressure> property = brakePressure.setIdentifier((byte)6);
                this.addProperty(property);
                return this;
            }

            public Builder setYawRate(Property<AngularVelocity> yawRate) {
                Property<AngularVelocity> property = yawRate.setIdentifier((byte)7);
                this.addProperty(property);
                return this;
            }

            public Builder setRearSuspensionSteering(Property<Angle> rearSuspensionSteering) {
                Property<Angle> property = rearSuspensionSteering.setIdentifier((byte)8);
                this.addProperty(property);
                return this;
            }

            public Builder setElectronicStabilityProgram(Property<ActiveState> electronicStabilityProgram) {
                Property<ActiveState> property = electronicStabilityProgram.setIdentifier((byte)9);
                this.addProperty(property);
                return this;
            }

            public Builder setBrakeTorqueVectorings(Property<BrakeTorqueVectoring>[] brakeTorqueVectorings) {
                for (int i = 0; i < brakeTorqueVectorings.length; ++i) {
                    this.addBrakeTorqueVectoring(brakeTorqueVectorings[i]);
                }
                return this;
            }

            public Builder addBrakeTorqueVectoring(Property<BrakeTorqueVectoring> brakeTorqueVectoring) {
                brakeTorqueVectoring.setIdentifier((byte)10);
                this.addProperty(brakeTorqueVectoring);
                return this;
            }

            public Builder setGearMode(Property<GearMode> gearMode) {
                Property<GearMode> property = gearMode.setIdentifier((byte)11);
                this.addProperty(property);
                return this;
            }

            public Builder setSelectedGear(Property<Integer> selectedGear) {
                PropertyInteger property = new PropertyInteger(12, true, 1, selectedGear);
                this.addProperty(property);
                return this;
            }

            public Builder setBrakePedalPosition(Property<Double> brakePedalPosition) {
                Property<Double> property = brakePedalPosition.setIdentifier((byte)13);
                this.addProperty(property);
                return this;
            }

            public Builder setBrakePedalSwitch(Property<ActiveState> brakePedalSwitch) {
                Property<ActiveState> property = brakePedalSwitch.setIdentifier((byte)14);
                this.addProperty(property);
                return this;
            }

            public Builder setClutchPedalSwitch(Property<ActiveState> clutchPedalSwitch) {
                Property<ActiveState> property = clutchPedalSwitch.setIdentifier((byte)15);
                this.addProperty(property);
                return this;
            }

            public Builder setAcceleratorPedalIdleSwitch(Property<ActiveState> acceleratorPedalIdleSwitch) {
                Property<ActiveState> property = acceleratorPedalIdleSwitch.setIdentifier((byte)16);
                this.addProperty(property);
                return this;
            }

            public Builder setAcceleratorPedalKickdownSwitch(Property<ActiveState> acceleratorPedalKickdownSwitch) {
                Property<ActiveState> property = acceleratorPedalKickdownSwitch.setIdentifier((byte)17);
                this.addProperty(property);
                return this;
            }

            public Builder setVehicleMoving(Property<VehicleMoving> vehicleMoving) {
                Property<VehicleMoving> property = vehicleMoving.setIdentifier((byte)18);
                this.addProperty(property);
                return this;
            }

            public Builder setDrivetrainState(Property<DrivetrainState> drivetrainState) {
                Property<DrivetrainState> property = drivetrainState.setIdentifier((byte)19);
                this.addProperty(property);
                return this;
            }

            public Builder setAcceleratorDurations(Property<AcceleratorDuration>[] acceleratorDurations) {
                for (int i = 0; i < acceleratorDurations.length; ++i) {
                    this.addAcceleratorDuration(acceleratorDurations[i]);
                }
                return this;
            }

            public Builder addAcceleratorDuration(Property<AcceleratorDuration> acceleratorDuration) {
                acceleratorDuration.setIdentifier((byte)20);
                this.addProperty(acceleratorDuration);
                return this;
            }
        }
    }

    @Deprecated
    public static class GetProperties
    extends GetCommand<State> {
        public GetProperties(Bytes propertyIdentifiers) {
            super(State.class, (Integer)87, propertyIdentifiers);
        }

        public GetProperties(byte ... propertyIdentifiers) {
            super(State.class, (Integer)87, new Bytes(propertyIdentifiers));
        }

        GetProperties(byte[] bytes, boolean fromRaw) throws CommandParseException {
            super(State.class, bytes);
        }
    }

    public static class GetState
    extends GetCommand<State> {
        public GetState() {
            super(State.class, 87);
        }

        public GetState(Bytes propertyIdentifiers) {
            super(State.class, (Integer)87, propertyIdentifiers);
        }

        public GetState(byte ... propertyIdentifiers) {
            super(State.class, (Integer)87, new Bytes(propertyIdentifiers));
        }

        GetState(byte[] bytes, boolean fromRaw) throws CommandParseException {
            super(State.class, bytes);
        }
    }

    public static class GetStateAvailability
    extends GetAvailabilityCommand {
        public GetStateAvailability() {
            super(87);
        }

        public GetStateAvailability(Bytes propertyIdentifiers) {
            super(87, propertyIdentifiers);
        }

        public GetStateAvailability(byte ... propertyIdentifiers) {
            super(87, new Bytes(propertyIdentifiers));
        }

        GetStateAvailability(byte[] bytes, boolean fromRaw) throws CommandParseException {
            super(bytes);
        }
    }
}

