/*
 * Decompiled with CFR 0.152.
 */
package com.highmobility.autoapi;

import com.highmobility.autoapi.CommandParseException;
import com.highmobility.autoapi.GetAvailabilityCommand;
import com.highmobility.autoapi.GetCommand;
import com.highmobility.autoapi.PropertyParseException;
import com.highmobility.autoapi.SetCommand;
import com.highmobility.autoapi.capability.DisabledIn;
import com.highmobility.autoapi.property.ByteEnum;
import com.highmobility.autoapi.property.Property;
import com.highmobility.autoapi.value.measurement.Angle;
import com.highmobility.autoapi.value.measurement.Speed;
import com.highmobility.value.Bytes;
import javax.annotation.Nullable;

public class RemoteControl {
    public static final int IDENTIFIER = 39;
    public static final byte PROPERTY_CONTROL_MODE = 1;
    public static final byte PROPERTY_ANGLE = 2;
    public static final byte PROPERTY_SPEED = 3;
    public static final DisabledIn[] disabledIn = new DisabledIn[]{DisabledIn.WEB};

    public static enum ControlMode implements ByteEnum
    {
        UNAVAILABLE(0),
        AVAILABLE(1),
        STARTED(2),
        FAILED_TO_START(3),
        ABORTED(4),
        ENDED(5);

        private final byte value;

        public static ControlMode fromByte(byte byteValue) throws CommandParseException {
            ControlMode[] values = ControlMode.values();
            for (int i = 0; i < values.length; ++i) {
                ControlMode state = values[i];
                if (state.getByte() != byteValue) continue;
                return state;
            }
            throw new CommandParseException(ByteEnum.enumValueDoesNotExist(ControlMode.class.getSimpleName(), byteValue));
        }

        private ControlMode(byte value) {
            this.value = value;
        }

        @Override
        public byte getByte() {
            return this.value;
        }
    }

    public static class State
    extends SetCommand {
        Property<ControlMode> controlMode = new Property<ControlMode>(ControlMode.class, 1);
        Property<Angle> angle = new Property<Angle>(Angle.class, 2);

        public Property<ControlMode> getControlMode() {
            return this.controlMode;
        }

        public Property<Angle> getAngle() {
            return this.angle;
        }

        State(byte[] bytes) {
            super(bytes);
            while (this.propertyIterator.hasNext()) {
                this.propertyIterator.parseNextState(p -> {
                    switch (p.getPropertyIdentifier()) {
                        case 1: {
                            return this.controlMode.update(p);
                        }
                        case 2: {
                            return this.angle.update(p);
                        }
                    }
                    return null;
                });
            }
        }
    }

    public static class StopControl
    extends SetCommand {
        Property<ControlMode> controlMode = new Property<ControlMode>(ControlMode.class, 1);

        public StopControl() {
            super(39);
            this.addProperty(this.controlMode.addValueComponent(new Bytes("05")));
            this.createBytes();
        }

        StopControl(byte[] bytes) throws PropertyParseException {
            super(bytes);
            while (this.propertyIterator.hasNext()) {
                this.propertyIterator.parseNextSetter(p -> {
                    if (p.getPropertyIdentifier() == 1) {
                        return this.controlMode.update(p);
                    }
                    return null;
                });
            }
            if (this.controlMode.getValue() == null || !this.controlMode.getValueComponent().getValueBytes().equals((Object)"05")) {
                throw new PropertyParseException(this.mandatoryPropertyErrorMessage(((Object)((Object)this)).getClass()));
            }
        }
    }

    public static class StartControl
    extends SetCommand {
        Property<ControlMode> controlMode = new Property<ControlMode>(ControlMode.class, 1);

        public StartControl() {
            super(39);
            this.addProperty(this.controlMode.addValueComponent(new Bytes("02")));
            this.createBytes();
        }

        StartControl(byte[] bytes) throws PropertyParseException {
            super(bytes);
            while (this.propertyIterator.hasNext()) {
                this.propertyIterator.parseNextSetter(p -> {
                    if (p.getPropertyIdentifier() == 1) {
                        return this.controlMode.update(p);
                    }
                    return null;
                });
            }
            if (this.controlMode.getValue() == null || !this.controlMode.getValueComponent().getValueBytes().equals((Object)"02")) {
                throw new PropertyParseException(this.mandatoryPropertyErrorMessage(((Object)((Object)this)).getClass()));
            }
        }
    }

    public static class ControlCommand
    extends SetCommand {
        Property<Angle> angle = new Property<Angle>(Angle.class, 2);
        Property<Speed> speed = new Property<Speed>(Speed.class, 3);

        public Property<Angle> getAngle() {
            return this.angle;
        }

        public Property<Speed> getSpeed() {
            return this.speed;
        }

        public ControlCommand(@Nullable Angle angle, @Nullable Speed speed) {
            super(39);
            this.addProperty(this.angle.update(angle));
            this.addProperty(this.speed.update(speed));
            if (this.angle.getValue() == null && this.speed.getValue() == null) {
                throw new IllegalArgumentException();
            }
            this.createBytes();
        }

        ControlCommand(byte[] bytes) throws PropertyParseException {
            super(bytes);
            while (this.propertyIterator.hasNext()) {
                this.propertyIterator.parseNextSetter(p -> {
                    switch (p.getPropertyIdentifier()) {
                        case 2: {
                            return this.angle.update(p);
                        }
                        case 3: {
                            return this.speed.update(p);
                        }
                    }
                    return null;
                });
            }
            if (this.angle.getValue() == null && this.speed.getValue() == null) {
                throw new PropertyParseException(this.optionalPropertyErrorMessage(((Object)((Object)this)).getClass()));
            }
        }
    }

    public static class GetControlState
    extends GetCommand<State> {
        public GetControlState() {
            super(State.class, 39);
        }

        GetControlState(byte[] bytes, boolean fromRaw) throws CommandParseException {
            super(State.class, bytes);
        }
    }

    public static class GetControlStateAvailability
    extends GetAvailabilityCommand {
        public GetControlStateAvailability() {
            super(39);
        }

        GetControlStateAvailability(byte[] bytes, boolean fromRaw) throws CommandParseException {
            super(bytes);
        }
    }
}

