/*
 * Decompiled with CFR 0.152.
 */
package com.highmobility.autoapi;

import com.highmobility.autoapi.Command;
import com.highmobility.autoapi.exception.ParseException;
import com.highmobility.autoapi.property.Property;
import com.highmobility.autoapi.value.Brand;
import com.highmobility.value.Bytes;
import java.util.ArrayList;
import java.util.Calendar;

public class SetCommand
extends Command {
    ArrayList<Property> propertiesBuilder;

    SetCommand(Integer identifier) {
        this.identifier = identifier;
        this.type = 1;
    }

    protected void addProperty(Property property) {
        if (property == null || property.getValueComponent() == null) {
            return;
        }
        if (this.propertiesBuilder == null) {
            this.propertiesBuilder = new ArrayList();
        }
        this.propertiesBuilder.add(property);
    }

    protected void createBytes() {
        if (this.propertiesBuilder == null) {
            this.propertiesBuilder = new ArrayList();
        }
        this.findUniversalProperties(this.identifier, this.type, this.propertiesBuilder.toArray(new Property[0]), true);
    }

    protected String mandatoryPropertyErrorMessage(Class clazz) {
        return "Mandatory property does not exists for " + clazz.getSimpleName();
    }

    protected String optionalPropertyErrorMessage(Class clazz) {
        return "Optional property does not exists for " + clazz.getSimpleName();
    }

    SetCommand(byte[] bytes) throws ParseException {
        super(bytes);
        if (bytes[3] != 1) {
            throw new ParseException();
        }
    }

    public SetCommand(Builder builder) {
        super(builder.identifier, (Integer)1, builder.getPropertiesArray());
    }

    public static class Builder<Child> {
        private final Integer identifier;
        private ArrayList<Property> propertiesBuilder = new ArrayList();

        public Builder(Integer identifier) {
            this.identifier = identifier;
        }

        public Child addProperty(Property property) {
            this.propertiesBuilder.add(property);
            return (Child)this;
        }

        public Child setNonce(Bytes nonce) {
            this.addProperty(new Property<Bytes>(-96, nonce));
            return (Child)this;
        }

        public Child setSignature(Bytes signature) {
            this.addProperty(new Property<Bytes>(-95, signature));
            return (Child)this;
        }

        public Child setTimestamp(Calendar timestamp) {
            this.addProperty(new Property<Calendar>(-94, timestamp));
            return (Child)this;
        }

        public Child setVin(String vin) {
            this.addProperty(new Property<String>(-93, vin));
            return (Child)this;
        }

        public Child setBrand(Brand brand) {
            this.addProperty(new Property<Brand>(-92, brand));
            return (Child)this;
        }

        public SetCommand build() {
            return new SetCommand(this);
        }

        public Property[] getProperties() {
            return this.propertiesBuilder.toArray(new Property[0]);
        }

        private Property[] getPropertiesArray() {
            return this.propertiesBuilder.toArray(new Property[0]);
        }
    }

    public static final class BaseBuilder
    extends Builder<BaseBuilder> {
        public BaseBuilder(Integer identifier) {
            super(identifier);
        }
    }
}

