/*
 * Decompiled with CFR 0.152.
 */
package com.highmobility.autoapi;

import com.highmobility.autoapi.Command;
import com.highmobility.autoapi.CommandParseException;
import com.highmobility.autoapi.CommandResolver;
import com.highmobility.autoapi.GetAvailabilityCommand;
import com.highmobility.autoapi.GetCommand;
import com.highmobility.autoapi.PropertyParseException;
import com.highmobility.autoapi.SetCommand;
import com.highmobility.autoapi.property.ByteEnum;
import com.highmobility.autoapi.property.Property;
import com.highmobility.autoapi.value.ActiveSelectedState;
import com.highmobility.autoapi.value.Triggered;
import com.highmobility.value.Bytes;
import java.util.Calendar;

public class TheftAlarm {
    public static final int IDENTIFIER = 70;
    public static final byte PROPERTY_STATUS = 1;
    public static final byte PROPERTY_INTERIOR_PROTECTION_STATUS = 2;
    public static final byte PROPERTY_TOW_PROTECTION_STATUS = 3;
    public static final byte PROPERTY_LAST_WARNING_REASON = 4;
    public static final byte PROPERTY_LAST_EVENT = 5;
    public static final byte PROPERTY_LAST_EVENT_LEVEL = 6;
    public static final byte PROPERTY_EVENT_TYPE = 7;
    public static final byte PROPERTY_INTERIOR_PROTECTION_TRIGGERED = 8;
    public static final byte PROPERTY_TOW_PROTECTION_TRIGGERED = 9;

    public static enum EventType implements ByteEnum
    {
        IDLE(0),
        FRONT_LEFT(1),
        FRONT_MIDDLE(2),
        FRONT_RIGHT(3),
        RIGHT(4),
        REAR_RIGHT(5),
        REAR_MIDDLE(6),
        REAR_LEFT(7),
        LEFT(8),
        UNKNOWN(9);

        private final byte value;

        public static EventType fromByte(byte byteValue) throws CommandParseException {
            EventType[] values = EventType.values();
            for (int i = 0; i < values.length; ++i) {
                EventType state = values[i];
                if (state.getByte() != byteValue) continue;
                return state;
            }
            throw new CommandParseException(ByteEnum.enumValueDoesNotExist(EventType.class.getSimpleName(), byteValue));
        }

        private EventType(byte value) {
            this.value = value;
        }

        @Override
        public byte getByte() {
            return this.value;
        }
    }

    public static enum LastEventLevel implements ByteEnum
    {
        LOW(0),
        MEDIUM(1),
        HIGH(2);

        private final byte value;

        public static LastEventLevel fromByte(byte byteValue) throws CommandParseException {
            LastEventLevel[] values = LastEventLevel.values();
            for (int i = 0; i < values.length; ++i) {
                LastEventLevel state = values[i];
                if (state.getByte() != byteValue) continue;
                return state;
            }
            throw new CommandParseException(ByteEnum.enumValueDoesNotExist(LastEventLevel.class.getSimpleName(), byteValue));
        }

        private LastEventLevel(byte value) {
            this.value = value;
        }

        @Override
        public byte getByte() {
            return this.value;
        }
    }

    public static enum LastWarningReason implements ByteEnum
    {
        NO_ALARM(0),
        BASIC_ALARM(1),
        DOOR_FRONT_LEFT(2),
        DOOR_FRONT_RIGHT(3),
        DOOR_REAR_LEFT(4),
        DOOR_REAR_RIGHT(5),
        HOOD(6),
        TRUNK(7),
        COMMON_ALM_IN(8),
        PANIC(9),
        GLOVEBOX(10),
        CENTER_BOX(11),
        REAR_BOX(12),
        SENSOR_VTA(13),
        ITS(14),
        ITS_SLV(15),
        TPS(16),
        HORN(17),
        HOLD_COM(18),
        REMOTE(19),
        UNKNOWN(20),
        SIREN(21);

        private final byte value;

        public static LastWarningReason fromByte(byte byteValue) throws CommandParseException {
            LastWarningReason[] values = LastWarningReason.values();
            for (int i = 0; i < values.length; ++i) {
                LastWarningReason state = values[i];
                if (state.getByte() != byteValue) continue;
                return state;
            }
            throw new CommandParseException(ByteEnum.enumValueDoesNotExist(LastWarningReason.class.getSimpleName(), byteValue));
        }

        private LastWarningReason(byte value) {
            this.value = value;
        }

        @Override
        public byte getByte() {
            return this.value;
        }
    }

    public static enum Status implements ByteEnum
    {
        UNARMED(0),
        ARMED(1),
        TRIGGERED(2);

        private final byte value;

        public static Status fromByte(byte byteValue) throws CommandParseException {
            Status[] values = Status.values();
            for (int i = 0; i < values.length; ++i) {
                Status state = values[i];
                if (state.getByte() != byteValue) continue;
                return state;
            }
            throw new CommandParseException(ByteEnum.enumValueDoesNotExist(Status.class.getSimpleName(), byteValue));
        }

        private Status(byte value) {
            this.value = value;
        }

        @Override
        public byte getByte() {
            return this.value;
        }
    }

    public static class State
    extends SetCommand {
        Property<Status> status = new Property<Status>(Status.class, 1);
        Property<ActiveSelectedState> interiorProtectionStatus = new Property<ActiveSelectedState>(ActiveSelectedState.class, 2);
        Property<ActiveSelectedState> towProtectionStatus = new Property<ActiveSelectedState>(ActiveSelectedState.class, 3);
        Property<LastWarningReason> lastWarningReason = new Property<LastWarningReason>(LastWarningReason.class, 4);
        Property<Calendar> lastEvent = new Property<Calendar>(Calendar.class, 5);
        Property<LastEventLevel> lastEventLevel = new Property<LastEventLevel>(LastEventLevel.class, 6);
        Property<EventType> eventType = new Property<EventType>(EventType.class, 7);
        Property<Triggered> interiorProtectionTriggered = new Property<Triggered>(Triggered.class, 8);
        Property<Triggered> towProtectionTriggered = new Property<Triggered>(Triggered.class, 9);

        public Property<Status> getStatus() {
            return this.status;
        }

        public Property<ActiveSelectedState> getInteriorProtectionStatus() {
            return this.interiorProtectionStatus;
        }

        public Property<ActiveSelectedState> getTowProtectionStatus() {
            return this.towProtectionStatus;
        }

        public Property<LastWarningReason> getLastWarningReason() {
            return this.lastWarningReason;
        }

        public Property<Calendar> getLastEvent() {
            return this.lastEvent;
        }

        public Property<LastEventLevel> getLastEventLevel() {
            return this.lastEventLevel;
        }

        public Property<EventType> getEventType() {
            return this.eventType;
        }

        public Property<Triggered> getInteriorProtectionTriggered() {
            return this.interiorProtectionTriggered;
        }

        public Property<Triggered> getTowProtectionTriggered() {
            return this.towProtectionTriggered;
        }

        State(byte[] bytes) {
            super(bytes);
            while (this.propertyIterator.hasNext()) {
                this.propertyIterator.parseNextState(p -> {
                    switch (p.getPropertyIdentifier()) {
                        case 1: {
                            return this.status.update(p);
                        }
                        case 2: {
                            return this.interiorProtectionStatus.update(p);
                        }
                        case 3: {
                            return this.towProtectionStatus.update(p);
                        }
                        case 4: {
                            return this.lastWarningReason.update(p);
                        }
                        case 5: {
                            return this.lastEvent.update(p);
                        }
                        case 6: {
                            return this.lastEventLevel.update(p);
                        }
                        case 7: {
                            return this.eventType.update(p);
                        }
                        case 8: {
                            return this.interiorProtectionTriggered.update(p);
                        }
                        case 9: {
                            return this.towProtectionTriggered.update(p);
                        }
                    }
                    return null;
                });
            }
        }

        public static final class Builder
        extends SetCommand.Builder<Builder> {
            public Builder() {
                super(70);
            }

            @Override
            public State build() {
                SetCommand baseSetCommand = super.build();
                Command resolved = CommandResolver.resolve(baseSetCommand.getByteArray());
                return (State)resolved;
            }

            public Builder setStatus(Property<Status> status) {
                Property<Status> property = status.setIdentifier((byte)1);
                this.addProperty(property);
                return this;
            }

            public Builder setInteriorProtectionStatus(Property<ActiveSelectedState> interiorProtectionStatus) {
                Property<ActiveSelectedState> property = interiorProtectionStatus.setIdentifier((byte)2);
                this.addProperty(property);
                return this;
            }

            public Builder setTowProtectionStatus(Property<ActiveSelectedState> towProtectionStatus) {
                Property<ActiveSelectedState> property = towProtectionStatus.setIdentifier((byte)3);
                this.addProperty(property);
                return this;
            }

            public Builder setLastWarningReason(Property<LastWarningReason> lastWarningReason) {
                Property<LastWarningReason> property = lastWarningReason.setIdentifier((byte)4);
                this.addProperty(property);
                return this;
            }

            public Builder setLastEvent(Property<Calendar> lastEvent) {
                Property<Calendar> property = lastEvent.setIdentifier((byte)5);
                this.addProperty(property);
                return this;
            }

            public Builder setLastEventLevel(Property<LastEventLevel> lastEventLevel) {
                Property<LastEventLevel> property = lastEventLevel.setIdentifier((byte)6);
                this.addProperty(property);
                return this;
            }

            public Builder setEventType(Property<EventType> eventType) {
                Property<EventType> property = eventType.setIdentifier((byte)7);
                this.addProperty(property);
                return this;
            }

            public Builder setInteriorProtectionTriggered(Property<Triggered> interiorProtectionTriggered) {
                Property<Triggered> property = interiorProtectionTriggered.setIdentifier((byte)8);
                this.addProperty(property);
                return this;
            }

            public Builder setTowProtectionTriggered(Property<Triggered> towProtectionTriggered) {
                Property<Triggered> property = towProtectionTriggered.setIdentifier((byte)9);
                this.addProperty(property);
                return this;
            }
        }
    }

    public static class SetTheftAlarm
    extends SetCommand {
        Property<Status> status = new Property<Status>(Status.class, 1);

        public Property<Status> getStatus() {
            return this.status;
        }

        public SetTheftAlarm(Status status) {
            super(70);
            this.addProperty(this.status.update(status));
            this.createBytes();
        }

        SetTheftAlarm(byte[] bytes) throws PropertyParseException {
            super(bytes);
            while (this.propertyIterator.hasNext()) {
                this.propertyIterator.parseNextSetter(p -> {
                    if (p.getPropertyIdentifier() == 1) {
                        return this.status.update(p);
                    }
                    return null;
                });
            }
            if (this.status.getValue() == null) {
                throw new PropertyParseException(this.mandatoryPropertyErrorMessage(((Object)((Object)this)).getClass()));
            }
        }
    }

    @Deprecated
    public static class GetProperties
    extends GetCommand<State> {
        public GetProperties(Bytes propertyIdentifiers) {
            super(State.class, (Integer)70, propertyIdentifiers);
        }

        public GetProperties(byte ... propertyIdentifiers) {
            super(State.class, (Integer)70, new Bytes(propertyIdentifiers));
        }

        GetProperties(byte[] bytes, boolean fromRaw) throws CommandParseException {
            super(State.class, bytes);
        }
    }

    public static class GetState
    extends GetCommand<State> {
        public GetState() {
            super(State.class, 70);
        }

        public GetState(Bytes propertyIdentifiers) {
            super(State.class, (Integer)70, propertyIdentifiers);
        }

        public GetState(byte ... propertyIdentifiers) {
            super(State.class, (Integer)70, new Bytes(propertyIdentifiers));
        }

        GetState(byte[] bytes, boolean fromRaw) throws CommandParseException {
            super(State.class, bytes);
        }
    }

    public static class GetStateAvailability
    extends GetAvailabilityCommand {
        public GetStateAvailability() {
            super(70);
        }

        public GetStateAvailability(Bytes propertyIdentifiers) {
            super(70, propertyIdentifiers);
        }

        public GetStateAvailability(byte ... propertyIdentifiers) {
            super(70, new Bytes(propertyIdentifiers));
        }

        GetStateAvailability(byte[] bytes, boolean fromRaw) throws CommandParseException {
            super(bytes);
        }
    }
}

